/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.internal.tail;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.inject.Inject;
import org.xwiki.component.annotation.Component;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.logging.internal.tail.AbstractTextFileLoggerTail;
import org.xwiki.xstream.internal.SafeXStream;

@Component(roles={XStreamFileLoggerTail.class})
public class XStreamFileLoggerTail
extends AbstractTextFileLoggerTail {
    protected static final String FILE_EXTENSION = ".xml";
    @Inject
    private SafeXStream xstream;

    @Override
    public void initialize(Path path, boolean readonly) throws IOException {
        super.initialize(path, StandardCharsets.UTF_8, readonly);
    }

    @Override
    protected String getFileExtension() {
        return FILE_EXTENSION;
    }

    public static boolean exist(Path path) {
        return XStreamFileLoggerTail.exist(path, FILE_EXTENSION);
    }

    @Override
    protected LogEvent read(Reader reader) {
        return (LogEvent)this.xstream.fromXML(reader);
    }

    @Override
    protected void write(LogEvent logEvent, Writer writer) {
        this.xstream.toXML((Object)logEvent, writer);
    }
}

