/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.management.internal;

import java.lang.management.ManagementFactory;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.management.JMXBeanRegistration;

@Component
@Singleton
public class DefaultJMXBeanRegistration
implements JMXBeanRegistration {
    private static final String OBJECTNAME_PREFIX = "org.xwiki:";
    @Inject
    private Logger logger;

    @Override
    public void registerMBean(Object mbean, String name) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName oname = new ObjectName(OBJECTNAME_PREFIX + name);
            mbs.registerMBean(mbean, oname);
            this.logger.debug("Registered resource with name [{}]", (Object)name);
        }
        catch (Exception e) {
            this.logger.warn("Failed to register resource with name [{}]. Reason = [{}]", (Object)name, (Object)ExceptionUtils.getMessage((Throwable)e));
        }
    }

    @Override
    public void unregisterMBean(String name) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName oname = new ObjectName(OBJECTNAME_PREFIX + name);
            mbs.unregisterMBean(oname);
            this.logger.debug("Unregistered resource with name [{}]", (Object)name);
        }
        catch (Exception e) {
            this.logger.warn("Failed to unregister resource with name [{}]. Reason = [{}]", (Object)name, (Object)ExceptionUtils.getMessage((Throwable)e));
        }
    }
}

