/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation.internal;

import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.observation.ObservationContext;
import org.xwiki.observation.event.BeginEvent;

@Component
@Singleton
public class DefaultObservationContext
implements ObservationContext {
    static final String KEY_EVENTS = "observation.currentevents";
    @Inject
    private Execution execution;

    private Stack<BeginEvent> getCurrentEvents() {
        Stack events = null;
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            events = (Stack)context.getProperty(KEY_EVENTS);
        }
        return events;
    }

    public boolean isIn(BeginEvent event) {
        Stack<BeginEvent> events = this.getCurrentEvents();
        if (events != null) {
            for (BeginEvent currentEvent : events) {
                if (!event.matches((Object)currentEvent)) continue;
                return true;
            }
        }
        return false;
    }
}

