/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.properties.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.properties.ConverterManager;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.properties.converter.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Singleton
public class DefaultConverterManager
extends AbstractLogEnabled
implements ConverterManager {
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="enum")
    private Converter enumConverter;
    @Inject
    private Converter defaultConverter;

    @Override
    public <T> T convert(Type targetType, Object value) {
        Converter converter = this.lookupConverter(targetType);
        if (converter != null) {
            return converter.convert(targetType, value);
        }
        throw new ConversionException("Can't find converter to convert value [" + value + "] to type [" + targetType + "] ");
    }

    private Converter lookupConverter(Type targetType) {
        String typeGenericName;
        Converter converter;
        block7: {
            converter = null;
            typeGenericName = this.getTypeGenericName(targetType);
            try {
                converter = (Converter)this.componentManager.lookup(Converter.class, this.getTypeGenericName(targetType));
            }
            catch (ComponentLookupException e) {
                this.getLogger().debug("Failed to find a proper Converter for type [" + typeGenericName + "]", (Throwable)e);
                if (!(targetType instanceof ParameterizedType)) break block7;
                String typeName = this.getTypeName(targetType);
                try {
                    converter = (Converter)this.componentManager.lookup(Converter.class, typeName);
                }
                catch (ComponentLookupException e2) {
                    this.getLogger().debug("Failed to find a proper Converter for class [" + typeName + "]", (Throwable)e);
                }
            }
        }
        if (converter == null) {
            if (targetType instanceof Class && Enum.class.isAssignableFrom((Class)targetType)) {
                converter = this.enumConverter;
            } else {
                this.getLogger().debug("Trying default Converter for target type [" + typeGenericName + "]");
                converter = this.defaultConverter;
            }
        }
        return converter;
    }

    private String getTypeName(Type type) {
        String name = type instanceof Class ? ((Class)type).getName() : (type instanceof ParameterizedType ? ((Class)((ParameterizedType)type).getRawType()).getName() : type.toString());
        return name;
    }

    private String getTypeGenericName(Type type) {
        ParameterizedType parameterizedType;
        Type[] generics;
        StringBuilder sb = new StringBuilder(this.getTypeName(type));
        if (type instanceof ParameterizedType && (generics = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length > 0) {
            sb.append('<');
            for (int i = 0; i < generics.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.getTypeGenericName(generics[i]));
            }
            sb.append('>');
        }
        return sb.toString();
    }
}

