/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.properties.internal.converter;

import java.lang.reflect.Type;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;

@Component
@Named(value="enum")
@Singleton
public class EnumConverter
extends AbstractConverter {
    @Override
    protected <T> T convertToType(Type type, Object value) {
        if (value != null) {
            Object[] enumValues = ((Class)type).getEnumConstants();
            String testValue = value.toString();
            for (Object t : enumValues) {
                if (!t.toString().equalsIgnoreCase(testValue)) continue;
                return t;
            }
            throw new ConversionException(this.generateInvalidErrorMessage(enumValues, testValue));
        }
        return null;
    }

    private String generateInvalidErrorMessage(Object[] enumValues, String testValue) {
        StringBuffer errorMessage = new StringBuffer("Unable to convert value [" + testValue + "].");
        errorMessage.append(" Allowed values are (case insensitive) ");
        StringBuffer valueList = new StringBuffer();
        int index = 1;
        for (Object enumValue : enumValues) {
            if (valueList.length() > 0) {
                if (++index == enumValues.length) {
                    valueList.append(" or ");
                } else {
                    valueList.append(", ");
                }
            }
            valueList.append('\"');
            valueList.append(enumValue);
            valueList.append('\"');
        }
        errorMessage.append(valueList);
        errorMessage.append('.');
        return errorMessage.toString();
    }
}

