/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.properties.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.properties.ConverterManager;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.properties.converter.Converter;

@Component
@Singleton
public class DefaultConverterManager
implements ConverterManager {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Converter<Enum> enumConverter;
    @Inject
    private Converter defaultConverter;
    @Inject
    private Logger logger;

    @Override
    public <T> T convert(Type targetType, Object value) {
        Converter<T> converter;
        if (targetType instanceof Class && ((Class)targetType).isInstance(value)) {
            return (T)value;
        }
        Class<?> converterType = targetType;
        if (converterType == String.class && value != null) {
            converterType = value.getClass();
        }
        if ((converter = this.lookupConverter(converterType)) != null) {
            return (T)converter.convert(targetType, value);
        }
        throw new ConversionException("Cannot find Converter to convert value [" + value + "] to type [" + targetType + "] ");
    }

    private <T> Converter<T> lookupConverter(Type targetType) {
        Converter<T> converter = this.getConverter(targetType);
        if (converter == null && targetType instanceof ParameterizedType) {
            Class targetClass = ReflectionUtils.getTypeClass((Type)targetType);
            converter = this.getConverter(targetClass);
        }
        if (converter == null) {
            if (targetType instanceof Class && Enum.class.isAssignableFrom((Class)targetType)) {
                converter = this.enumConverter;
            } else {
                this.logger.debug("Using the default Converter for type [{}]", (Object)targetType);
                converter = this.defaultConverter;
            }
        }
        return converter;
    }

    private <T> Converter<T> getConverter(Type targetType) {
        try {
            DefaultParameterizedType converterType = new DefaultParameterizedType(null, Converter.class, new Type[]{targetType});
            if (this.componentManager.hasComponent((Type)converterType)) {
                return (Converter)this.componentManager.getInstance((Type)converterType);
            }
            String typeGenericName = this.getTypeGenericName(targetType);
            if (this.componentManager.hasComponent(Converter.class, typeGenericName)) {
                return (Converter)this.componentManager.getInstance(Converter.class, typeGenericName);
            }
        }
        catch (ComponentLookupException e) {
            throw new ConversionException("Failed to initialize converter for target type [" + targetType + "]", e);
        }
        return null;
    }

    private String getTypeName(Type type) {
        String name = type instanceof Class ? ((Class)type).getName() : (type instanceof ParameterizedType ? ((Class)((ParameterizedType)type).getRawType()).getName() : type.toString());
        return name;
    }

    private String getTypeGenericName(Type type) {
        ParameterizedType parameterizedType;
        Type[] generics;
        StringBuilder sb = new StringBuilder(this.getTypeName(type));
        if (type instanceof ParameterizedType && (generics = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length > 0) {
            sb.append('<');
            for (int i = 0; i < generics.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.getTypeGenericName(generics[i]));
            }
            sb.append('>');
        }
        return sb.toString();
    }
}

