/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.xwiki.test.isolation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Define for a test class @RunWith(IsolatedTestRunner.class), the list of class prefix that will be isolated.
 *
 * @version $Id: 4a3d031da853fbc5aa33a6386a5e0cb7b4444775 $
 * @since 5.0M2
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Inherited
public @interface IsolatedClassPrefix {
    /**
     * @return
     */
    // TODO: I would have liked to put the following documentation in the @return javadoc annotation above:
    // "the list of class name prefix that will be isolated for this test". But Checkstyle is buggy, see:
    // http://sourceforge.net/tracker/?func=detail&atid=397078&aid=2685184&group_id=29721
    String[] value();
}
