/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test;

import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.embed.EmbeddableComponentManager;
import org.xwiki.test.AbstractMockingTestCase;
import org.xwiki.test.MockConfigurationSource;
import org.xwiki.test.XWikiComponentInitializer;

public class AbstractComponentTestCase
extends AbstractMockingTestCase {
    private XWikiComponentInitializer initializer = new XWikiComponentInitializer();
    private ComponentAnnotationLoader componentLoader;

    @Before
    public void setUp() throws Exception {
        this.initializer.initializeConfigurationSource();
        this.registerComponents();
        this.initializer.initializeExecution();
    }

    @After
    public void tearDown() throws Exception {
        this.initializer.shutdown();
    }

    protected void registerComponents() throws Exception {
    }

    public EmbeddableComponentManager getComponentManager() throws Exception {
        return this.initializer.getComponentManager();
    }

    public MockConfigurationSource getConfigurationSource() {
        return this.initializer.getConfigurationSource();
    }

    public <T> T registerMockComponent(Class<T> role, String hint, String mockId) throws Exception {
        DefaultComponentDescriptor<T> descriptor = this.createComponentDescriptor(role);
        descriptor.setRoleHint(hint);
        return this.registerMockComponent((ComponentDescriptor<T>)descriptor, mockId);
    }

    public <T> T registerMockComponent(Class<T> role, String hint) throws Exception {
        return this.registerMockComponent(role, hint, null);
    }

    public <T> T registerMockComponent(Class<T> role) throws Exception {
        return this.registerMockComponent((ComponentDescriptor<T>)this.createComponentDescriptor(role));
    }

    private <T> T registerMockComponent(ComponentDescriptor<T> descriptor) throws Exception {
        return this.registerMockComponent(descriptor, null);
    }

    private <T> T registerMockComponent(ComponentDescriptor<T> descriptor, String mockId) throws Exception {
        Object instance = mockId != null ? this.getMockery().mock(descriptor.getRole(), mockId) : this.getMockery().mock(descriptor.getRole());
        this.getComponentManager().registerComponent(descriptor, instance);
        return (T)instance;
    }

    private <T> DefaultComponentDescriptor<T> createComponentDescriptor(Class<T> role) {
        DefaultComponentDescriptor descriptor = new DefaultComponentDescriptor();
        descriptor.setRole(role);
        return descriptor;
    }

    public void registerComponent(Class<?> componentClass) throws Exception {
        if (this.componentLoader == null) {
            this.componentLoader = new ComponentAnnotationLoader();
        }
        List descriptors = this.componentLoader.getComponentsDescriptors(componentClass);
        for (ComponentDescriptor descriptor : descriptors) {
            this.getComponentManager().registerComponent(descriptor);
        }
    }
}

