/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.junit5;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.test.XWikiTempDirUtil;
import org.xwiki.test.junit5.XWikiTempDir;

public class XWikiTempDirExtension
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        Class testClass = extensionContext.getRequiredTestClass();
        for (Field field : ReflectionUtils.getAllFields((Class)testClass)) {
            if (!field.isAnnotationPresent(XWikiTempDir.class) || !Modifier.isStatic(field.getModifiers()) || !File.class.isAssignableFrom(field.getType())) continue;
            boolean isAccessible = field.isAccessible();
            try {
                field.setAccessible(true);
                field.set(null, XWikiTempDirUtil.createTemporaryDirectory());
            }
            finally {
                field.setAccessible(isAccessible);
            }
        }
    }

    public void beforeEach(ExtensionContext extensionContext) {
        if (extensionContext.getTestInstance().isPresent()) {
            Object testInstance = extensionContext.getTestInstance().get();
            for (Field field : ReflectionUtils.getAllFields(testInstance.getClass())) {
                if (!field.isAnnotationPresent(XWikiTempDir.class) || Modifier.isStatic(field.getModifiers()) || !File.class.isAssignableFrom(field.getType())) continue;
                ReflectionUtils.setFieldValue(testInstance, (String)field.getName(), (Object)XWikiTempDirUtil.createTemporaryDirectory());
            }
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.isAnnotated(XWikiTempDir.class) && File.class.isAssignableFrom(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return XWikiTempDirUtil.createTemporaryDirectory();
    }
}

