/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.junit5;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuntimeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeUtils.class);

    private RuntimeUtils() {
    }

    public static String run(String command) {
        String result;
        try {
            StringBuilder output = new StringBuilder();
            output.append("Execution of '").append(command).append("':");
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command("sh", "-c", command);
            builder.directory(new File(System.getProperty("user.home")));
            Process process = builder.start();
            StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), it -> output.append('\n').append((String)it));
            Executors.newSingleThreadExecutor().submit(streamGobbler);
            process.waitFor();
            result = output.toString();
        }
        catch (Throwable e) {
            String message = String.format("Error in debugging code when executing command [%s]", command);
            LOGGER.error(message, e);
            result = message;
        }
        return result;
    }

    private static class StreamGobbler
    implements Runnable {
        private InputStream inputStream;
        private Consumer<String> consumer;

        StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumer);
        }
    }
}

