/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.read.ListAppender;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.xwiki.test.LogRule;

public class AllLogRule
implements TestRule {
    private final ListAppender<ILoggingEvent> listAppender = new ListAppender();
    private final Set<Integer> assertedMessages = new HashSet<Integer>();
    private List<Appender<ILoggingEvent>> savedAppenders = new ArrayList<Appender<ILoggingEvent>>();
    private Level savedLevel;
    private LogRule.LogLevel level;

    public AllLogRule() {
        this(LogRule.LogLevel.INFO);
    }

    public AllLogRule(LogRule.LogLevel level) {
        this.level = level;
    }

    public Statement apply(Statement statement, Description description) {
        return new LogStatement(statement);
    }

    private ILoggingEvent getLogEvent(int position) {
        List list = this.listAppender.list;
        if (list.size() <= position) {
            throw new RuntimeException(String.format("There are only %s messages in the captured logs", list.size()));
        }
        this.assertedMessages.add(position);
        return (ILoggingEvent)list.get(position);
    }

    public String getMessage(int position) {
        return this.getLogEvent(position).getFormattedMessage();
    }

    public Marker getMarker(int position) {
        return this.getLogEvent(position).getMarker();
    }

    public int size() {
        return this.listAppender.list.size();
    }

    private void initializeLoggers() {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        Iterator it = logger.iteratorForAppenders();
        while (it.hasNext()) {
            this.savedAppenders.add((Appender<ILoggingEvent>)it.next());
        }
        logger.detachAndStopAllAppenders();
        logger.addAppender(this.listAppender);
        this.savedLevel = logger.getLevel();
        logger.setLevel(this.level.getLevel());
    }

    private void uninitializeLogger(boolean verify) {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        logger.detachAppender(this.listAppender);
        logger.setLevel(this.savedLevel);
        for (Appender<ILoggingEvent> appender : this.savedAppenders) {
            logger.addAppender(appender);
        }
        if (verify && this.listAppender.list.size() != this.assertedMessages.size()) {
            throw new AssertionError((Object)"All messages must be asserted!");
        }
    }

    public class LogStatement
    extends Statement {
        private final Statement statement;

        public LogStatement(Statement statement) {
            this.statement = statement;
        }

        public void evaluate() throws Throwable {
            this.before();
            boolean validate = true;
            try {
                this.statement.evaluate();
            }
            catch (Throwable t) {
                validate = false;
                throw t;
            }
            finally {
                this.after(validate);
            }
        }

        private void before() {
            AllLogRule.this.initializeLoggers();
            AllLogRule.this.listAppender.start();
        }

        private void after(boolean verify) {
            AllLogRule.this.listAppender.stop();
            AllLogRule.this.uninitializeLogger(verify);
        }
    }
}

