/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.tool.xar;

import java.io.File;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XWikiDocument {
    private String name;
    private String space;
    private String language;
    private String defaultLanguage;

    public void fromXML(File file) throws DocumentException {
        Element elementDefaultLanguage;
        Element elementLanguage;
        Element elementSpace;
        SAXReader reader = new SAXReader();
        Document domdoc = reader.read(file);
        Element docel = domdoc.getRootElement();
        Element elementName = docel.element("name");
        if (elementName != null) {
            this.name = elementName.getText();
        }
        if ((elementSpace = docel.element("web")) != null) {
            this.space = elementSpace.getText();
        }
        if ((elementLanguage = docel.element("language")) != null) {
            this.language = elementLanguage.getText();
        }
        if ((elementDefaultLanguage = docel.element("defaultLanguage")) != null) {
            this.defaultLanguage = elementDefaultLanguage.getText();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSpace() {
        return this.space;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public String getFullName() {
        return this.space == null ? this.name : this.space + "." + this.name;
    }

    public static String getFullName(File file) {
        XWikiDocument doc;
        try {
            doc = new XWikiDocument();
            doc.fromXML(file);
        }
        catch (Exception e) {
            return null;
        }
        return doc.getFullName();
    }
}

