/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.introspection;

import java.util.Iterator;
import org.apache.velocity.util.RuntimeServicesAware;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.SecureIntrospectorControl;
import org.apache.velocity.util.introspection.UberspectImpl;
import org.xwiki.velocity.introspection.SecureIntrospector;

public class SecureUberspector
extends UberspectImpl
implements RuntimeServicesAware {
    public void init() {
        String[] badPackages = this.rsvc.getConfiguration().getStringArray("introspector.restrict.packages");
        String[] badClasses = this.rsvc.getConfiguration().getStringArray("introspector.restrict.classes");
        this.introspector = new SecureIntrospector(badClasses, badPackages, this.log);
    }

    public Iterator getIterator(Object obj, Info i) {
        if (obj != null) {
            SecureIntrospectorControl sic = (SecureIntrospectorControl)this.introspector;
            if (sic.checkObjectExecutePermission(obj.getClass(), null)) {
                return super.getIterator(obj, i);
            }
            this.log.warn("Cannot retrieve iterator from [{}] due to security restrictions.", obj.getClass());
        }
        return null;
    }
}

