/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.introspection;

import org.apache.commons.lang.StringUtils;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.util.ClassUtils;
import org.apache.velocity.util.RuntimeServicesAware;
import org.apache.velocity.util.introspection.SecureUberspector;
import org.apache.velocity.util.introspection.Uberspect;
import org.apache.velocity.util.introspection.UberspectLoggable;
import org.xwiki.velocity.introspection.AbstractChainableUberspector;
import org.xwiki.velocity.introspection.ChainableUberspector;

public class ChainingUberspector
extends AbstractChainableUberspector
implements Uberspect,
RuntimeServicesAware,
UberspectLoggable {
    public static final String UBERSPECT_CHAIN_CLASSNAMES = "runtime.introspector.uberspect.chainClasses";
    private RuntimeServices runtime;

    public void setRuntimeServices(RuntimeServices rs) {
        this.runtime = rs;
    }

    @Override
    public void init() {
        String[] chainClassnames;
        this.log.debug((Object)"Initializing the chaining uberspector.");
        for (String classname : chainClassnames = this.runtime.getConfiguration().getStringArray(UBERSPECT_CHAIN_CLASSNAMES)) {
            this.initializeUberspector(classname);
        }
        if (this.inner == null) {
            this.log.error((Object)"No chained uberspectors defined! This uberspector is just a placeholder that relies on a real uberspector to actually allow method calls. Using SecureUberspect instead as a fallback.");
            this.initializeUberspector(SecureUberspector.class.getCanonicalName());
        }
        try {
            this.inner.init();
        }
        catch (Exception e) {
            this.log.warn((Object)e.getMessage());
        }
    }

    protected void initializeUberspector(String classname) {
        if (!StringUtils.isEmpty((String)classname) && !classname.equals(this.getClass().getCanonicalName())) {
            Uberspect u = this.instantiateUberspector(classname);
            if (u == null) {
                return;
            }
            if (u instanceof UberspectLoggable) {
                ((UberspectLoggable)u).setLog(this.log);
            }
            if (u instanceof RuntimeServicesAware) {
                ((RuntimeServicesAware)u).setRuntimeServices(this.runtime);
            }
            if (u instanceof ChainableUberspector) {
                ((ChainableUberspector)u).wrap(this.inner);
            }
            this.inner = u;
        }
    }

    protected Uberspect instantiateUberspector(String classname) {
        Object o = null;
        try {
            o = ClassUtils.getNewInstance((String)classname);
        }
        catch (ClassNotFoundException cnfe) {
            this.log.warn((Object)String.format("The specified uberspector [%s] does not exist or is not accessible to the current classloader.", classname));
        }
        catch (IllegalAccessException e) {
            this.log.warn((Object)String.format("The specified uberspector [%s] does not have a public default constructor.", classname));
        }
        catch (InstantiationException e) {
            this.log.warn((Object)String.format("The specified uberspector [%s] cannot be instantiated.", classname));
        }
        catch (ExceptionInInitializerError e) {
            this.log.warn((Object)String.format("Exception while instantiating the Uberspector [%s]: %s", classname, e.getMessage()));
        }
        if (!(o instanceof Uberspect)) {
            if (o != null) {
                this.log.warn((Object)("The specified class for Uberspect [" + classname + "] does not implement " + Uberspect.class.getName()));
            }
            return null;
        }
        return (Uberspect)o;
    }
}

