/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.tools;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONTool {
    private Logger logger = LoggerFactory.getLogger(JSONTool.class);

    public String serialize(Object object) {
        StringWriter writer = new StringWriter();
        try {
            JsonFactory jsonFactory = new JsonFactory();
            JsonGenerator generator = jsonFactory.createGenerator((Writer)writer);
            generator.setCodec((ObjectCodec)new ObjectMapper());
            generator.writeObject(object);
            generator.flush();
        }
        catch (IOException e) {
            this.logger.error("Failed to serialize object to JSON", (Throwable)e);
        }
        return writer.toString();
    }

    public JSON parse(String json) {
        try {
            return JSONSerializer.toJSON((Object)json);
        }
        catch (JSONException ex) {
            this.logger.info("Tried to parse invalid JSON: [{}], exception was: {}", (Object)StringUtils.abbreviate((String)json, (int)32), (Object)ex.getMessage());
            return null;
        }
    }
}

