/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.tools;

import org.apache.commons.lang3.StringUtils;

public class CSSIdentifierSerializer {
    private static final int[][] NO_ESCAPE_RANGES = new int[][]{{48, 57}, {65, 90}, {97, 122}};

    public String serialize(String identifier) {
        if (StringUtils.isEmpty((CharSequence)identifier)) {
            return identifier;
        }
        int length = identifier.length();
        int index = -1;
        StringBuilder result = new StringBuilder();
        char firstCodeUnit = identifier.charAt(0);
        while (++index < length) {
            char codeUnit = identifier.charAt(index);
            if (codeUnit == '\u0000') {
                throw new IllegalArgumentException("Invalid character: the input contains U+0000.");
            }
            if (this.shouldEscapeAsCodePoint(codeUnit, index, firstCodeUnit)) {
                result.append('\\').append(Integer.toHexString(codeUnit)).append(' ');
                continue;
            }
            if (index == 0 && length == 1 && codeUnit == '-') {
                result.append('\\').append(identifier.charAt(index));
                continue;
            }
            if (this.shouldNotEscape(codeUnit)) {
                result.append(identifier.charAt(index));
                continue;
            }
            result.append('\\').append(identifier.charAt(index));
        }
        return result.toString();
    }

    private boolean shouldEscapeAsCodePoint(int codeUnit, int index, int firstCodeUnit) {
        if (this.isInRange(codeUnit, 1, 31) || codeUnit == 127) {
            return true;
        }
        if (index == 0 && this.isInRange(codeUnit, 48, 57)) {
            return true;
        }
        return index == 1 && this.isInRange(codeUnit, 48, 57) && firstCodeUnit == 45;
    }

    private boolean shouldNotEscape(int codeUnit) {
        return codeUnit >= 128 || codeUnit == 45 || codeUnit == 95 || this.isInRanges(codeUnit, NO_ESCAPE_RANGES);
    }

    private boolean isInRange(int codeUnit, int start, int end) {
        return codeUnit >= start && codeUnit <= end;
    }

    private boolean isInRanges(int codeUnit, int[][] ranges) {
        for (int[] range : ranges) {
            if (!this.isInRange(codeUnit, range[0], range[1])) continue;
            return true;
        }
        return false;
    }
}

