/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONTool {
    private Logger logger = LoggerFactory.getLogger(JSONTool.class);

    public String serialize(Object object) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to serialize object to JSON", (Throwable)e);
            return null;
        }
    }

    public JSON parse(String json) {
        try {
            return JSONSerializer.toJSON((Object)json);
        }
        catch (JSONException ex) {
            this.logger.info("Tried to parse invalid JSON: [{}], exception was: {}", (Object)StringUtils.abbreviate((String)json, (int)32), (Object)ex.getMessage());
            return null;
        }
    }
}

