/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.internal;

import java.util.Enumeration;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.velocity.VelocityConfiguration;
import org.xwiki.velocity.VelocityContextFactory;
import org.xwiki.velocity.VelocityContextInitializer;
import org.xwiki.velocity.XWikiVelocityException;

@Component
@Singleton
public class DefaultVelocityContextFactory
implements VelocityContextFactory,
Initializable {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private VelocityConfiguration velocityConfiguration;
    @Inject
    private Logger logger;
    private Context toolsContext;

    public void initialize() throws InitializationException {
        this.toolsContext = new VelocityContext();
        Properties properties = this.velocityConfiguration.getTools();
        if (properties != null) {
            Enumeration<?> props = properties.propertyNames();
            while (props.hasMoreElements()) {
                Object toolInstance;
                String key = props.nextElement().toString();
                Object value = properties.get(key);
                if (value instanceof String) {
                    try {
                        toolInstance = Class.forName((String)value).newInstance();
                    }
                    catch (Exception e) {
                        throw new InitializationException("Failed to initialize tool [" + value + "]", (Throwable)e);
                    }
                } else {
                    toolInstance = value;
                }
                this.toolsContext.put(key, toolInstance);
                this.logger.debug("Setting tool [{}] = [{}]", (Object)key, value);
            }
        }
    }

    @Override
    public VelocityContext createContext() throws XWikiVelocityException {
        VelocityContext context = new VelocityContext(this.toolsContext);
        try {
            for (Object interceptor : this.componentManager.getInstanceList(VelocityContextInitializer.class)) {
                ((VelocityContextInitializer)interceptor).initialize(context);
            }
        }
        catch (ComponentLookupException e) {
            throw new XWikiVelocityException("Failed to locate some Velocity Context initializers", e);
        }
        return context;
    }
}

