/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.xml.internal.html;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.filter.HTMLFilter;

/**
 * Default and basic implementation used by the {@link DefaultHTMLCleaner} implementation.
 * 
 * @version $Id: DefaultHTMLCleanerConfiguration.java 21281 2009-06-13 19:22:09Z sdumitriu $
 * @since 1.8.1
 */
public class DefaultHTMLCleanerConfiguration implements HTMLCleanerConfiguration
{
    /**
     * Ordered list of filters to apply in that order.
     */
    private List<HTMLFilter> filters = Collections.emptyList();

    /**
     * Parameters to apply for the cleaning.
     */
    private Map<String, String> parameters = Collections.emptyMap();
    
    /**
     * {@inheritDoc}
     * 
     * @see HTMLCleanerConfiguration#getFilters()
     */
    public List<HTMLFilter> getFilters()
    {
        return this.filters;
    }

    /**
     * {@inheritDoc}
     * 
     * @see HTMLCleanerConfiguration#getParameters()
     */
    public Map<String, String> getParameters()
    {
        return this.parameters;
    }

    /**
     * {@inheritDoc}
     * 
     * @see HTMLCleanerConfiguration#setFilters(List)
     */
    public void setFilters(List<HTMLFilter> filters)
    {
        this.filters = filters;
    }

    /**
     * {@inheritDoc}
     * 
     * @see HTMLCleanerConfiguration#setParameters(Map)
     */
    public void setParameters(Map<String, String> parameters)
    {
        this.parameters = parameters;
    }
}
