/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ratings;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Document;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.contrib.ratings.AverageRatingApi;
import org.xwiki.contrib.ratings.Rating;
import org.xwiki.contrib.ratings.RatingApi;
import org.xwiki.contrib.ratings.RatingsManager;
import org.xwiki.contrib.ratings.ReputationAlgorithm;
import org.xwiki.script.service.ScriptService;

@Component
@Singleton
@Named(value="ratings")
public class RatingsScriptService
implements ScriptService {
    @Inject
    private Execution execution;
    @Inject
    private Provider<RatingsManager> ratingsManagerProvider;
    @Inject
    private Provider<ReputationAlgorithm> reputationAlgorithmProvider;

    protected static List<RatingApi> wrapRatings(List<Rating> ratings) {
        if (ratings == null) {
            return null;
        }
        ArrayList<RatingApi> ratingsResult = new ArrayList<RatingApi>();
        for (Rating rating : ratings) {
            ratingsResult.add(new RatingApi(rating));
        }
        return ratingsResult;
    }

    protected XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    public RatingApi setRating(Document doc, String author, int vote) {
        try {
            return new RatingApi(((RatingsManager)this.ratingsManagerProvider.get()).setRating(doc.getFullName(), author, vote));
        }
        catch (Throwable e) {
            this.getXWikiContext().put((Object)"exception", (Object)e);
            return null;
        }
    }

    public RatingApi getRating(Document doc, String author) {
        try {
            Rating rating = ((RatingsManager)this.ratingsManagerProvider.get()).getRating(doc.getFullName(), author);
            if (rating == null) {
                return null;
            }
            return new RatingApi(rating);
        }
        catch (Throwable e) {
            this.getXWikiContext().put((Object)"exception", (Object)e);
            return null;
        }
    }

    public List<RatingApi> getRatings(Document doc, int start, int count) {
        return this.getRatings(doc, start, count, true);
    }

    public List<RatingApi> getRatings(Document doc, int start, int count, boolean asc) {
        try {
            return RatingsScriptService.wrapRatings(((RatingsManager)this.ratingsManagerProvider.get()).getRatings(doc.getFullName(), start, count, asc));
        }
        catch (Exception e) {
            this.getXWikiContext().put((Object)"exception", (Object)e);
            return null;
        }
    }

    public AverageRatingApi getAverageRating(Document doc, String method) {
        try {
            return new AverageRatingApi(((RatingsManager)this.ratingsManagerProvider.get()).getAverageRating(doc.getFullName(), method));
        }
        catch (Throwable e) {
            this.getXWikiContext().put((Object)"exception", (Object)e);
            return null;
        }
    }

    public AverageRatingApi getAverageRating(Document doc) {
        try {
            return new AverageRatingApi(((RatingsManager)this.ratingsManagerProvider.get()).getAverageRating(doc.getFullName()));
        }
        catch (Throwable e) {
            this.getXWikiContext().put((Object)"exception", (Object)e);
            return null;
        }
    }

    public AverageRatingApi getAverageRating(String fromsql, String wheresql, String method) {
        try {
            return new AverageRatingApi(((RatingsManager)this.ratingsManagerProvider.get()).getAverageRatingFromQuery(fromsql, wheresql, method));
        }
        catch (Throwable e) {
            this.getXWikiContext().put((Object)"exception", (Object)e);
            return null;
        }
    }

    public AverageRatingApi getAverageRating(String fromsql, String wheresql) {
        try {
            return new AverageRatingApi(((RatingsManager)this.ratingsManagerProvider.get()).getAverageRatingFromQuery(fromsql, wheresql));
        }
        catch (Throwable e) {
            this.getXWikiContext().put((Object)"exception", (Object)e);
            return null;
        }
    }

    public AverageRatingApi getUserReputation(String username) {
        try {
            return new AverageRatingApi(((RatingsManager)this.ratingsManagerProvider.get()).getUserReputation(username));
        }
        catch (Throwable e) {
            this.getXWikiContext().put((Object)"exception", (Object)e);
            return null;
        }
    }
}

