/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ratings.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import java.util.Date;
import org.xwiki.contrib.ratings.Rating;
import org.xwiki.contrib.ratings.RatingsException;
import org.xwiki.contrib.ratings.internal.SeparatePageRatingsManager;

public class SeparatePageRating
implements Rating {
    private String documentName;
    private XWikiDocument document;
    private XWikiContext context;
    private SeparatePageRatingsManager ratingsManager;

    public SeparatePageRating(String documentName, String author, int vote, XWikiContext context, SeparatePageRatingsManager ratingsManager) throws RatingsException {
        this(documentName, author, new Date(), vote, context, ratingsManager);
    }

    public SeparatePageRating(String documentName, String author, Date date, int vote, XWikiContext context, SeparatePageRatingsManager ratingsManager) throws RatingsException {
        this.context = context;
        this.ratingsManager = ratingsManager;
        this.documentName = documentName;
        this.document = this.addDocument(documentName, author, date, vote);
    }

    public SeparatePageRating(String documentName, XWikiDocument doc, XWikiContext context, SeparatePageRatingsManager ratingsManager) throws RatingsException {
        this.context = context;
        this.ratingsManager = ratingsManager;
        this.documentName = documentName;
        this.document = doc;
    }

    @Override
    public String getRatingId() {
        return this.getDocument().getFullName();
    }

    @Override
    public String getGlobalRatingId() {
        return this.getRatingId();
    }

    @Override
    public BaseObject getAsObject() {
        return this.getDocument().getObject("XWiki.RatingsClass");
    }

    public XWikiDocument getDocument() {
        if (this.document == null) {
            try {
                this.document = this.context.getWiki().getDocument(this.getPageName(this.documentName), this.context);
            }
            catch (XWikiException e) {
                return null;
            }
        }
        return this.document;
    }

    @Override
    public String getAuthor() {
        return this.getAsObject().getStringValue("author");
    }

    @Override
    public Date getDate() {
        return this.getAsObject().getDateValue("date");
    }

    @Override
    public void setAuthor(String author) {
        this.getAsObject().setStringValue("author", author);
    }

    @Override
    public void setDate(Date date) {
        this.getAsObject().setDateValue("date", date);
    }

    @Override
    public int getVote() {
        return this.getAsObject().getIntValue("vote");
    }

    @Override
    public void setVote(int vote) {
        this.getAsObject().setIntValue("vote", vote);
    }

    @Override
    public Object get(String propertyName) {
        try {
            return ((BaseProperty)this.getAsObject().get(propertyName)).getValue();
        }
        catch (XWikiException e) {
            return null;
        }
    }

    @Override
    public String display(String propertyName, String mode) {
        return this.document.display(propertyName, mode, this.getAsObject(), this.context);
    }

    @Override
    public void save() throws RatingsException {
        try {
            if (this.document == null) {
                throw new RatingsException(1120, 1120005, "Cannot save invalid separate page rating, the rating document is null");
            }
            this.document.setContentDirty(false);
            this.context.getWiki().saveDocument(this.getDocument(), this.context);
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
    }

    @Override
    public boolean remove() throws RatingsException {
        try {
            XWikiDocument doc = this.getDocument();
            this.context.getWiki().deleteDocument(doc, this.context);
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
        return true;
    }

    private String getPageName(String documentName) throws XWikiException {
        XWikiDocument doc = this.context.getWiki().getDocument(documentName, this.context);
        String ratingsSpace = this.ratingsManager.getRatingsSpaceName();
        boolean hasRatingsSpaceForeachSpace = this.ratingsManager.hasRatingsSpaceForeachSpace();
        if (hasRatingsSpaceForeachSpace) {
            return doc.getSpace() + ratingsSpace + "." + this.getUniquePageName(ratingsSpace, doc.getName(), "R", true);
        }
        if (ratingsSpace == null) {
            return doc.getSpace() + "." + this.getUniquePageName(doc.getSpace(), doc.getName() + "R", "", true);
        }
        return ratingsSpace + "." + this.getUniquePageName(ratingsSpace, doc.getSpace() + "_" + doc.getName(), "R", true);
    }

    private String getUniquePageName(String space, String name, String postfix, boolean forcepostfix) {
        String pageName = this.context.getWiki().clearName(name, this.context);
        if (forcepostfix || this.context.getWiki().exists(space + "." + pageName, this.context)) {
            int i = 1;
            while (this.context.getWiki().exists(space + "." + pageName + postfix + i, this.context)) {
                ++i;
            }
            return pageName + postfix + i;
        }
        return pageName;
    }

    private XWikiDocument addDocument(String documentName, String author, Date date, int vote) throws RatingsException {
        try {
            String ratingsClassName = "XWiki.RatingsClass";
            String pageName = this.getPageName(documentName);
            String parentDocName = documentName;
            XWiki xwiki = this.context.getWiki();
            XWikiDocument doc = xwiki.getDocument(pageName, this.context);
            doc.setParent(parentDocName);
            BaseObject obj = new BaseObject();
            obj.setClassName(ratingsClassName);
            obj.setName(pageName);
            obj.setStringValue("author", author);
            obj.setDateValue("date", date);
            obj.setIntValue("vote", vote);
            obj.setStringValue("parent", parentDocName);
            doc.addObject(ratingsClassName, obj);
            return doc;
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
    }

    @Override
    public String toString() {
        boolean shouldAddSpace = false;
        StringBuffer sb = new StringBuffer();
        if (this.getAuthor() != null) {
            sb.append("\nAuthor=").append(this.getAuthor());
            shouldAddSpace = true;
        }
        if (this.getDate() != null) {
            sb.append(shouldAddSpace ? " " : "");
            sb.append("\nDate=").append(this.getDate());
            shouldAddSpace = true;
        }
        if (this.getVote() != 0) {
            sb.append(shouldAddSpace ? " " : "");
            sb.append("\nVote=").append(this.getVote()).append("\n");
            shouldAddSpace = true;
        }
        return sb.toString();
    }

    @Override
    public String getDocumentName() {
        return this.documentName;
    }
}

