/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ratings.internal;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.ratings.Rating;
import org.xwiki.contrib.ratings.RatingsException;
import org.xwiki.contrib.ratings.UpdateRatingEvent;
import org.xwiki.contrib.ratings.internal.AbstractRatingsManager;
import org.xwiki.contrib.ratings.internal.SeparatePageRating;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="separate")
public class SeparatePageRatingsManager
extends AbstractRatingsManager {
    public static final String RATINGS_CONFIG_PARAM_PREFIX = "xwiki.ratings.separatepage.";
    public static final String RATINGS_CONFIG_FIELDNAME_SEPARATEPAGE_SPACE = "space";
    public static final String RATINGS_CONFIG_FIELDNAME_SEPARATEPAGE_RATINGS_SPACE_PER_SPACE = "ratingsSpacePerSpace";
    @Inject
    private Logger LOGGER;

    public String getRatingsSpaceName() {
        String ratingsSpaceName = this.getXWiki().Param("xwiki.ratings.separatepagemanager.spacename", "");
        ratingsSpaceName = this.getXWiki().getXWikiPreference("ratings_separatepagemanager_spacename", ratingsSpaceName, this.getXWikiContext());
        return ratingsSpaceName;
    }

    public boolean hasRatingsSpaceForeachSpace() {
        int result = (int)this.getXWiki().ParamAsLong("xwiki.ratings.separatepagemanager.ratingsspaceforeachspace", 0L);
        return this.getXWiki().getXWikiPreferenceAsInt("ratings_separatepagemanager_ratingsspaceforeachspace", result, this.getXWikiContext()) == 1;
    }

    protected void saveRating(Rating rating) throws RatingsException {
        try {
            rating.save();
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
    }

    @Override
    public Rating setRating(String documentName, String author, int vote) throws RatingsException {
        int oldVote;
        Rating rating = this.getRating(documentName, author);
        if (rating == null) {
            oldVote = 0;
            rating = new SeparatePageRating(documentName, author, vote, this.getXWikiContext(), this);
        } else {
            oldVote = rating.getVote();
            rating.setVote(vote);
            rating.setDate(new Date());
        }
        rating.save();
        this.updateAverageRatings(documentName, rating, oldVote);
        this.observationManager.notify((Event)new UpdateRatingEvent(documentName, rating, oldVote), null);
        return rating;
    }

    @Override
    public List<Rating> getRatings(String documentName, int start, int count, boolean asc) throws RatingsException {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Calling separate page manager code for ratings");
        }
        String sql = ", BaseObject as obj, StringProperty as parentprop where doc.fullName=obj.name and obj.className='" + this.getRatingsClassName() + "' and obj.id=parentprop.id.id and parentprop.id.name='" + "parent" + "' and parentprop.value='" + documentName + "' and obj.name not in (select obj2.name from BaseObject as obj2, StringProperty as statusprop where obj2.className='" + this.getRatingsClassName() + "' and obj2.id=statusprop.id.id and statusprop.id.name='status' and (statusprop.value='moderated' or statusprop.value='refused') and obj.id=obj2.id) order by doc.date " + (asc ? "asc" : "desc");
        ArrayList<Rating> ratings = new ArrayList<Rating>();
        try {
            List ratingPageNameList = this.getXWiki().getStore().searchDocumentsNames(sql, count, start, this.getXWikiContext());
            for (String ratingPageName : ratingPageNameList) {
                ratings.add(new SeparatePageRatingsManager().getRatingFromDocument(documentName, this.getXWiki().getDocument(ratingPageName, this.getXWikiContext())));
            }
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
        return ratings;
    }

    @Override
    public Rating getRating(String documentName, int id) throws RatingsException {
        String sql = ", BaseObject as obj, StringProperty as parentprop where doc.fullName=obj.name and obj.className='" + this.getRatingsClassName() + "' and obj.id=parentprop.id.id and parentprop.id.name='" + "parent" + "' and parentprop.value='" + documentName + "' and obj.name not in (select obj2.name from BaseObject as obj2, StringProperty as statusprop where obj2.className='" + this.getRatingsClassName() + "' and obj2.id=statusprop.id.id and statusprop.id.name='status' and (statusprop.value='moderated' or statusprop.value='refused') and obj.id=obj2.id) order by doc.date desc";
        try {
            List ratingPageNameList = this.getXWiki().getStore().searchDocumentsNames(sql, 1, id, this.getXWikiContext());
            if (ratingPageNameList == null || ratingPageNameList.size() == 0) {
                return null;
            }
            return new SeparatePageRatingsManager().getRatingFromDocument(documentName, this.getXWiki().getDocument((String)ratingPageNameList.get(0), this.getXWikiContext()));
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
    }

    @Override
    public Rating getRating(String documentName, String author) throws RatingsException {
        try {
            for (Rating rating : this.getRatings(documentName, 0, 0, false)) {
                if (!author.equals(rating.getAuthor())) continue;
                return rating;
            }
        }
        catch (XWikiException e) {
            return null;
        }
        return null;
    }

    @Override
    public Rating getRating(String ratingId) throws RatingsException {
        try {
            int i1 = ratingId.indexOf(".");
            if (i1 == -1) {
                throw new RatingsException(1120, 1120004, "Invalid rating ID, cannot parse rating id");
            }
            XWikiDocument doc = this.getXWiki().getDocument(ratingId, this.getXWikiContext());
            if (doc.isNew()) {
                throw new RatingsException(1120, 1120004, "Invalid rating ID, rating does not exist");
            }
            BaseObject object = doc.getObject(this.getRatingsClassName());
            if (object == null) {
                throw new RatingsException(1120, 1120004, "Invalid rating ID, rating does not exist");
            }
            String parentDocName = object.getStringValue("parent");
            return new SeparatePageRating(parentDocName, doc, this.getXWikiContext(), this);
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
    }

    public Rating getRatingFromDocument(String documentName, XWikiDocument doc) throws RatingsException {
        return new SeparatePageRating(documentName, doc, this.getXWikiContext(), this);
    }
}

