/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.workflowpublication.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.rightsmanager.RightsManagerPluginApi;
import com.xpn.xwiki.user.api.XWikiGroupService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.workflowpublication.PublicationRoles;
import org.xwiki.workflowpublication.WorkflowConfigManager;

public class DefaultPublicationRoles
implements PublicationRoles {
    public static final String WF_CONFIG_MODERATOR = "moderator";
    public static final String WF_CONFIG_CONTRIBUTOR = "contributor";
    public static final String WF_CONFIG_VALIDATOR = "validator";
    @Inject
    private Logger logger;
    @Inject
    @Named(value="local")
    protected EntityReferenceSerializer<String> localStringSerializer;
    @Inject
    protected EntityReferenceSerializer<String> stringSerializer;
    @Inject
    protected WorkflowConfigManager configManager;
    @Inject
    @Named(value="explicit")
    protected DocumentReferenceResolver<String> explicitStringDocRefResolver;
    @Inject
    @Named(value="default")
    protected DocumentReferenceResolver<String> defaultStringDocRefResolver;

    private boolean isInGroup(DocumentReference userRef, DocumentReference groupRef, XWikiContext xcontext) throws XWikiException {
        Collection<String> groupsOfMember = this.getGroups(userRef, true, true, true, xcontext);
        return groupsOfMember.contains(this.stringSerializer.serialize((EntityReference)groupRef, new Object[0]));
    }

    protected String getRoleGroup(XWikiDocument document, BaseObject workflowConfig, String role, XWikiContext context) throws XWikiException {
        BaseObject wfConfig = workflowConfig;
        if (wfConfig == null) {
            wfConfig = this.configManager.getWorkflowConfigForWorkflowDoc(document, context);
        }
        if (wfConfig != null) {
            return wfConfig.getStringValue(role);
        }
        return null;
    }

    @Override
    public boolean canModerate(DocumentReference userRef, XWikiDocument document, XWikiContext context) {
        try {
            BaseObject workflowConfig = this.configManager.getWorkflowConfigForWorkflowDoc(document, context);
            if (workflowConfig == null) {
                return context.getWiki().getRightService().hasAccessLevel("edit", (String)this.localStringSerializer.serialize((EntityReference)userRef, new Object[0]), (String)this.localStringSerializer.serialize((EntityReference)document.getDocumentReference(), new Object[0]), context);
            }
            if (this.hasXWikiAdmin((String)this.stringSerializer.serialize((EntityReference)userRef, new Object[0]), context)) {
                return true;
            }
            RightsManagerPluginApi rightsManager = (RightsManagerPluginApi)context.getWiki().getPluginApi("rightsmanager", context);
            boolean isModerator = false;
            String moderatorGroup = this.getRoleGroup(document, workflowConfig, WF_CONFIG_MODERATOR, context);
            if (!StringUtils.isEmpty((String)moderatorGroup)) {
                isModerator = this.isInGroup(userRef, this.explicitStringDocRefResolver.resolve((Object)moderatorGroup, new Object[]{document.getDocumentReference()}), context);
            }
            if (isModerator) {
                return isModerator;
            }
            boolean isValidator = false;
            String validatorGroup = this.getRoleGroup(document, workflowConfig, WF_CONFIG_VALIDATOR, context);
            if (!StringUtils.isEmpty((String)validatorGroup)) {
                isValidator = this.isInGroup(userRef, this.explicitStringDocRefResolver.resolve((Object)validatorGroup, new Object[]{document.getDocumentReference()}), context);
            }
            return isModerator || isValidator;
        }
        catch (XWikiException e) {
            this.logger.error("There was an error getting the moderation groups for user " + (String)this.stringSerializer.serialize((EntityReference)userRef, new Object[0]) + " for document " + (String)this.stringSerializer.serialize((EntityReference)document.getDocumentReference(), new Object[0]), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean canValidate(DocumentReference userRef, XWikiDocument document, XWikiContext context) {
        try {
            BaseObject workflowConfig = this.configManager.getWorkflowConfigForWorkflowDoc(document, context);
            if (workflowConfig == null) {
                return context.getWiki().getRightService().hasAccessLevel("edit", (String)this.localStringSerializer.serialize((EntityReference)userRef, new Object[0]), (String)this.localStringSerializer.serialize((EntityReference)document.getDocumentReference(), new Object[0]), context);
            }
            if (this.hasXWikiAdmin((String)this.stringSerializer.serialize((EntityReference)userRef, new Object[0]), context)) {
                return true;
            }
            RightsManagerPluginApi rightsManager = (RightsManagerPluginApi)context.getWiki().getPluginApi("rightsmanager", context);
            boolean isValidator = false;
            String validatorGroup = this.getRoleGroup(document, workflowConfig, WF_CONFIG_VALIDATOR, context);
            if (!StringUtils.isEmpty((String)validatorGroup)) {
                isValidator = this.isInGroup(userRef, this.explicitStringDocRefResolver.resolve((Object)validatorGroup, new Object[]{document.getDocumentReference()}), context);
            }
            return isValidator;
        }
        catch (XWikiException e) {
            this.logger.error("There was an error getting the validation group for user " + (String)this.stringSerializer.serialize((EntityReference)userRef, new Object[0]) + " for document " + (String)this.stringSerializer.serialize((EntityReference)document.getDocumentReference(), new Object[0]), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean canContribute(DocumentReference userRef, XWikiDocument document, XWikiContext context) {
        try {
            BaseObject workflowConfig = this.configManager.getWorkflowConfigForWorkflowDoc(document, context);
            if (workflowConfig == null) {
                return context.getWiki().getRightService().hasAccessLevel("edit", (String)this.localStringSerializer.serialize((EntityReference)userRef, new Object[0]), (String)this.localStringSerializer.serialize((EntityReference)document.getDocumentReference(), new Object[0]), context);
            }
            if (this.hasXWikiAdmin((String)this.stringSerializer.serialize((EntityReference)userRef, new Object[0]), context)) {
                return true;
            }
            RightsManagerPluginApi rightsManager = (RightsManagerPluginApi)context.getWiki().getPluginApi("rightsmanager", context);
            boolean isContributor = false;
            String contributorGroup = this.getRoleGroup(document, workflowConfig, WF_CONFIG_CONTRIBUTOR, context);
            if (!StringUtils.isEmpty((String)contributorGroup)) {
                isContributor = this.isInGroup(userRef, this.explicitStringDocRefResolver.resolve((Object)contributorGroup, new Object[]{document.getDocumentReference()}), context);
            }
            if (isContributor) {
                return true;
            }
            boolean isModerator = false;
            String moderatorGroup = this.getRoleGroup(document, workflowConfig, WF_CONFIG_MODERATOR, context);
            if (!StringUtils.isEmpty((String)moderatorGroup)) {
                isModerator = this.isInGroup(userRef, this.explicitStringDocRefResolver.resolve((Object)moderatorGroup, new Object[]{document.getDocumentReference()}), context);
            }
            if (isModerator) {
                return true;
            }
            boolean isValidator = false;
            String validatorGroup = this.getRoleGroup(document, workflowConfig, WF_CONFIG_VALIDATOR, context);
            if (!StringUtils.isEmpty((String)validatorGroup)) {
                isValidator = this.isInGroup(userRef, this.explicitStringDocRefResolver.resolve((Object)validatorGroup, new Object[]{document.getDocumentReference()}), context);
            }
            return isValidator;
        }
        catch (XWikiException e) {
            this.logger.error("There was an error getting the contribution group for user " + (String)this.stringSerializer.serialize((EntityReference)userRef, new Object[0]) + " for document " + (String)this.stringSerializer.serialize((EntityReference)document.getDocumentReference(), new Object[0]), (Throwable)e);
            return false;
        }
    }

    private boolean hasXWikiAdmin(String user, XWikiContext context) {
        try {
            return context.getWiki().getRightService().hasAccessLevel("admin", user, "XWiki.XWikiPreferences", context);
        }
        catch (Exception e) {
            this.logger.error("Failed to check wiki admin right for user [" + user + "]", (Throwable)e);
            return false;
        }
    }

    @Override
    public String getContributors(BaseObject workflowConfig, XWikiContext context) {
        if (workflowConfig == null) {
            return null;
        }
        return workflowConfig.getStringValue(WF_CONFIG_CONTRIBUTOR);
    }

    @Override
    public String getModerators(BaseObject workflowConfig, XWikiContext context) {
        if (workflowConfig == null) {
            return null;
        }
        return workflowConfig.getStringValue(WF_CONFIG_MODERATOR);
    }

    @Override
    public String getValidators(BaseObject workflowConfig, XWikiContext context) {
        if (workflowConfig == null) {
            return null;
        }
        return workflowConfig.getStringValue(WF_CONFIG_VALIDATOR);
    }

    @Override
    public Collection<String> getGroups(DocumentReference userOrGroup, boolean recursive, boolean localGroups, boolean userWikiGroups, XWikiContext xcontext) throws XWikiException {
        HashSet<String> allGroups = new HashSet<String>();
        String localWiki = xcontext.getDatabase();
        String userWiki = userOrGroup.getWikiReference().getName();
        if (localGroups) {
            allGroups.addAll(this.getMemberGroups(localWiki, userOrGroup, xcontext));
        }
        if (userWikiGroups && !localWiki.equals(userWiki)) {
            allGroups.addAll(this.getMemberGroups(userWiki, userOrGroup, xcontext));
        }
        if (recursive) {
            HashSet<String> parentGroups = new HashSet<String>();
            for (String group : allGroups) {
                DocumentReference groupRef = this.defaultStringDocRefResolver.resolve((Object)group, new Object[0]);
                parentGroups.addAll(this.getGroups(groupRef, recursive, localGroups, userWikiGroups, xcontext));
            }
            allGroups.addAll(parentGroups);
        }
        return allGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> getMemberGroups(String wiki, DocumentReference memberReference, XWikiContext context) throws XWikiException {
        String key;
        List<Object> tmpGroupList;
        XWikiGroupService groupService = context.getWiki().getGroupService(context);
        HashMap grouplistcache = (HashMap)context.get((Object)"grouplist");
        if (grouplistcache == null) {
            grouplistcache = new HashMap();
            context.put((Object)"grouplist", grouplistcache);
        }
        if ((tmpGroupList = (ArrayList<Object>)grouplistcache.get(key = wiki + ":" + (String)this.stringSerializer.serialize((EntityReference)memberReference, new Object[0]))) == null) {
            String currentWiki = context.getDatabase();
            try {
                context.setDatabase(wiki);
                Collection groupReferences = groupService.getAllGroupsReferencesForMember(memberReference, 0, 0, context);
                tmpGroupList = new ArrayList<Object>(groupReferences.size());
                for (DocumentReference groupReference : groupReferences) {
                    tmpGroupList.add(this.stringSerializer.serialize((EntityReference)groupReference, new Object[0]));
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to get groups for user or group [" + (String)this.stringSerializer.serialize((EntityReference)memberReference, new Object[0]) + "] in wiki [" + wiki + "]", (Throwable)e);
                tmpGroupList = Collections.emptyList();
            }
            finally {
                context.setDatabase(currentWiki);
            }
            grouplistcache.put(key, tmpGroupList);
        }
        return tmpGroupList;
    }
}

