/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.workflowpublication.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.doc.merge.MergeResult;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.web.XWikiMessageTool;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.workflowpublication.PublicationRoles;
import org.xwiki.workflowpublication.PublicationWorkflow;
import org.xwiki.workflowpublication.WorkflowConfigManager;

@Component
public class DefaultPublicationWorkflow
implements PublicationWorkflow {
    public static final String WF_CONFIG_REF_FIELDNAME = "workflow";
    public static final String WF_TARGET_FIELDNAME = "target";
    public static final String WF_STATUS_FIELDNAME = "status";
    public static final String WF_IS_TARGET_FIELDNAME = "istarget";
    public static final int DRAFT = 0;
    public static final int PUBLISHED = 1;
    public static final String STATUS_MODERATING = "moderating";
    public static final String STATUS_VALIDATING = "validating";
    public static final String STATUS_VALID = "valid";
    public static final String STATUS_DRAFT = "draft";
    public static final String STATUS_PUBLISHED = "published";
    public static final String STATUS_ARCHIVED = "archived";
    public static final EntityReference COMMENTS_CLASS = new EntityReference("XWikiComments", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    public static final EntityReference RIGHTS_CLASS = new EntityReference("XWikiRights", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    public static final String RIGHTS_GROUPS = "groups";
    public static final String RIGHTS_LEVELS = "levels";
    public static final String RIGHTS_USERS = "users";
    public static final String RIGHTS_ALLOWDENY = "allow";
    private XWikiMessageTool messageTool;
    @Inject
    private Execution execution;
    @Inject
    @Named(value="currentmixed")
    private DocumentReferenceResolver<String> currentMixedStringDocRefResolver;
    @Inject
    @Named(value="explicit")
    private DocumentReferenceResolver<String> explicitStringDocRefResolver;
    @Inject
    @Named(value="explicit")
    private DocumentReferenceResolver<EntityReference> explicitReferenceDocRefResolver;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactWikiSerializer;
    @Inject
    private WorkflowConfigManager configManager;
    @Inject
    private PublicationRoles publicationRoles;
    @Inject
    private EntityReferenceSerializer<String> stringSerializer;

    @Override
    public boolean isWorkflowDocument(XWikiDocument document, XWikiContext context) throws XWikiException {
        BaseObject workflowInstance = document.getXObject(this.explicitReferenceDocRefResolver.resolve((Object)PublicationWorkflow.PUBLICATION_WORKFLOW_CLASS, new Object[]{document.getDocumentReference()}));
        return workflowInstance != null;
    }

    @Override
    public DocumentReference getDraftDocument(DocumentReference targetRef, XWikiContext xcontext) throws XWikiException {
        String workflowsQuery = "select obj.name from BaseObject obj, StringProperty target, IntegerProperty istarget where obj.className = ? and obj.id = target.id.id and target.id.name = ? and target.value = ? and obj.id = istarget.id.id and istarget.id.name = ? and istarget.value = 0";
        List<String> params = Arrays.asList((String)this.compactWikiSerializer.serialize(PUBLICATION_WORKFLOW_CLASS, new Object[0]), WF_TARGET_FIELDNAME, (String)this.compactWikiSerializer.serialize((EntityReference)targetRef, new Object[0]), WF_IS_TARGET_FIELDNAME);
        List results = xcontext.getWiki().getStore().search(workflowsQuery, 0, 0, params, xcontext);
        if (results.size() <= 0) {
            return null;
        }
        return this.currentMixedStringDocRefResolver.resolve(results.get(0), new Object[0]);
    }

    private DocumentReference createDraftDocument(DocumentReference targetRef, XWikiContext xcontext) throws XWikiException {
        if (this.getDraftDocument(targetRef, xcontext) != null) {
            return null;
        }
        XWikiDocument targetDocument = xcontext.getWiki().getDocument(targetRef, xcontext);
        return null;
    }

    @Override
    public void setupDraftAccess(XWikiDocument document, XWikiContext xcontext) throws XWikiException {
        BaseObject workflowObj = document.getXObject(PUBLICATION_WORKFLOW_CLASS);
        this.setupDraftAccess(document, workflowObj, xcontext);
    }

    private void setupDraftAccess(XWikiDocument document, BaseObject workflow, XWikiContext xcontext) throws XWikiException {
        document.setHidden(Boolean.valueOf(true));
        BaseObject wfConfig = this.configManager.getWorkflowConfig(workflow.getStringValue(WF_CONFIG_REF_FIELDNAME), xcontext);
        if (wfConfig != null) {
            String contributors = this.publicationRoles.getContributors(wfConfig, xcontext);
            String moderators = this.publicationRoles.getModerators(wfConfig, xcontext);
            String validators = this.publicationRoles.getValidators(wfConfig, xcontext);
            this.setRights(document, Arrays.asList("edit", "view"), Arrays.asList(contributors, moderators, validators), Arrays.asList(new String[0]), true, xcontext);
        }
    }

    @Override
    public boolean startWorkflow(DocumentReference docName, String workflowConfig, DocumentReference target, XWikiContext xcontext) throws XWikiException {
        XWikiDocument doc = xcontext.getWiki().getDocument(docName, xcontext);
        if (this.getDraftDocument(target, xcontext) != null) {
            return false;
        }
        BaseObject workflowObject = doc.newXObject((EntityReference)this.explicitReferenceDocRefResolver.resolve((Object)PublicationWorkflow.PUBLICATION_WORKFLOW_CLASS, new Object[]{docName}), xcontext);
        BaseObject wfConfig = this.configManager.getWorkflowConfig(workflowConfig, xcontext);
        if (wfConfig == null) {
            return false;
        }
        workflowObject.set(WF_CONFIG_REF_FIELDNAME, (Object)workflowConfig, xcontext);
        workflowObject.set(WF_TARGET_FIELDNAME, this.compactWikiSerializer.serialize((EntityReference)target, new Object[]{docName}), xcontext);
        this.makeDocumentDraft(doc, workflowObject, xcontext);
        String defaultMessage = "Started workflow " + workflowConfig + " on document " + (String)this.stringSerializer.serialize((EntityReference)docName, new Object[0]);
        String message = this.getMessage("workflow.save.start", defaultMessage, Arrays.asList(workflowConfig.toString(), ((String)this.stringSerializer.serialize((EntityReference)docName, new Object[0])).toString()));
        xcontext.getWiki().saveDocument(doc, message, true, xcontext);
        return true;
    }

    @Override
    public List<String> startMatchingWorkflows(DocumentReference doc, DocumentReference target, XWikiContext xcontext) {
        return null;
    }

    @Override
    public boolean submitForModeration(DocumentReference document) throws XWikiException {
        XWikiContext xcontext = this.getXContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(document, xcontext);
        BaseObject workflow = this.validateWorkflow(doc, Arrays.asList(STATUS_DRAFT), 0, xcontext);
        if (workflow == null) {
            return false;
        }
        BaseObject wfConfig = this.configManager.getWorkflowConfig(workflow.getStringValue(WF_CONFIG_REF_FIELDNAME), xcontext);
        String moderators = this.publicationRoles.getModerators(wfConfig, xcontext);
        if (StringUtils.isEmpty((String)moderators)) {
            return this.submitForValidation(document);
        }
        workflow.set(WF_STATUS_FIELDNAME, (Object)STATUS_MODERATING, xcontext);
        String validators = this.publicationRoles.getValidators(wfConfig, xcontext);
        String contributors = this.publicationRoles.getContributors(wfConfig, xcontext);
        this.setRights(doc, Arrays.asList("edit", "view"), Arrays.asList(moderators, validators), Arrays.asList(new String[0]), true, xcontext);
        this.addRights(doc, Arrays.asList("view"), Arrays.asList(contributors), Arrays.asList(new String[0]), true, xcontext);
        String defaultMessage = "Submitted document " + (String)this.stringSerializer.serialize((EntityReference)document, new Object[0]) + " for moderation ";
        String message = this.getMessage("workflow.save.submitForModeration", defaultMessage, Arrays.asList(((String)this.stringSerializer.serialize((EntityReference)document, new Object[0])).toString()));
        xcontext.getWiki().saveDocument(doc, message, true, xcontext);
        return true;
    }

    @Override
    public boolean refuseModeration(DocumentReference document, String reason) throws XWikiException {
        XWikiContext xcontext = this.getXContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(document, xcontext);
        BaseObject workflow = this.validateWorkflow(doc, Arrays.asList(STATUS_MODERATING), 0, xcontext);
        if (workflow == null) {
            return false;
        }
        this.makeDocumentDraft(doc, workflow, xcontext);
        String defaultMessage = "Refused moderation : " + reason;
        String message = this.getMessage("workflow.save.refuseModeration", defaultMessage, Arrays.asList(reason));
        xcontext.getWiki().saveDocument(doc, message, false, xcontext);
        return true;
    }

    @Override
    public boolean submitForValidation(DocumentReference document) throws XWikiException {
        XWikiContext xcontext = this.getXContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(document, xcontext);
        BaseObject workflow = this.validateWorkflow(doc, Arrays.asList(STATUS_MODERATING, STATUS_DRAFT), 0, xcontext);
        if (workflow == null) {
            return false;
        }
        workflow.set(WF_STATUS_FIELDNAME, (Object)STATUS_VALIDATING, xcontext);
        BaseObject wfConfig = this.configManager.getWorkflowConfig(workflow.getStringValue(WF_CONFIG_REF_FIELDNAME), xcontext);
        String validators = this.publicationRoles.getValidators(wfConfig, xcontext);
        String contributors = this.publicationRoles.getContributors(wfConfig, xcontext);
        String moderators = this.publicationRoles.getModerators(wfConfig, xcontext);
        this.setRights(doc, Arrays.asList("edit", "view"), Arrays.asList(validators), Arrays.asList(new String[0]), true, xcontext);
        this.addRights(doc, Arrays.asList("view"), Arrays.asList(moderators, contributors), Arrays.asList(new String[0]), true, xcontext);
        String defaultMessage = "Submitted document " + (String)this.stringSerializer.serialize((EntityReference)document, new Object[0]) + "for validation.";
        String message = this.getMessage("workflow.save.submitForValidation", defaultMessage, Arrays.asList(((String)this.stringSerializer.serialize((EntityReference)document, new Object[0])).toString()));
        xcontext.getWiki().saveDocument(doc, message, true, xcontext);
        return true;
    }

    @Override
    public boolean refuseValidation(DocumentReference document, String reason) throws XWikiException {
        XWikiContext xcontext = this.getXContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(document, xcontext);
        BaseObject workflow = this.validateWorkflow(doc, Arrays.asList(STATUS_VALIDATING), 0, xcontext);
        if (workflow == null) {
            return false;
        }
        this.makeDocumentDraft(doc, workflow, xcontext);
        String defaultMessage = "Refused publication : " + reason;
        String message = this.getMessage("workflow.save.refuseValidation", defaultMessage, Arrays.asList(reason));
        xcontext.getWiki().saveDocument(doc, message, false, xcontext);
        return true;
    }

    @Override
    public boolean validate(DocumentReference document) throws XWikiException {
        XWikiContext xcontext = this.getXContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(document, xcontext);
        BaseObject workflow = this.validateWorkflow(doc, Arrays.asList(STATUS_VALIDATING), 0, xcontext);
        if (workflow == null) {
            return false;
        }
        workflow.set(WF_STATUS_FIELDNAME, (Object)STATUS_VALID, xcontext);
        String defaultMessage = "Marked document " + (String)this.stringSerializer.serialize((EntityReference)document, new Object[0]) + " as valid.";
        String message = this.getMessage("workflow.save.validate", defaultMessage, Arrays.asList(((String)this.stringSerializer.serialize((EntityReference)document, new Object[0])).toString()));
        xcontext.getWiki().saveDocument(doc, message, true, xcontext);
        return true;
    }

    @Override
    public DocumentReference publish(DocumentReference document) throws XWikiException {
        XWikiContext xcontext = this.getXContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(document, xcontext);
        BaseObject workflow = this.validateWorkflow(doc, Arrays.asList(STATUS_VALIDATING, STATUS_VALID), 0, xcontext);
        if (workflow == null) {
            return null;
        }
        String target = workflow.getStringValue(WF_TARGET_FIELDNAME);
        if (StringUtils.isEmpty((String)target)) {
            return null;
        }
        DocumentReference targetRef = this.explicitStringDocRefResolver.resolve((Object)target, new Object[]{document});
        XWikiDocument newDocument = xcontext.getWiki().getDocument(targetRef, xcontext);
        try {
            this.copyContentsToNewVersion(doc, newDocument, xcontext);
        }
        catch (IOException e) {
            throw new XWikiException(2, 0, "Error accessing attachments when copying document " + (String)this.stringSerializer.serialize((EntityReference)doc.getDocumentReference(), new Object[0]) + " to document " + (String)this.stringSerializer.serialize((EntityReference)newDocument.getDocumentReference(), new Object[0]), (Throwable)e);
        }
        newDocument.setHidden(Boolean.valueOf(false));
        BaseObject newWorkflow = newDocument.getXObject(PUBLICATION_WORKFLOW_CLASS);
        if (newWorkflow == null) {
            newWorkflow = newDocument.newXObject(PUBLICATION_WORKFLOW_CLASS, xcontext);
            newWorkflow.set(WF_STATUS_FIELDNAME, (Object)STATUS_PUBLISHED, xcontext);
            newWorkflow.set(WF_IS_TARGET_FIELDNAME, (Object)1, xcontext);
            newWorkflow.set(WF_TARGET_FIELDNAME, (Object)target, xcontext);
            newWorkflow.set(WF_CONFIG_REF_FIELDNAME, (Object)workflow.getStringValue(WF_CONFIG_REF_FIELDNAME), xcontext);
        }
        String defaultMessage = "Published new version of the document.";
        String message = this.getMessage("workflow.save.publishNew", defaultMessage, null);
        xcontext.getWiki().saveDocument(newDocument, message, false, xcontext);
        workflow.set(WF_STATUS_FIELDNAME, (Object)STATUS_PUBLISHED, xcontext);
        BaseObject wfConfig = this.configManager.getWorkflowConfig(workflow.getStringValue(WF_CONFIG_REF_FIELDNAME), xcontext);
        if (wfConfig != null) {
            String contributors = this.publicationRoles.getContributors(wfConfig, xcontext);
            String moderators = this.publicationRoles.getModerators(wfConfig, xcontext);
            String validators = this.publicationRoles.getValidators(wfConfig, xcontext);
            this.setRights(doc, Arrays.asList("edit", "view"), Arrays.asList(contributors, moderators, validators), Arrays.asList(new String[0]), true, xcontext);
        }
        String defaultMessage2 = "Published this document to " + (String)this.stringSerializer.serialize((EntityReference)document, new Object[0]) + ".";
        String message2 = this.getMessage("workflow.save.publishDraft", defaultMessage2, Arrays.asList(((String)this.stringSerializer.serialize((EntityReference)targetRef, new Object[0])).toString()));
        xcontext.getWiki().saveDocument(doc, message2, false, xcontext);
        return targetRef;
    }

    @Override
    public DocumentReference unpublish(DocumentReference document, boolean forceToDraft) throws XWikiException {
        XWikiContext xcontext = this.getXContext();
        XWikiDocument targetDoc = xcontext.getWiki().getDocument(document, xcontext);
        BaseObject targetWorkflow = this.validateWorkflow(targetDoc, Arrays.asList(STATUS_PUBLISHED, STATUS_ARCHIVED), 1, xcontext);
        if (targetWorkflow == null) {
            return null;
        }
        DocumentReference draftDocRef = this.getDraftDocument(document, xcontext);
        if (draftDocRef != null) {
            XWikiDocument draftDoc = xcontext.getWiki().getDocument(draftDocRef, xcontext);
            BaseObject workflow = draftDoc.getXObject(PUBLICATION_WORKFLOW_CLASS);
            String draftStatus = workflow.getStringValue(WF_STATUS_FIELDNAME);
            if (STATUS_PUBLISHED.equals(draftStatus) || !forceToDraft) {
                if (STATUS_PUBLISHED.equals(draftStatus)) {
                    this.makeDocumentDraft(draftDoc, workflow, xcontext);
                    String defaultMessage = "Created draft from published document" + (String)this.stringSerializer.serialize((EntityReference)document, new Object[0]) + ".";
                    String message = this.getMessage("workflow.save.unpublish", defaultMessage, Arrays.asList(((String)this.stringSerializer.serialize((EntityReference)document, new Object[0])).toString()));
                    xcontext.getWiki().saveDocument(draftDoc, message, true, xcontext);
                }
            } else {
                try {
                    this.copyContentsToNewVersion(targetDoc, draftDoc, xcontext);
                }
                catch (IOException e) {
                    throw new XWikiException(2, 0, "Error accessing attachments when copying document " + (String)this.stringSerializer.serialize((EntityReference)targetDoc.getDocumentReference(), new Object[0]) + " to document " + (String)this.stringSerializer.serialize((EntityReference)draftDoc.getDocumentReference(), new Object[0]), (Throwable)e);
                }
                this.makeDocumentDraft(draftDoc, workflow, xcontext);
                String defaultMessage = "Created draft from published document" + (String)this.stringSerializer.serialize((EntityReference)document, new Object[0]) + ".";
                String message = this.getMessage("workflow.save.unpublish", defaultMessage, Arrays.asList(((String)this.stringSerializer.serialize((EntityReference)document, new Object[0])).toString()));
                xcontext.getWiki().saveDocument(draftDoc, message, true, xcontext);
            }
        } else {
            draftDocRef = this.createDraftDocument(document, xcontext);
        }
        if (draftDocRef != null) {
            xcontext.getWiki().deleteDocument(targetDoc, xcontext);
            return draftDocRef;
        }
        return null;
    }

    @Override
    public boolean editDraft(DocumentReference document) throws XWikiException {
        XWikiContext xcontext = this.getXContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(document, xcontext);
        BaseObject workflow = doc.getXObject(PUBLICATION_WORKFLOW_CLASS);
        String draftStatus = workflow.getStringValue(WF_STATUS_FIELDNAME);
        if (draftStatus.equals(STATUS_PUBLISHED)) {
            this.makeDocumentDraft(doc, workflow, xcontext);
            String defaultMessage = "Back to draft status to enable editing.";
            String message = this.getMessage("workflow.save.backToDraft", defaultMessage, null);
            xcontext.getWiki().saveDocument(doc, message, true, xcontext);
            return true;
        }
        return false;
    }

    @Override
    public boolean archive(DocumentReference document) throws XWikiException {
        XWikiContext xcontext = this.getXContext();
        XWikiDocument publishedDoc = xcontext.getWiki().getDocument(document, xcontext);
        BaseObject publishedWorkflow = this.validateWorkflow(publishedDoc, Arrays.asList(STATUS_PUBLISHED), 1, xcontext);
        if (publishedWorkflow == null) {
            return false;
        }
        publishedWorkflow.set(WF_STATUS_FIELDNAME, (Object)STATUS_ARCHIVED, xcontext);
        publishedDoc.setHidden(Boolean.valueOf(true));
        String defaultMessage = "Archived document.";
        String message = this.getMessage("workflow.save.archive", defaultMessage, null);
        xcontext.getWiki().saveDocument(publishedDoc, message, true, xcontext);
        return true;
    }

    @Override
    public DocumentReference unarchive(DocumentReference document, boolean forceToDraft) throws XWikiException {
        return this.unpublish(document, forceToDraft);
    }

    @Override
    public boolean publishFromArchive(DocumentReference document) throws XWikiException {
        XWikiContext xcontext = this.getXContext();
        XWikiDocument archivedDoc = xcontext.getWiki().getDocument(document, xcontext);
        BaseObject archivedWorkflow = this.validateWorkflow(archivedDoc, Arrays.asList(STATUS_ARCHIVED), 1, xcontext);
        if (archivedWorkflow == null) {
            return false;
        }
        archivedWorkflow.set(WF_STATUS_FIELDNAME, (Object)STATUS_PUBLISHED, xcontext);
        archivedDoc.setHidden(Boolean.valueOf(false));
        String defaultMessage = "Published document from an archive.";
        String message = this.messageTool.get("workflow.save.publishFromArchive", new Object[]{defaultMessage, null});
        xcontext.getWiki().saveDocument(archivedDoc, message, true, xcontext);
        return true;
    }

    private boolean copyContentsToNewVersion(XWikiDocument fromDocument, XWikiDocument toDocument, XWikiContext xcontext) throws XWikiException, IOException {
        List exception;
        XWikiDocument previousDoc = toDocument.clone();
        previousDoc.removeXObjects(this.explicitReferenceDocRefResolver.resolve((Object)COMMENTS_CLASS, new Object[]{previousDoc.getDocumentReference()}));
        previousDoc.removeXObjects(this.explicitReferenceDocRefResolver.resolve((Object)RIGHTS_CLASS, new Object[]{previousDoc.getDocumentReference()}));
        previousDoc.removeXObjects(this.explicitReferenceDocRefResolver.resolve((Object)PUBLICATION_WORKFLOW_CLASS, new Object[]{previousDoc.getDocumentReference()}));
        XWikiDocument nextDoc = fromDocument.duplicate(toDocument.getDocumentReference());
        nextDoc.removeXObjects(this.explicitReferenceDocRefResolver.resolve((Object)COMMENTS_CLASS, new Object[]{nextDoc.getDocumentReference()}));
        nextDoc.removeXObjects(this.explicitReferenceDocRefResolver.resolve((Object)RIGHTS_CLASS, new Object[]{nextDoc.getDocumentReference()}));
        nextDoc.removeXObjects(this.explicitReferenceDocRefResolver.resolve((Object)PUBLICATION_WORKFLOW_CLASS, new Object[]{nextDoc.getDocumentReference()}));
        for (XWikiAttachment fromAttachment : fromDocument.getAttachmentList()) {
            fromAttachment.loadContent(xcontext);
            XWikiAttachment newAttachment = toDocument.getAttachment(fromAttachment.getFilename());
            if (newAttachment == null) {
                newAttachment = toDocument.addAttachment(fromAttachment.getFilename(), fromAttachment.getContentInputStream(xcontext), xcontext);
                newAttachment.setAuthor(fromAttachment.getAuthor());
                newAttachment.setDate(fromAttachment.getDate());
            } else {
                newAttachment.loadContent(xcontext);
                boolean isSameAttachmentContent = Arrays.equals(newAttachment.getAttachment_content().getContent(), fromAttachment.getAttachment_content().getContent());
                newAttachment.setAttachment_content(null);
                if (!isSameAttachmentContent) {
                    newAttachment.setContent(fromAttachment.getContentInputStream(xcontext));
                }
            }
            fromAttachment.setAttachment_content(null);
        }
        MergeResult result = toDocument.merge(previousDoc, nextDoc, new MergeConfiguration(), xcontext);
        if (toDocument.isNew()) {
            toDocument.setCreatorReference(fromDocument.getCreatorReference());
        }
        if ((exception = result.getLog().getLogs(LogLevel.ERROR)).isEmpty()) {
            return true;
        }
        StringBuffer exceptions = new StringBuffer();
        for (LogEvent e : exception) {
            if (exceptions.length() == 0) {
                exceptions.append(";");
            }
            exceptions.append(e.getMessage());
        }
        throw new XWikiException(2, 0, "Could not copy document contents from " + (String)this.stringSerializer.serialize((EntityReference)fromDocument.getDocumentReference(), new Object[0]) + " to document " + (String)this.stringSerializer.serialize((EntityReference)toDocument.getDocumentReference(), new Object[0]) + ". Caused by: " + exceptions.toString());
    }

    private void makeDocumentDraft(XWikiDocument doc, BaseObject workflow, XWikiContext xcontext) throws XWikiException {
        BaseObject workflowObj = workflow;
        if (workflowObj == null) {
            workflowObj = doc.getXObject(PUBLICATION_WORKFLOW_CLASS);
        }
        workflowObj.set(WF_STATUS_FIELDNAME, (Object)STATUS_DRAFT, xcontext);
        workflowObj.set(WF_IS_TARGET_FIELDNAME, (Object)0, xcontext);
        this.setupDraftAccess(doc, workflowObj, xcontext);
    }

    private BaseObject validateWorkflow(XWikiDocument document, List<String> expectedStatuses, Integer expectedIsTarget, XWikiContext xcontext) throws XWikiException {
        if (!this.isWorkflowDocument(document, xcontext)) {
            return null;
        }
        BaseObject workflowObj = document.getXObject(PUBLICATION_WORKFLOW_CLASS);
        if (!expectedStatuses.contains(workflowObj.getStringValue(WF_STATUS_FIELDNAME))) {
            return null;
        }
        int isTargetValue = workflowObj.getIntValue(WF_IS_TARGET_FIELDNAME, 0);
        if (!(expectedIsTarget > 0 && isTargetValue > 0 || expectedIsTarget <= 0 && expectedIsTarget <= 0)) {
            return null;
        }
        return workflowObj;
    }

    private void setRights(XWikiDocument document, List<String> levels, List<String> groups, List<String> users, boolean allowdeny, XWikiContext context) throws XWikiException {
        this.removeRights(document, context);
        this.addRights(document, levels, groups, users, allowdeny, context);
    }

    private void addRights(XWikiDocument document, List<String> levels, List<String> groups, List<String> users, boolean allowdeny, XWikiContext context) throws XWikiException {
        BaseObject rightsObject = document.newXObject(RIGHTS_CLASS, context);
        rightsObject.set(RIGHTS_ALLOWDENY, (Object)(allowdeny ? 1 : 0), context);
        PropertyClass groupsPropClass = (PropertyClass)rightsObject.getXClass(context).get(RIGHTS_GROUPS);
        BaseProperty groupsProperty = groupsPropClass.fromStringArray((String[])groups.toArray());
        rightsObject.set(RIGHTS_GROUPS, groupsProperty.getValue(), context);
        PropertyClass usersPropClass = (PropertyClass)rightsObject.getXClass(context).get(RIGHTS_USERS);
        BaseProperty usersProperty = usersPropClass.fromStringArray((String[])users.toArray());
        rightsObject.set(RIGHTS_USERS, usersProperty.getValue(), context);
        PropertyClass levelsPropClass = (PropertyClass)rightsObject.getXClass(context).get(RIGHTS_LEVELS);
        BaseProperty levelsProperty = levelsPropClass.fromStringArray((String[])levels.toArray());
        rightsObject.set(RIGHTS_LEVELS, levelsProperty.getValue(), context);
    }

    private void removeRights(XWikiDocument document, XWikiContext context) throws XWikiException {
        document.removeXObjects(this.explicitReferenceDocRefResolver.resolve((Object)RIGHTS_CLASS, new Object[]{document.getDocumentReference()}));
    }

    private XWikiContext getXContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    private String getMessage(String key, String defaultMessage, List<String> params) {
        if (this.messageTool == null) {
            this.messageTool = this.getXContext().getMessageTool();
        }
        String message = "";
        message = params != null ? this.messageTool.get(key, params) : this.messageTool.get(key);
        if (message.equals(key)) {
            return defaultMessage;
        }
        return message;
    }
}

