/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.workflowpublication.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.script.service.ScriptService;
import org.xwiki.workflowpublication.PublicationRoles;

@Component
@Named(value="publicationroles")
@Singleton
public class PublicationRolesService
implements ScriptService {
    @Inject
    private PublicationRoles publicationRoles;
    @Inject
    @Named(value="currentmixed")
    protected DocumentReferenceResolver<String> referenceResolver;
    @Inject
    protected Execution execution;
    @Inject
    private Logger logger;

    public boolean canValidate(String user, String document) {
        try {
            DocumentReference userRef = this.referenceResolver.resolve((Object)user, new Object[0]);
            XWikiContext context = this.getXContext();
            XWikiDocument documentObject = null;
            if (!StringUtils.isEmpty((String)document)) {
                DocumentReference documentRef = this.referenceResolver.resolve((Object)document, new Object[0]);
                documentObject = context.getWiki().getDocument(documentRef, context);
            }
            return this.publicationRoles.canValidate(userRef, documentObject, context);
        }
        catch (XWikiException e) {
            this.logger.error("There was an error getting the validation rights for user " + user + " for document " + document, (Throwable)e);
            return false;
        }
    }

    public boolean canModerate(String user, String document) {
        try {
            DocumentReference userRef = this.referenceResolver.resolve((Object)user, new Object[0]);
            XWikiContext context = this.getXContext();
            XWikiDocument documentObject = null;
            if (!StringUtils.isEmpty((String)document)) {
                DocumentReference documentRef = this.referenceResolver.resolve((Object)document, new Object[0]);
                documentObject = context.getWiki().getDocument(documentRef, context);
            }
            return this.publicationRoles.canModerate(userRef, documentObject, context);
        }
        catch (XWikiException e) {
            this.logger.error("There was an error getting the moderation rights for user " + user + " for document " + document, (Throwable)e);
            return false;
        }
    }

    public boolean canContribute(String user, String document) {
        try {
            DocumentReference userRef = this.referenceResolver.resolve((Object)user, new Object[0]);
            XWikiContext context = this.getXContext();
            XWikiDocument documentObject = null;
            if (!StringUtils.isEmpty((String)document)) {
                DocumentReference documentRef = this.referenceResolver.resolve((Object)document, new Object[0]);
                documentObject = context.getWiki().getDocument(documentRef, context);
            }
            return this.publicationRoles.canContribute(userRef, documentObject, context);
        }
        catch (XWikiException e) {
            this.logger.error("There was an error getting the contribution rights for user " + user + " for document " + document, (Throwable)e);
            return false;
        }
    }

    public Collection<String> getGroups(DocumentReference userOrGroup, boolean recursive, boolean localGroups, boolean userWikiGroups) {
        try {
            XWikiContext context = this.getXContext();
            return this.publicationRoles.getGroups(userOrGroup, recursive, localGroups, userWikiGroups, context);
        }
        catch (XWikiException e) {
            this.logger.error("There was an error getting all the groups for user " + userOrGroup, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public Collection<String> getGroups(String userOrGroup, boolean recursive, boolean localGroups, boolean userWikiGroups) {
        DocumentReference userRef = this.referenceResolver.resolve((Object)userOrGroup, new Object[0]);
        return this.getGroups(userRef, recursive, localGroups, userWikiGroups);
    }

    public Collection<String> getAllGroups(DocumentReference userOrGroup, boolean recursive) {
        return this.getGroups(userOrGroup, recursive, true, true);
    }

    public Collection<String> getAllGroups(String userOrGroup, boolean recursive) {
        return this.getGroups(userOrGroup, recursive, true, true);
    }

    private XWikiContext getXContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }
}

