/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.workflowpublication.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.script.service.ScriptService;
import org.xwiki.workflowpublication.PublicationRoles;
import org.xwiki.workflowpublication.PublicationWorkflow;

@Component
@Named(value="publicationworkflow")
@Singleton
public class PublicationWorkflowService
implements ScriptService {
    @Inject
    protected PublicationWorkflow publicationWorkflow;
    @Inject
    protected PublicationRoles publicationRoles;
    @Inject
    protected Execution execution;
    @Inject
    private Logger logger;
    @Inject
    protected EntityReferenceSerializer<String> stringSerializer;
    @Inject
    @Named(value="current")
    protected DocumentReferenceResolver<String> referenceResolver;

    public boolean isWorkflowDocument(String document) {
        try {
            XWikiContext context = this.getXContext();
            XWikiDocument documentObject = null;
            if (!StringUtils.isEmpty((String)document)) {
                DocumentReference documentRef = this.referenceResolver.resolve((Object)document, new Object[0]);
                documentObject = context.getWiki().getDocument(documentRef, context);
            }
            return this.publicationWorkflow.isWorkflowDocument(documentObject, context);
        }
        catch (XWikiException e) {
            this.logger.error("There was an error getting the workflow for document " + document, (Throwable)e);
            return false;
        }
    }

    public boolean startWorkflow(DocumentReference doc, String workflowConfig, DocumentReference target) {
        XWikiContext xcontext = this.getXContext();
        try {
            if (xcontext.getWiki().getRightService().hasAccessLevel("edit", (String)this.stringSerializer.serialize((EntityReference)xcontext.getUserReference(), new Object[0]), (String)this.stringSerializer.serialize((EntityReference)doc, new Object[0]), xcontext)) {
                return this.publicationWorkflow.startWorkflow(doc, workflowConfig, target, xcontext);
            }
            return false;
        }
        catch (XWikiException e) {
            this.logger.warn("Could not start workflow for document " + (String)this.stringSerializer.serialize((EntityReference)doc, new Object[0]) + " and config " + workflowConfig);
            return false;
        }
    }

    public List<String> startMatchingWorkflows(DocumentReference doc, DocumentReference target) {
        XWikiContext xcontext = this.getXContext();
        return this.publicationWorkflow.startMatchingWorkflows(doc, target, xcontext);
    }

    public DocumentReference getDraftDocument(DocumentReference target) {
        XWikiContext xcontext = this.getXContext();
        try {
            return this.publicationWorkflow.getDraftDocument(target, xcontext);
        }
        catch (XWikiException e) {
            this.logger.warn("Could not query for workflow draft for target " + (String)this.stringSerializer.serialize((EntityReference)target, new Object[0]));
            return null;
        }
    }

    public boolean submitForModeration(DocumentReference document) {
        XWikiContext xcontext = this.getXContext();
        try {
            if (this.publicationRoles.canContribute(xcontext.getUserReference(), xcontext.getWiki().getDocument(document, xcontext), xcontext)) {
                return this.publicationWorkflow.submitForModeration(document);
            }
            return false;
        }
        catch (XWikiException e) {
            this.logger.warn("Could not submit document " + (String)this.stringSerializer.serialize((EntityReference)document, new Object[0]) + " to moderation");
            return false;
        }
    }

    public boolean refuseModeration(DocumentReference document, String reason) {
        XWikiContext xcontext = this.getXContext();
        try {
            if (this.publicationRoles.canModerate(xcontext.getUserReference(), xcontext.getWiki().getDocument(document, xcontext), xcontext)) {
                return this.publicationWorkflow.refuseModeration(document, reason);
            }
            return false;
        }
        catch (XWikiException e) {
            this.logger.warn("Could not refuse moderation for document " + (String)this.stringSerializer.serialize((EntityReference)document, new Object[0]));
            return false;
        }
    }

    public boolean submitForValidation(DocumentReference document) {
        XWikiContext xcontext = this.getXContext();
        try {
            if (this.publicationRoles.canModerate(xcontext.getUserReference(), xcontext.getWiki().getDocument(document, xcontext), xcontext)) {
                return this.publicationWorkflow.submitForValidation(document);
            }
            return false;
        }
        catch (XWikiException e) {
            this.logger.warn("Could not submit document " + (String)this.stringSerializer.serialize((EntityReference)document, new Object[0]) + " to validation");
            return false;
        }
    }

    public boolean refuseValidation(DocumentReference document, String reason) {
        XWikiContext xcontext = this.getXContext();
        try {
            if (this.publicationRoles.canValidate(xcontext.getUserReference(), xcontext.getWiki().getDocument(document, xcontext), xcontext)) {
                return this.publicationWorkflow.refuseValidation(document, reason);
            }
            return false;
        }
        catch (XWikiException e) {
            this.logger.warn("Could not refuse validation for document " + (String)this.stringSerializer.serialize((EntityReference)document, new Object[0]));
            return false;
        }
    }

    public boolean validate(DocumentReference document) {
        XWikiContext xcontext = this.getXContext();
        try {
            if (this.publicationRoles.canValidate(xcontext.getUserReference(), xcontext.getWiki().getDocument(document, xcontext), xcontext)) {
                return this.publicationWorkflow.validate(document);
            }
            return false;
        }
        catch (XWikiException e) {
            this.logger.warn("Could not mark document " + (String)this.stringSerializer.serialize((EntityReference)document, new Object[0]) + " as valid.");
            return false;
        }
    }

    public DocumentReference publish(DocumentReference document) {
        XWikiContext xcontext = this.getXContext();
        try {
            if (this.publicationRoles.canValidate(xcontext.getUserReference(), xcontext.getWiki().getDocument(document, xcontext), xcontext)) {
                return this.publicationWorkflow.publish(document);
            }
            return null;
        }
        catch (XWikiException e) {
            this.logger.warn("Could not publish document " + (String)this.stringSerializer.serialize((EntityReference)document, new Object[0]));
            return null;
        }
    }

    public DocumentReference unpublish(DocumentReference document, boolean forceToDraft) {
        XWikiContext xcontext = this.getXContext();
        try {
            if (this.publicationRoles.canContribute(xcontext.getUserReference(), xcontext.getWiki().getDocument(document, xcontext), xcontext)) {
                return this.publicationWorkflow.unpublish(document, forceToDraft);
            }
            return null;
        }
        catch (XWikiException e) {
            this.logger.warn("Could not unpublish document " + (String)this.stringSerializer.serialize((EntityReference)document, new Object[0]));
            return null;
        }
    }

    public boolean editDraft(DocumentReference document) {
        XWikiContext xcontext = this.getXContext();
        try {
            if (this.publicationRoles.canContribute(xcontext.getUserReference(), xcontext.getWiki().getDocument(document, xcontext), xcontext)) {
                return this.publicationWorkflow.editDraft(document);
            }
            return false;
        }
        catch (XWikiException e) {
            this.logger.warn("Could not change " + (String)this.stringSerializer.serialize((EntityReference)document, new Object[0]) + " status to draft");
            return false;
        }
    }

    public boolean archive(DocumentReference document) {
        XWikiContext xcontext = this.getXContext();
        try {
            if (this.publicationRoles.canContribute(xcontext.getUserReference(), xcontext.getWiki().getDocument(document, xcontext), xcontext)) {
                return this.publicationWorkflow.archive(document);
            }
            return false;
        }
        catch (XWikiException e) {
            this.logger.warn("Could not archive document " + (String)this.stringSerializer.serialize((EntityReference)document, new Object[0]));
            return false;
        }
    }

    public DocumentReference unarchive(DocumentReference document, boolean forceToDraft) {
        XWikiContext xcontext = this.getXContext();
        try {
            if (this.publicationRoles.canContribute(xcontext.getUserReference(), xcontext.getWiki().getDocument(document, xcontext), xcontext)) {
                return this.publicationWorkflow.unarchive(document, forceToDraft);
            }
            return null;
        }
        catch (XWikiException e) {
            this.logger.warn("Could not unpublish document " + (String)this.stringSerializer.serialize((EntityReference)document, new Object[0]));
            return null;
        }
    }

    public boolean publishFromArchive(DocumentReference document) {
        XWikiContext xcontext = this.getXContext();
        try {
            if (this.publicationRoles.canValidate(xcontext.getUserReference(), xcontext.getWiki().getDocument(document, xcontext), xcontext)) {
                return this.publicationWorkflow.publishFromArchive(document);
            }
            return false;
        }
        catch (XWikiException e) {
            this.logger.warn("Could not publish document " + (String)this.stringSerializer.serialize((EntityReference)document, new Object[0]) + " from archive");
            return false;
        }
    }

    private XWikiContext getXContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }
}

