/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.workflowpublication.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.ObjectDiff;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentUpdatingEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.workflowpublication.PublicationRoles;
import org.xwiki.workflowpublication.PublicationWorkflow;

@Component
@Named(value="moderation-protection")
@Singleton
public class RolesEnforcerListener
implements EventListener {
    public static final String STATUS_PROPNAME = "status";
    public static final String STATUS_MODERATING = "moderating";
    public static final String STATUS_VALIDATING = "validating";
    public static final String STATUS_DRAFT = "draft";
    public static final String STATUS_PUBLISHED = "published";
    public static final String STATUS_ARCHIVED = "archived";
    @Inject
    private Logger logger;
    @Inject
    @Named(value="current/reference")
    protected DocumentReferenceResolver<EntityReference> currentReferenceEntityResolver;
    @Inject
    protected EntityReferenceSerializer<String> stringSerializer;
    @Inject
    @Named(value="publicationroles")
    protected PublicationRoles publicationRoles;
    @Inject
    protected PublicationWorkflow publicationWorkflow;
    private final List<Event> eventsList = new ArrayList<DocumentUpdatingEvent>(Arrays.asList(new DocumentUpdatingEvent()));

    public List<Event> getEvents() {
        return this.eventsList;
    }

    public String getName() {
        return "ModerationProtectionListener";
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument currentDocument = (XWikiDocument)source;
        XWikiDocument previousDocument = currentDocument.getOriginalDocument();
        XWikiContext context = (XWikiContext)data;
        try {
            if (!this.publicationWorkflow.isWorkflowDocument(previousDocument, context)) {
                return;
            }
        }
        catch (XWikiException exc) {
            this.logger.warn("Could not get workflow config document for document " + (String)this.stringSerializer.serialize((EntityReference)previousDocument.getDocumentReference(), new Object[0]));
            return;
        }
        boolean isOtherWorkflowChange = false;
        List objectDiffs = currentDocument.getObjectDiff(previousDocument, currentDocument, context);
        for (List objectChanges : objectDiffs) {
            for (ObjectDiff diff : objectChanges) {
                if (!diff.getXClassReference().equals((Object)this.currentReferenceEntityResolver.resolve((Object)PublicationWorkflow.PUBLICATION_WORKFLOW_CLASS, new Object[0]))) continue;
                isOtherWorkflowChange = true;
            }
        }
        if (isOtherWorkflowChange) {
            // empty if block
        }
    }
}

