/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.util.Debug;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.n3.nanoxml.XMLElement;

public class JavaCondition
extends Condition {
    private static final long serialVersionUID = -7649870719815066537L;
    protected String classname;
    protected String methodname;
    protected String fieldname;
    protected boolean complete;
    protected String returnvalue;
    protected String returnvaluetype;
    protected Class usedclass;
    protected Field usedfield;
    protected Method usedmethod;

    public boolean isTrue() {
        if (!this.complete) {
            return false;
        }
        if (this.usedclass == null) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            try {
                this.usedclass = classLoader.loadClass(this.classname);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.log("Can't find class " + this.classname);
                return false;
            }
        }
        if (this.usedfield == null && this.fieldname != null) {
            try {
                this.usedfield = this.usedclass.getField(this.fieldname);
            }
            catch (SecurityException securityException) {
                Debug.log("No permission to access specified field: " + this.fieldname);
                return false;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Debug.log("No such field: " + this.fieldname);
                return false;
            }
        }
        if (this.usedmethod == null && this.methodname != null) {
            Debug.log("not implemented yet.");
            return false;
        }
        if (this.usedfield != null) {
            if ("boolean".equals(this.returnvaluetype)) {
                try {
                    boolean bl = this.usedfield.getBoolean(null);
                    boolean bl2 = Boolean.valueOf(this.returnvalue);
                    return bl == bl2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Debug.log("IllegalArgumentexeption " + this.fieldname);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Debug.log("IllegalAccessException " + this.fieldname);
                }
            } else {
                Debug.log("not implemented yet.");
                return false;
            }
        }
        return false;
    }

    public void readFromXML(XMLElement xMLElement) {
        XMLElement xMLElement2;
        if (xMLElement.getChildrenCount() != 2) {
            Debug.log("Condition of type java needs (java,returnvalue)");
            return;
        }
        XMLElement xMLElement3 = xMLElement.getFirstChildNamed("java");
        XMLElement xMLElement4 = xMLElement3.getFirstChildNamed("class");
        if (xMLElement4 == null) {
            Debug.log("Java-Element needs (class,method?,field?)");
            return;
        }
        this.classname = xMLElement4.getContent();
        XMLElement xMLElement5 = xMLElement3.getFirstChildNamed("method");
        if (xMLElement5 != null) {
            this.methodname = xMLElement5.getContent();
        }
        if ((xMLElement2 = xMLElement3.getFirstChildNamed("field")) != null) {
            this.fieldname = xMLElement2.getContent();
        }
        if (this.methodname == null && this.fieldname == null) {
            Debug.log("java element needs (class, method?,field?)");
            return;
        }
        XMLElement xMLElement6 = xMLElement.getFirstChildNamed("returnvalue");
        if (xMLElement6 == null) {
            Debug.log("no returnvalue-element specified.");
            return;
        }
        this.returnvalue = xMLElement6.getContent();
        this.returnvaluetype = xMLElement6.getAttribute("type");
        this.complete = true;
    }

    public String getDependenciesDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.id);
        stringBuffer.append(" depends on the ");
        if (this.fieldname != null) {
            stringBuffer.append("value of field <b>");
            stringBuffer.append(this.fieldname);
            stringBuffer.append("</b>");
        } else {
            stringBuffer.append("return value of method <b>");
            stringBuffer.append(this.methodname);
            stringBuffer.append("</b>");
        }
        stringBuffer.append(" on an instance of class <b>");
        stringBuffer.append(this.classname);
        stringBuffer.append("</b> which should be <b>");
        stringBuffer.append(this.returnvalue);
        stringBuffer.append("</b><br/>");
        return stringBuffer.toString();
    }
}

