/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.escaping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xwiki.test.escaping.framework.AbstractEscapingTest;
import org.xwiki.test.escaping.framework.AbstractVelocityEscapingTest;
import org.xwiki.test.escaping.framework.EscapingError;
import org.xwiki.test.escaping.framework.SingleXWikiExecutor;
import org.xwiki.test.escaping.framework.XMLEscapingValidator;
import org.xwiki.test.escaping.suite.ArchiveSuite;
import org.xwiki.validator.ValidationError;

@RunWith(value=ArchiveSuite.class)
public class TemplateTest
extends AbstractVelocityEscapingTest {
    @ArchiveSuite.ArchivePathGetter
    public static String getArchivePath() {
        return System.getProperty("localRepository") + "/" + System.getProperty("pathToXWikiWar");
    }

    @ArchiveSuite.BeforeSuite
    public static void init() throws Exception {
        SingleXWikiExecutor.getExecutor().start();
        AbstractEscapingTest.setMultiLanguageMode(true);
    }

    @ArchiveSuite.AfterSuite
    public static void shutdown() throws Exception {
        AbstractEscapingTest.setMultiLanguageMode(false);
        SingleXWikiExecutor.getExecutor().stop();
    }

    public TemplateTest() {
        super(Pattern.compile(".*\\.vm"));
    }

    @Test
    public void testSpaceEscaping() {
        String url = this.createUrl(XMLEscapingValidator.getTestString(), null, null, "");
        this.checkUnderEscaping(url, "space name");
    }

    @Test
    public void testPageEscaping() {
        String url = this.createUrl("Main", XMLEscapingValidator.getTestString(), null, "");
        this.checkUnderEscaping(url, "page name");
    }

    @Test
    public void testParameterEscaping() {
        Assume.assumeTrue((!this.userInput.isEmpty() ? 1 : 0) != 0);
        ArrayList<EscapingError> errors = new ArrayList<EscapingError>();
        for (String parameter : this.userInput) {
            String url = this.createUrl("Main", null, parameter, XMLEscapingValidator.getTestString());
            List<ValidationError> val_errors = this.getUnderEscapingErrors(url);
            if (val_errors.isEmpty()) continue;
            errors.add(new EscapingError("* Parameter: \"" + parameter + "\"", this.name, url, val_errors));
        }
        if (!errors.isEmpty()) {
            throw new EscapingError("Escaping test failed.", errors);
        }
    }

    protected String createUrl(String space, String page, String parameter, String value) {
        String template = this.name.replaceAll("^.+/", "");
        String skin = "default";
        if (this.name.startsWith("skins")) {
            skin = this.name.replaceFirst("^\\w+/", "").replaceAll("/.+$", "");
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("skin", skin);
        if ("xpart".equals(parameter)) {
            parameters.put("xpage", template).replaceAll("\\.\\w+$", "");
        } else {
            parameters.put("xpage", "xpart");
            parameters.put("vm", template);
        }
        if (parameter != null) {
            parameters.put(parameter, value);
        }
        return TemplateTest.createUrl(null, space, page, parameters);
    }
}

