/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.escaping.framework;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Assume;
import org.xwiki.test.escaping.framework.AbstractEscapingTest;
import org.xwiki.test.escaping.framework.XMLEscapingValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManualTest
extends AbstractEscapingTest {
    private List<String> toDeleteURLs = new LinkedList<String>();

    public AbstractManualTest() {
        super(Pattern.compile(".*"));
    }

    @Override
    protected Set<String> parse(Reader reader) {
        HashSet<String> set = new HashSet<String>();
        set.add("unused");
        return set;
    }

    @Override
    protected boolean isExcludedFile(String fileName) {
        return false;
    }

    @Override
    protected boolean isOutputProducingFile(String fileName) {
        return true;
    }

    protected void skipIfIgnored(String testedFileName) {
        Assume.assumeTrue((boolean)this.initialize(testedFileName, null));
    }

    protected void checkForErrorTrace(String url) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(AbstractEscapingTest.getUrlContent(url)));
        while ((line = reader.readLine()) != null) {
            Assert.assertFalse((String)"The page contains a error trace", (boolean)line.matches("^.*<pre\\s+class=\"xwikierror\">.*$"));
        }
    }

    protected void createPage(String space, String page, String title, String content) {
        String url = AbstractManualTest.createUrl("save", space, page, AbstractManualTest.params(AbstractManualTest.kv("title", title), AbstractManualTest.kv("content", content), AbstractManualTest.kv("action_save", "Save+%26+View")));
        AbstractEscapingTest.getUrlContent(url);
        this.deleteAfterwards(space, page);
    }

    protected void deleteAfterwards(String space, String page) {
        this.toDeleteURLs.add(AbstractManualTest.createUrl("delete", space, page, AbstractManualTest.params(new String[][]{AbstractManualTest.kv("confirm", "1")})));
    }

    protected static Map<String, String> params(String[] ... keysAndValues) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String[] kv : keysAndValues) {
            if (kv == null || kv.length <= 0 || kv[0] == null) continue;
            String key = kv[0];
            String value = "";
            if (kv.length > 1 && kv[1] != null) {
                value = kv[1];
            }
            params.put(key, value);
        }
        return params;
    }

    protected static String[] kv(String key, String value) {
        return new String[]{key, value};
    }

    protected static String[] test(String key) {
        return AbstractManualTest.kv(key, XMLEscapingValidator.getTestString());
    }

    protected static String[] template(String templateName) {
        return AbstractManualTest.kv("xpage", templateName);
    }

    @After
    public void tearDown() {
        for (String url : this.toDeleteURLs) {
            AbstractEscapingTest.getUrlContent(url);
        }
    }
}

