/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.escaping.framework;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.InvalidRedirectLocationException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.xwiki.test.escaping.framework.EscapingError;
import org.xwiki.test.escaping.framework.SingleXWikiExecutor;
import org.xwiki.test.escaping.framework.XMLEscapingValidator;
import org.xwiki.test.escaping.suite.FileTest;
import org.xwiki.validator.ValidationError;

public abstract class AbstractEscapingTest
implements FileTest {
    private static final String URL_START = "http://127.0.0.1:8080/xwiki/bin/";
    private static final String LANGUAGE = "language";
    private static final String SECRET_TOKEN = "form_token";
    private static HttpClient client;
    private static boolean loggedIn;
    private static String[] secretTokens;
    protected String name;
    protected Set<String> userInput;
    protected boolean shouldProduceOutput = true;
    private Pattern namePattern;

    protected AbstractEscapingTest(Pattern fileNameMatcher) {
        this.namePattern = fileNameMatcher;
    }

    @BeforeClass
    public static void startExecutor() throws Exception {
        SingleXWikiExecutor.getExecutor().start();
    }

    @AfterClass
    public static void stopExecutor() throws Exception {
        SingleXWikiExecutor.getExecutor().stop();
    }

    protected static void setMultiLanguageMode(boolean enabled) {
        String url = "http://127.0.0.1:8080/xwiki/bin/save/XWiki/XWikiPreferences?";
        url = url + "form_token=" + AbstractEscapingTest.getSecretToken();
        url = url + "&XWiki.XWikiPreferences_0_languages=&XWiki.XWikiPreferences_0_multilingual=";
        AbstractEscapingTest.getUrlContent(url + (enabled ? 1 : 0));
        String langUrl = "http://127.0.0.1:8080/xwiki/bin/view/Main/?language=en";
        AbstractEscapingTest.getUrlContent(langUrl);
    }

    @Override
    public boolean initialize(String name, Reader reader) {
        this.name = name;
        if (!this.fileNameMatches(name) || !this.patternMatches(name) || this.isExcludedFile(name)) {
            return false;
        }
        this.shouldProduceOutput = this.isOutputProducingFile(name);
        this.userInput = this.parse(reader);
        return true;
    }

    protected boolean fileNameMatches(String fileName) {
        return this.namePattern != null && this.namePattern.matcher(fileName).matches();
    }

    protected boolean patternMatches(String fileName) {
        String pattern = System.getProperty("pattern", "");
        if (pattern == null || pattern.equals("")) {
            return true;
        }
        return Pattern.matches(".*" + pattern + ".*", fileName);
    }

    protected abstract boolean isExcludedFile(String var1);

    protected abstract boolean isOutputProducingFile(String var1);

    protected abstract Set<String> parse(Reader var1);

    protected static boolean isLoggedIn() {
        return loggedIn;
    }

    protected static void setLoggedIn(boolean value) {
        loggedIn = value;
    }

    protected static InputStream getUrlContent(String url) {
        GetMethod get = new GetMethod(url);
        get.setFollowRedirects(true);
        if (AbstractEscapingTest.isLoggedIn()) {
            get.setDoAuthentication(true);
            get.addRequestHeader("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])"Admin:admin".getBytes())));
        }
        try {
            int statusCode = AbstractEscapingTest.getClient().executeMethod((HttpMethod)get);
            switch (statusCode) {
                case 200: {
                    break;
                }
                case 401: {
                    System.out.println("WARNING, Ignoring status 401 (unauthorized) for URL: " + url);
                    break;
                }
                case 409: {
                    System.out.println("WARNING, Ignoring status 409 (conflict) for URL: " + url);
                    break;
                }
                case 404: {
                    break;
                }
                default: {
                    throw new RuntimeException("HTTP GET request returned status " + statusCode + " (" + get.getStatusText() + ") for URL: " + url);
                }
            }
            String str = get.getResponseBodyAsString();
            if (str == null) {
                InputStream inputStream = null;
                return inputStream;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(str.getBytes("utf-8"));
            return byteArrayInputStream;
        }
        catch (IOException exception) {
            throw new RuntimeException("Error retrieving URL: " + url, exception);
        }
        finally {
            get.releaseConnection();
        }
    }

    protected static String escapeUrl(String str) {
        try {
            return URLEncoder.encode(str == null ? "" : str, "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException("Should not happen: ", exception);
        }
    }

    protected static HttpClient getClient() {
        if (client == null) {
            HttpClient adminClient = new HttpClient();
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials("Admin", "admin");
            adminClient.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
            HttpClientParams clientParams = new HttpClientParams();
            clientParams.setSoTimeout(20000);
            clientParams.setBooleanParameter("http.protocol.allow-circular-redirects", true);
            adminClient.setParams(clientParams);
            HttpConnectionManagerParams connectionParams = new HttpConnectionManagerParams();
            connectionParams.setConnectionTimeout(30000);
            adminClient.getHttpConnectionManager().setParams(connectionParams);
            client = adminClient;
        }
        return client;
    }

    public String toString() {
        return this.name + (this.shouldProduceOutput ? " " : " (NO OUTPUT) ") + this.userInput;
    }

    protected List<ValidationError> getUnderEscapingErrors(String url) {
        System.out.println("Testing URL: " + url);
        InputStream content = null;
        try {
            content = AbstractEscapingTest.getUrlContent(url);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof InvalidRedirectLocationException) {
                System.out.println(e.getCause().getMessage());
                return Collections.emptyList();
            }
            throw e;
        }
        String where = "  Template: " + this.name + "\n  URL: " + url;
        Assert.assertNotNull((String)("Response is null\n" + where), (Object)content);
        XMLEscapingValidator validator = new XMLEscapingValidator();
        validator.setShouldBeEmpty(!this.shouldProduceOutput);
        validator.setDocument(content);
        try {
            return validator.validate();
        }
        catch (EscapingError error) {
            throw new RuntimeException(EscapingError.formatMessage(error.getMessage(), this.name, url, null));
        }
    }

    protected void checkUnderEscaping(String url, String description) {
        List<ValidationError> errors = this.getUnderEscapingErrors(url);
        if (!errors.isEmpty()) {
            throw new EscapingError("Escaping test for " + description + " failed.", this.name, url, errors);
        }
    }

    protected static String createUrl(String action, String space, String page, Map<String, String> parameters) {
        return AbstractEscapingTest.createUrl(action, space, page, parameters, true);
    }

    protected static String createUrl(String action, String space, String page, Map<String, String> parameters, boolean addLanguage) {
        String url = URL_START + AbstractEscapingTest.escapeUrl(action == null ? "view" : action) + "/";
        url = url + AbstractEscapingTest.escapeUrl(space == null ? "Main" : space) + "/";
        url = url + AbstractEscapingTest.escapeUrl(page == null ? "WebHome" : page);
        String delimiter = "?";
        if (parameters != null) {
            for (String parameter : parameters.keySet()) {
                if (parameter != null && !parameter.equals("")) {
                    String value = parameters.get(parameter);
                    url = url + delimiter + AbstractEscapingTest.escapeUrl(parameter) + "=" + AbstractEscapingTest.escapeUrl(value);
                }
                delimiter = "&";
            }
        }
        if (addLanguage && (parameters == null || !parameters.containsKey(LANGUAGE))) {
            url = url + delimiter + LANGUAGE + "=en";
        }
        if (!(action != null && action.equals("edit") || parameters != null && parameters.containsKey(SECRET_TOKEN))) {
            url = url + delimiter + SECRET_TOKEN + "=" + AbstractEscapingTest.getSecretToken();
        }
        return url;
    }

    protected static String getSecretToken() {
        int index;
        int n = index = AbstractEscapingTest.isLoggedIn() ? 1 : 0;
        if (secretTokens[index] == null) {
            AbstractEscapingTest.secretTokens[index] = AbstractEscapingTest.getSecretTokenFromPage();
        }
        return secretTokens[index];
    }

    private static String getSecretTokenFromPage() {
        Pattern pattern = Pattern.compile("<input[^>]+form_token[^>]+value=('|\")([^'\"]+)");
        try {
            String line;
            String url = AbstractEscapingTest.createUrl("edit", "Main", "WebHome", null);
            BufferedReader reader = new BufferedReader(new InputStreamReader(AbstractEscapingTest.getUrlContent(url)));
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find() || matcher.groupCount() != 2) continue;
                return matcher.group(2);
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        System.out.println("WARNING, Failed to cache anti-CSRF secret token, some tests might fail!");
        return "";
    }

    static {
        loggedIn = true;
        secretTokens = new String[2];
    }
}

