/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.escaping.framework;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.xwiki.validator.ValidationError;
import org.xwiki.validator.Validator;

public class XMLEscapingValidator
implements Validator {
    private static final String INPUT_STRING = "aaa\"bbb'ccc>ddd<eee";
    private static final String TEST_APOS = "bbb'ccc";
    private static final String TEST_QUOT = "aaa\"bbb";
    private static final String TEST_LT = "ddd<eee";
    private static final String TEST_GT = "ccc>ddd";
    private static final String TEST_JS_APOS = "bbb\\'ccc";
    private static final String TEST_JS_QUOT = "aaa\\\"bbb";
    private boolean shouldBeEmpty = false;
    private List<String> document = new ArrayList<String>();
    private List<ValidationError> errors = new ArrayList<ValidationError>();

    public static String getTestString() {
        return INPUT_STRING;
    }

    public void setDocument(InputStream document) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(document));
        this.document = new ArrayList<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.document.add(line);
            }
        }
        catch (IOException exception) {
            throw new RuntimeException("Could not read document: ", exception);
        }
        this.clear();
    }

    public List<ValidationError> validate() {
        this.clear();
        if (this.document.size() == 0 && !this.shouldBeEmpty) {
            this.errors.add(new ValidationError(ValidationError.Type.WARNING, 0, 0, "Unexpected empty response"));
        }
        if (this.document.size() > 0 && this.shouldBeEmpty) {
            this.errors.add(new ValidationError(ValidationError.Type.WARNING, 0, 0, "Unexpected non-empty content: \"" + this.getContent() + "\""));
        }
        int lineNr = 1;
        for (String line : this.document) {
            this.checkStringDelimiters(line, lineNr);
            this.checkTagDelimiter(line, lineNr, TEST_LT, "Unescaped < character");
            this.checkTagDelimiter(line, lineNr, TEST_GT, "Unescaped > character");
            int idx = line.indexOf("Error while parsing velocity page");
            if (idx >= 0) {
                this.errors.add(new ValidationError(ValidationError.Type.WARNING, lineNr, idx, "Parse error in the response. The template was not evaluated correctly."));
            }
            if ((idx = line.indexOf("org.xwiki.rendering.macro.MacroExecutionException")) >= 0) {
                this.errors.add(new ValidationError(ValidationError.Type.WARNING, lineNr, idx, "Macro execution exception in the response."));
            }
            if ((idx = line.indexOf("Wrapped Exception: unexpected char:")) >= 0) {
                this.errors.add(new ValidationError(ValidationError.Type.WARNING, lineNr, idx, "Possible SQL error trace."));
            }
            ++lineNr;
        }
        return this.errors;
    }

    private String getContent() {
        StringBuilder builder = new StringBuilder();
        for (String line : this.document) {
            builder.append(line).append('\n');
        }
        return builder.toString();
    }

    private void checkTagDelimiter(String line, int lineNr, String testMatch, String errorMessage) {
        int idx = 0;
        while ((idx = line.indexOf(testMatch, idx)) >= 0) {
            if (!this.isJavascriptEscaped(line, testMatch, idx)) {
                this.errors.add(new ValidationError(ValidationError.Type.ERROR, lineNr, idx, errorMessage));
            }
            ++idx;
        }
    }

    private void checkStringDelimiters(String line, int lineNr) {
        int expected_idx;
        int offset = INPUT_STRING.indexOf(TEST_APOS) - INPUT_STRING.indexOf(TEST_QUOT);
        int idx = 0;
        while ((idx = line.indexOf(TEST_APOS, idx)) >= 0) {
            expected_idx = idx - offset;
            if (expected_idx < 0 || line.indexOf(TEST_QUOT, expected_idx) != expected_idx) {
                this.errors.add(new ValidationError(ValidationError.Type.WARNING, lineNr, idx, "Unescaped ' character"));
            }
            ++idx;
        }
        idx = 0;
        while ((idx = line.indexOf(TEST_QUOT, idx)) >= 0) {
            expected_idx = idx + offset;
            if (expected_idx < 0 || line.indexOf(TEST_APOS, expected_idx) != expected_idx) {
                this.errors.add(new ValidationError(ValidationError.Type.WARNING, lineNr, idx, "Unescaped \" character"));
            }
            ++idx;
        }
    }

    private boolean isJavascriptEscaped(String line, String match, int index) {
        int offset = INPUT_STRING.indexOf(match);
        if (index < 0 || offset < 0) {
            return false;
        }
        int pos_apos = line.indexOf(TEST_JS_APOS, index - (offset += 2));
        int pos_quot = line.indexOf(TEST_JS_QUOT, index - offset);
        return pos_apos >= 0 && pos_apos < index && pos_quot >= 0 && pos_quot < index;
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public void clear() {
        this.errors = new ArrayList<ValidationError>();
    }

    public String getName() {
        return "XML ESCAPING";
    }

    public void setShouldBeEmpty(boolean value) {
        this.shouldBeEmpty = value;
    }
}

