/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.po.xe;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.index.test.po.SpaceIndexPage;
import org.xwiki.test.ui.po.BaseElement;
import org.xwiki.test.ui.po.ViewPage;
import org.xwiki.test.ui.po.editor.WYSIWYGEditPage;

public class SpacesPane
extends BaseElement {
    @FindBy(linkText="Create a new space")
    private WebElement spaceCreateFormToggleSwitch;
    @FindBy(id="spSpaceCreateTextInput")
    private WebElement spaceNameTextField;

    public WYSIWYGEditPage createSpace(String spaceName) {
        this.spaceCreateFormToggleSwitch.click();
        this.spaceNameTextField.clear();
        this.spaceNameTextField.sendKeys(new CharSequence[]{spaceName});
        this.spaceNameTextField.submit();
        return new WYSIWYGEditPage();
    }

    public SpaceIndexPage clickSpaceIndex(String spaceName) {
        String escapedSpaceName = SpacesPane.getUtil().escapeURL(spaceName);
        for (WebElement liElement : SpacesPane.getUtil().findElementsWithoutWaiting(this.getDriver(), By.xpath((String)"//li[contains(@class, 'xitem')]"))) {
            List elements = SpacesPane.getUtil().findElementsWithoutWaiting(this.getDriver(), liElement, By.xpath((String)(".//a[contains(@href, 'SpaceIndex?space=" + escapedSpaceName + "')]")));
            if (elements.isEmpty()) continue;
            this.executeJavascript("arguments[0].setAttribute('class', '')", new Object[]{liElement});
            ((WebElement)elements.get(0)).click();
            return new SpaceIndexPage();
        }
        throw new RuntimeException("Was unable to click on space index for [" + spaceName + "]");
    }

    public ViewPage clickSpaceHome(String spaceName) {
        this.getDriver().findElement(By.xpath((String)("//div[@class = 'spSpaceName']/a[. = '" + spaceName + "']"))).click();
        return new ViewPage();
    }
}

