/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.rest;

import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.xwiki.rest.model.jaxb.Comment;
import org.xwiki.rest.model.jaxb.Comments;
import org.xwiki.rest.model.jaxb.History;
import org.xwiki.rest.model.jaxb.HistorySummary;
import org.xwiki.rest.model.jaxb.LinkCollection;
import org.xwiki.rest.model.jaxb.Page;
import org.xwiki.rest.resources.comments.CommentsResource;
import org.xwiki.rest.resources.pages.PageHistoryResource;
import org.xwiki.test.rest.framework.AbstractHttpTest;

public class CommentsResourceTest
extends AbstractHttpTest {
    private final String SPACE_NAME = "Main";
    private final String PAGE_NAME = "WebHome";

    public void testRepresentation() throws Exception {
    }

    public void testPOSTComment() throws Exception {
        String commentsUri = this.getUriBuilder(CommentsResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString();
        GetMethod getMethod = this.executeGet(commentsUri);
        CommentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Comments comments = (Comments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        int numberOfComments = comments.getComments().size();
        Comment comment = this.objectFactory.createComment();
        comment.setText("Comment");
        PostMethod postMethod = this.executePostXml(commentsUri, comment, "Admin", "admin");
        CommentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (int)201, (int)postMethod.getStatusCode());
        getMethod = this.executeGet(commentsUri);
        CommentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        comments = (Comments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        CommentsResourceTest.assertEquals((int)(numberOfComments + 1), (int)comments.getComments().size());
    }

    public void testPOSTCommentWithTextPlain() throws Exception {
        String commentsUri = this.getUriBuilder(CommentsResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString();
        GetMethod getMethod = this.executeGet(commentsUri);
        CommentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Comments comments = (Comments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        int numberOfComments = comments.getComments().size();
        PostMethod postMethod = this.executePost(commentsUri, "Comment", "text/plain", "Admin", "admin");
        CommentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (int)201, (int)postMethod.getStatusCode());
        getMethod = this.executeGet(commentsUri);
        CommentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        comments = (Comments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        CommentsResourceTest.assertEquals((int)(numberOfComments + 1), (int)comments.getComments().size());
    }

    public void testGETComment() throws Exception {
        String commentsUri = this.getUriBuilder(CommentsResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString();
        GetMethod getMethod = this.executeGet(commentsUri);
        CommentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Comments comments = (Comments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        for (Comment comment : comments.getComments()) {
            this.checkLinks((LinkCollection)comment);
        }
    }

    public void testGETCommentsAtPreviousVersions() throws Exception {
        String pageHistoryUri = this.getUriBuilder(PageHistoryResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString();
        GetMethod getMethod = this.executeGet(pageHistoryUri);
        CommentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        History history = (History)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        for (HistorySummary historySummary : history.getHistorySummaries()) {
            getMethod = this.executeGet(this.getFirstLinkByRelation((LinkCollection)historySummary, "http://www.xwiki.org/rel/page").getHref());
            CommentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
            Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            if (this.getFirstLinkByRelation((LinkCollection)page, "http://www.xwiki.org/rel/comments") == null) continue;
            getMethod = this.executeGet(this.getFirstLinkByRelation((LinkCollection)page, "http://www.xwiki.org/rel/comments").getHref());
            CommentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        }
    }

    public void testPOSTCommentFormUrlEncoded() throws Exception {
        String commentsUri = this.getUriBuilder(CommentsResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString();
        GetMethod getMethod = this.executeGet(commentsUri);
        CommentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Comments comments = (Comments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        int numberOfComments = comments.getComments().size();
        NameValuePair[] nameValuePairs = new NameValuePair[]{new NameValuePair("text", "Comment")};
        PostMethod postMethod = this.executePostForm(commentsUri, nameValuePairs, "Admin", "admin");
        CommentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (int)201, (int)postMethod.getStatusCode());
        getMethod = this.executeGet(commentsUri);
        CommentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        comments = (Comments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        CommentsResourceTest.assertEquals((int)(numberOfComments + 1), (int)comments.getComments().size());
    }
}

