/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.rest;

import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.LinkCollection;
import org.xwiki.rest.model.jaxb.Object;
import org.xwiki.rest.model.jaxb.ObjectSummary;
import org.xwiki.rest.model.jaxb.Objects;
import org.xwiki.rest.model.jaxb.Page;
import org.xwiki.rest.model.jaxb.Property;
import org.xwiki.rest.resources.objects.ObjectAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectResource;
import org.xwiki.rest.resources.objects.ObjectsResource;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.test.rest.framework.AbstractHttpTest;

public class ObjectsResourceTest
extends AbstractHttpTest {
    protected void setUp() throws Exception {
        super.setUp();
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Link link = this.getFirstLinkByRelation((LinkCollection)page, "http://www.xwiki.org/rel/objects");
        if (link == null) {
            Object object = this.objectFactory.createObject();
            object.setClassName("XWiki.TagClass");
            PostMethod postMethod = this.executePostXml(this.getUriBuilder(ObjectsResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString(), object, "Admin", "admin");
            ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (int)201, (int)postMethod.getStatusCode());
        }
    }

    public void testRepresentation() throws Exception {
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Link link = this.getFirstLinkByRelation((LinkCollection)page, "http://www.xwiki.org/rel/objects");
        ObjectsResourceTest.assertNotNull((java.lang.Object)link);
        getMethod = this.executeGet(link.getHref());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Objects objects = (Objects)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        ObjectsResourceTest.assertFalse((boolean)objects.getObjectSummaries().isEmpty());
        for (ObjectSummary objectSummary : objects.getObjectSummaries()) {
            link = this.getFirstLinkByRelation((LinkCollection)objectSummary, "http://www.xwiki.org/rel/object");
            getMethod = this.executeGet(link.getHref());
            ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
            Object object = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            this.checkLinks((LinkCollection)objectSummary);
            for (Property property : object.getProperties()) {
                this.checkLinks((LinkCollection)property);
            }
        }
    }

    public void testGETNotExistingObject() throws Exception {
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", "NOTEXISTING", 0}).toString());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)404, (int)getMethod.getStatusCode());
    }

    public Property getProperty(Object object, String propertyName) {
        for (Property property : object.getProperties()) {
            if (!property.getName().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    public void testPOSTObject() throws Exception {
        String TAG_VALUE = "TAG";
        Property property = new Property();
        property.setName("tags");
        property.setValue("TAG");
        Object object = this.objectFactory.createObject();
        object.setClassName("XWiki.TagClass");
        object.getProperties().add(property);
        PostMethod postMethod = this.executePostXml(this.getUriBuilder(ObjectsResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString(), object, "Admin", "admin");
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (int)201, (int)postMethod.getStatusCode());
        object = (Object)this.unmarshaller.unmarshal(postMethod.getResponseBodyAsStream());
        ObjectsResourceTest.assertEquals((String)"TAG", (String)this.getProperty(object, "tags").getValue());
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", object.getClassName(), object.getNumber()}).toString());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        object = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        ObjectsResourceTest.assertEquals((String)"TAG", (String)this.getProperty(object, "tags").getValue());
    }

    public void testPOSTInvalidObject() throws Exception {
        String TAG_VALUE = "TAG";
        Property property = new Property();
        property.setName("tags");
        property.setValue("TAG");
        Object object = this.objectFactory.createObject();
        object.getProperties().add(property);
        PostMethod postMethod = this.executePostXml(this.getUriBuilder(ObjectsResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString(), object, "Admin", "admin");
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (int)400, (int)postMethod.getStatusCode());
    }

    public void testPOSTObjectNotAuthorized() throws Exception {
        String TAG_VALUE = "TAG";
        Property property = new Property();
        property.setName("tags");
        property.setValue("TAG");
        Object object = this.objectFactory.createObject();
        object.setClassName("XWiki.TagClass");
        object.getProperties().add(property);
        PostMethod postMethod = this.executePostXml(this.getUriBuilder(ObjectsResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString(), object);
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (int)401, (int)postMethod.getStatusCode());
    }

    public void testPUTObject() throws Exception {
        String TAG_VALUE = UUID.randomUUID().toString();
        Object objectToBePut = this.getObject("XWiki.TagClass");
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBePut.getClassName(), objectToBePut.getNumber()}).toString());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Object objectSummary = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        this.getProperty(objectSummary, "tags").setValue(TAG_VALUE);
        PutMethod putMethod = this.executePutXml(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBePut.getClassName(), objectToBePut.getNumber()}).toString(), objectSummary, "Admin", "admin");
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)202, (int)putMethod.getStatusCode());
        Object updatedObjectSummary = (Object)this.unmarshaller.unmarshal(putMethod.getResponseBodyAsStream());
        ObjectsResourceTest.assertEquals((String)TAG_VALUE, (String)this.getProperty(updatedObjectSummary, "tags").getValue());
        ObjectsResourceTest.assertEquals((String)objectSummary.getClassName(), (String)updatedObjectSummary.getClassName());
        ObjectsResourceTest.assertEquals((int)objectSummary.getNumber(), (int)updatedObjectSummary.getNumber());
    }

    public void testPUTObjectUnauthorized() throws Exception {
        String TAG_VALUE = UUID.randomUUID().toString();
        Object objectToBePut = this.getObject("XWiki.TagClass");
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBePut.getClassName(), objectToBePut.getNumber()}).toString());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Object object = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        String originalTagValue = this.getProperty(object, "tags").getValue();
        this.getProperty(object, "tags").setValue(TAG_VALUE);
        PutMethod putMethod = this.executePutXml(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBePut.getClassName(), objectToBePut.getNumber()}).toString(), object);
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)401, (int)putMethod.getStatusCode());
        getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBePut.getClassName(), objectToBePut.getNumber()}).toString());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        object = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        ObjectsResourceTest.assertEquals((String)originalTagValue, (String)this.getProperty(object, "tags").getValue());
    }

    public void testDELETEObject() throws Exception {
        Object objectToBeDeleted = this.getObject("XWiki.TagClass");
        DeleteMethod deleteMethod = this.executeDelete(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBeDeleted.getClassName(), objectToBeDeleted.getNumber()}).toString(), "Admin", "admin");
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)deleteMethod), (int)204, (int)deleteMethod.getStatusCode());
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBeDeleted.getClassName(), objectToBeDeleted.getNumber()}).toString());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)404, (int)getMethod.getStatusCode());
    }

    public void testDELETEObjectUnAuthorized() throws Exception {
        Object objectToBeDeleted = this.getObject("XWiki.TagClass");
        DeleteMethod deleteMethod = this.executeDelete(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBeDeleted.getClassName(), objectToBeDeleted.getNumber()}).toString());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)deleteMethod), (int)401, (int)deleteMethod.getStatusCode());
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBeDeleted.getClassName(), objectToBeDeleted.getNumber()}).toString());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
    }

    public void testPUTProperty() throws Exception {
        String TAG_VALUE = UUID.randomUUID().toString();
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Link link = this.getFirstLinkByRelation((LinkCollection)page, "http://www.xwiki.org/rel/objects");
        ObjectsResourceTest.assertNotNull((java.lang.Object)link);
        getMethod = this.executeGet(link.getHref());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Objects objects = (Objects)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        ObjectsResourceTest.assertFalse((boolean)objects.getObjectSummaries().isEmpty());
        Object currentObject = null;
        for (ObjectSummary objectSummary : objects.getObjectSummaries()) {
            if (!objectSummary.getClassName().equals("XWiki.TagClass")) continue;
            link = this.getFirstLinkByRelation((LinkCollection)objectSummary, "http://www.xwiki.org/rel/object");
            ObjectsResourceTest.assertNotNull((java.lang.Object)link);
            getMethod = this.executeGet(link.getHref());
            ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
            currentObject = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            break;
        }
        ObjectsResourceTest.assertNotNull(currentObject);
        Property tagsProperty = this.getProperty(currentObject, "tags");
        ObjectsResourceTest.assertNotNull((java.lang.Object)tagsProperty);
        Link tagsPropertyLink = this.getFirstLinkByRelation((LinkCollection)tagsProperty, "self");
        ObjectsResourceTest.assertNotNull((java.lang.Object)tagsPropertyLink);
        Property newTags = this.objectFactory.createProperty();
        newTags.setValue(TAG_VALUE);
        PutMethod putMethod = this.executePutXml(tagsPropertyLink.getHref(), newTags, "Admin", "admin");
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)202, (int)putMethod.getStatusCode());
        getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", currentObject.getClassName(), currentObject.getNumber()}).toString());
        ObjectsResourceTest.assertEquals((int)200, (int)getMethod.getStatusCode());
        currentObject = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        tagsProperty = this.getProperty(currentObject, "tags");
        ObjectsResourceTest.assertEquals((String)TAG_VALUE, (String)tagsProperty.getValue());
    }

    public void testPUTPropertyWithTextPlain() throws Exception {
        String TAG_VALUE = UUID.randomUUID().toString();
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Link link = this.getFirstLinkByRelation((LinkCollection)page, "http://www.xwiki.org/rel/objects");
        ObjectsResourceTest.assertNotNull((java.lang.Object)link);
        getMethod = this.executeGet(link.getHref());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Objects objects = (Objects)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        ObjectsResourceTest.assertFalse((boolean)objects.getObjectSummaries().isEmpty());
        Object currentObject = null;
        for (ObjectSummary objectSummary : objects.getObjectSummaries()) {
            if (!objectSummary.getClassName().equals("XWiki.TagClass")) continue;
            link = this.getFirstLinkByRelation((LinkCollection)objectSummary, "http://www.xwiki.org/rel/object");
            ObjectsResourceTest.assertNotNull((java.lang.Object)link);
            getMethod = this.executeGet(link.getHref());
            ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
            currentObject = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            break;
        }
        ObjectsResourceTest.assertNotNull(currentObject);
        Property tagsProperty = this.getProperty(currentObject, "tags");
        ObjectsResourceTest.assertNotNull((java.lang.Object)tagsProperty);
        Link tagsPropertyLink = this.getFirstLinkByRelation((LinkCollection)tagsProperty, "self");
        ObjectsResourceTest.assertNotNull((java.lang.Object)tagsPropertyLink);
        PutMethod putMethod = this.executePut(tagsPropertyLink.getHref(), TAG_VALUE, "text/plain", "Admin", "admin");
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)202, (int)putMethod.getStatusCode());
        getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", currentObject.getClassName(), currentObject.getNumber()}).toString());
        ObjectsResourceTest.assertEquals((int)200, (int)getMethod.getStatusCode());
        currentObject = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        tagsProperty = this.getProperty(currentObject, "tags");
        ObjectsResourceTest.assertEquals((String)TAG_VALUE, (String)tagsProperty.getValue());
    }

    private Object getObject(String className) throws Exception {
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectsResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Objects objects = (Objects)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        ObjectsResourceTest.assertFalse((boolean)objects.getObjectSummaries().isEmpty());
        for (ObjectSummary objectSummary : objects.getObjectSummaries()) {
            if (!objectSummary.getClassName().equals(className)) continue;
            Link link = this.getFirstLinkByRelation((LinkCollection)objectSummary, "http://www.xwiki.org/rel/object");
            ObjectsResourceTest.assertNotNull((java.lang.Object)link);
            getMethod = this.executeGet(link.getHref());
            ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
            Object object = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            return object;
        }
        Object object = this.objectFactory.createObject();
        object.setClassName(className);
        PostMethod postMethod = this.executePostXml(this.getUriBuilder(ObjectsResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString(), object, "Admin", "admin");
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (int)201, (int)postMethod.getStatusCode());
        object = (Object)this.unmarshaller.unmarshal(postMethod.getResponseBodyAsStream());
        return object;
    }

    public void testPUTObjectFormUrlEncoded() throws Exception {
        String TAG_VALUE = UUID.randomUUID().toString();
        Object objectToBePut = this.getObject("XWiki.TagClass");
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBePut.getClassName(), objectToBePut.getNumber()}).toString());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Object object = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        NameValuePair[] nameValuePairs = new NameValuePair[]{new NameValuePair("property#tags", TAG_VALUE)};
        PostMethod postMethod = this.executePostForm(String.format("%s?method=PUT", this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBePut.getClassName(), objectToBePut.getNumber()}).toString()), nameValuePairs, "Admin", "admin");
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (int)202, (int)postMethod.getStatusCode());
        Object updatedObjectSummary = (Object)this.unmarshaller.unmarshal(postMethod.getResponseBodyAsStream());
        ObjectsResourceTest.assertEquals((String)TAG_VALUE, (String)this.getProperty(updatedObjectSummary, "tags").getValue());
        ObjectsResourceTest.assertEquals((String)object.getClassName(), (String)updatedObjectSummary.getClassName());
        ObjectsResourceTest.assertEquals((int)object.getNumber(), (int)updatedObjectSummary.getNumber());
    }

    public void testPOSTObjectFormUrlEncoded() throws Exception {
        String TAG_VALUE = "TAG";
        NameValuePair[] nameValuePairs = new NameValuePair[]{new NameValuePair("className", "XWiki.TagClass"), new NameValuePair("property#tags", "TAG")};
        PostMethod postMethod = this.executePostForm(this.getUriBuilder(ObjectsResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString(), nameValuePairs, "Admin", "admin");
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (int)201, (int)postMethod.getStatusCode());
        Object object = (Object)this.unmarshaller.unmarshal(postMethod.getResponseBodyAsStream());
        ObjectsResourceTest.assertEquals((String)"TAG", (String)this.getProperty(object, "tags").getValue());
        GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", object.getClassName(), object.getNumber()}).toString());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        object = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        ObjectsResourceTest.assertEquals((String)"TAG", (String)this.getProperty(object, "tags").getValue());
    }

    public void testPUTPropertyFormUrlEncoded() throws Exception {
        String TAG_VALUE = UUID.randomUUID().toString();
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Link link = this.getFirstLinkByRelation((LinkCollection)page, "http://www.xwiki.org/rel/objects");
        ObjectsResourceTest.assertNotNull((java.lang.Object)link);
        getMethod = this.executeGet(link.getHref());
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Objects objects = (Objects)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        ObjectsResourceTest.assertFalse((boolean)objects.getObjectSummaries().isEmpty());
        Object currentObject = null;
        for (ObjectSummary objectSummary : objects.getObjectSummaries()) {
            if (!objectSummary.getClassName().equals("XWiki.TagClass")) continue;
            link = this.getFirstLinkByRelation((LinkCollection)objectSummary, "http://www.xwiki.org/rel/object");
            ObjectsResourceTest.assertNotNull((java.lang.Object)link);
            getMethod = this.executeGet(link.getHref());
            ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
            currentObject = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            break;
        }
        ObjectsResourceTest.assertNotNull(currentObject);
        Property tagsProperty = this.getProperty(currentObject, "tags");
        ObjectsResourceTest.assertNotNull((java.lang.Object)tagsProperty);
        Link tagsPropertyLink = this.getFirstLinkByRelation((LinkCollection)tagsProperty, "self");
        ObjectsResourceTest.assertNotNull((java.lang.Object)tagsPropertyLink);
        NameValuePair[] nameValuePairs = new NameValuePair[]{new NameValuePair("property#tags", TAG_VALUE)};
        PostMethod postMethod = this.executePostForm(String.format("%s?method=PUT", tagsPropertyLink.getHref()), nameValuePairs, "Admin", "admin");
        ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (int)202, (int)postMethod.getStatusCode());
        getMethod = this.executeGet(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", currentObject.getClassName(), currentObject.getNumber()}).toString());
        ObjectsResourceTest.assertEquals((int)200, (int)getMethod.getStatusCode());
        currentObject = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        tagsProperty = this.getProperty(currentObject, "tags");
        ObjectsResourceTest.assertEquals((String)TAG_VALUE, (String)tagsProperty.getValue());
    }

    public void testGETObjectAtPageVersion() throws Exception {
        Object objectToBePut = this.getObject("XWiki.TagClass");
        HashMap<String, String> versionToValueMap = new HashMap<String, String>();
        for (int i = 0; i < 5; ++i) {
            String value = String.format("Value%d", i);
            Property property = this.getProperty(objectToBePut, "tags");
            property.setValue(value);
            PutMethod putMethod = this.executePutXml(this.getUriBuilder(ObjectResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", objectToBePut.getClassName(), objectToBePut.getNumber()}).toString(), objectToBePut, "Admin", "admin");
            ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)202, (int)putMethod.getStatusCode());
            GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome"}).toString());
            ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
            Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            versionToValueMap.put(page.getVersion(), value);
        }
        for (String version : versionToValueMap.keySet()) {
            GetMethod getMethod = this.executeGet(this.getUriBuilder(ObjectAtPageVersionResource.class).build(new java.lang.Object[]{this.getWiki(), "Main", "WebHome", version, objectToBePut.getClassName(), objectToBePut.getNumber()}).toString());
            ObjectsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
            Object currentObject = (Object)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            Property property = this.getProperty(currentObject, "tags");
            ObjectsResourceTest.assertEquals((String)((String)versionToValueMap.get(version)), (String)property.getValue());
            this.checkLinks((LinkCollection)currentObject);
            for (Property p : currentObject.getProperties()) {
                this.checkLinks((LinkCollection)p);
            }
        }
    }
}

