/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.rest;

import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.jackrabbit.uuid.UUID;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.LinkCollection;
import org.xwiki.rest.model.jaxb.Page;
import org.xwiki.rest.model.jaxb.PageSummary;
import org.xwiki.rest.model.jaxb.Pages;
import org.xwiki.rest.model.jaxb.Tag;
import org.xwiki.rest.model.jaxb.Tags;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTagsResource;
import org.xwiki.rest.resources.tags.PagesForTagsResource;
import org.xwiki.rest.resources.tags.TagsResource;
import org.xwiki.test.rest.framework.AbstractHttpTest;

public class TagsResourceTest
extends AbstractHttpTest {
    private void createPageIfDoesntExist(String spaceName, String pageName, String content) throws Exception {
        String uri = this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), spaceName, pageName}).toString();
        GetMethod getMethod = this.executeGet(uri);
        if (getMethod.getStatusCode() == 404) {
            Page page = this.objectFactory.createPage();
            page.setContent(content);
            PutMethod putMethod = this.executePutXml(uri, page, "Admin", "admin");
            TagsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)201, (int)putMethod.getStatusCode());
            getMethod = this.executeGet(uri);
            TagsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        }
    }

    public void testRepresentation() throws Exception {
        String tagName = UUID.randomUUID().toString();
        this.createPageIfDoesntExist("Test", "Test", "Test");
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString());
        TagsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Tags tags = this.objectFactory.createTags();
        Tag tag = this.objectFactory.createTag();
        tag.setName(tagName);
        tags.getTags().add(tag);
        PutMethod putMethod = this.executePutXml(this.getUriBuilder(PageTagsResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString(), tags, "Admin", "admin");
        TagsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)202, (int)putMethod.getStatusCode());
        getMethod = this.executeGet(this.getUriBuilder(PageTagsResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString());
        TagsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        tags = (Tags)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        boolean found = false;
        for (Tag t : tags.getTags()) {
            if (!tagName.equals(t.getName())) continue;
            found = true;
            break;
        }
        TagsResourceTest.assertTrue((boolean)found);
        getMethod = this.executeGet(this.getUriBuilder(TagsResource.class).build(new Object[]{this.getWiki()}).toString());
        TagsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        tags = (Tags)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        found = false;
        for (Tag t : tags.getTags()) {
            if (!tagName.equals(t.getName())) continue;
            found = true;
            break;
        }
        TagsResourceTest.assertTrue((boolean)found);
        getMethod = this.executeGet(this.getUriBuilder(PagesForTagsResource.class).build(new Object[]{this.getWiki(), tagName}).toString());
        TagsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Pages pages = (Pages)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        found = false;
        for (PageSummary pageSummary : pages.getPageSummaries()) {
            if (!pageSummary.getFullName().equals(String.format("%s.%s", "Test", "Test"))) continue;
            found = true;
        }
        TagsResourceTest.assertTrue((boolean)found);
        getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString());
        TagsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Link tagsLink = this.getFirstLinkByRelation((LinkCollection)page, "http://www.xwiki.org/rel/tags");
        TagsResourceTest.assertNotNull((Object)tagsLink);
    }

    public void testPUTTagsWithTextPlain() throws Exception {
        this.createPageIfDoesntExist("Test", "Test", "Test");
        String tagName = UUID.randomUUID().toString();
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString());
        TagsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        PutMethod putMethod = this.executePut(this.getUriBuilder(PageTagsResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString(), tagName, "text/plain", "Admin", "admin");
        TagsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)202, (int)putMethod.getStatusCode());
        getMethod = this.executeGet(this.getUriBuilder(PageTagsResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString());
        TagsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Tags tags = (Tags)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        boolean found = false;
        for (Tag t : tags.getTags()) {
            if (!tagName.equals(t.getName())) continue;
            found = true;
            break;
        }
        TagsResourceTest.assertTrue((boolean)found);
    }

    public void testPUTTagsFormUrlEncoded() throws Exception {
        this.createPageIfDoesntExist("Test", "Test", "Test");
        String tagName = UUID.randomUUID().toString();
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString());
        TagsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        NameValuePair[] nameValuePairs = new NameValuePair[]{new NameValuePair("tags", tagName)};
        PostMethod postMethod = this.executePostForm(String.format("%s?method=PUT", this.getUriBuilder(PageTagsResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString()), nameValuePairs, "Admin", "admin");
        TagsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (int)202, (int)postMethod.getStatusCode());
        getMethod = this.executeGet(this.getUriBuilder(PageTagsResource.class).build(new Object[]{this.getWiki(), "Test", "Test"}).toString());
        TagsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Tags tags = (Tags)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        boolean found = false;
        for (Tag t : tags.getTags()) {
            if (!tagName.equals(t.getName())) continue;
            found = true;
            break;
        }
        TagsResourceTest.assertTrue((boolean)found);
    }
}

