/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.rest;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.xwiki.rest.model.jaxb.Attachment;
import org.xwiki.rest.model.jaxb.Attachments;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.LinkCollection;
import org.xwiki.rest.model.jaxb.PageSummary;
import org.xwiki.rest.model.jaxb.Pages;
import org.xwiki.rest.model.jaxb.SearchResult;
import org.xwiki.rest.model.jaxb.SearchResults;
import org.xwiki.rest.model.jaxb.Wiki;
import org.xwiki.rest.model.jaxb.Wikis;
import org.xwiki.rest.resources.wikis.WikiAttachmentsResource;
import org.xwiki.rest.resources.wikis.WikiPagesResource;
import org.xwiki.rest.resources.wikis.WikiSearchResource;
import org.xwiki.rest.resources.wikis.WikisResource;
import org.xwiki.test.rest.framework.AbstractHttpTest;

public class WikisResourceTest
extends AbstractHttpTest {
    public void testRepresentation() throws Exception {
        GetMethod getMethod = this.executeGet(this.getFullUri(WikisResource.class));
        WikisResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Wikis wikis = (Wikis)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        WikisResourceTest.assertTrue((String)this.getHttpMethodInfo((HttpMethod)getMethod), (wikis.getWikis().size() > 0 ? 1 : 0) != 0);
        for (Wiki wiki : wikis.getWikis()) {
            Link link = this.getFirstLinkByRelation((LinkCollection)wiki, "http://www.xwiki.org/rel/spaces");
            WikisResourceTest.assertNotNull((Object)link);
            link = this.getFirstLinkByRelation((LinkCollection)wiki, "http://www.xwiki.org/rel/classes");
            WikisResourceTest.assertNotNull((Object)link);
            link = this.getFirstLinkByRelation((LinkCollection)wiki, "http://www.xwiki.org/rel/modifications");
            WikisResourceTest.assertNotNull((Object)link);
            link = this.getFirstLinkByRelation((LinkCollection)wiki, "http://www.xwiki.org/rel/search");
            WikisResourceTest.assertNotNull((Object)link);
            this.checkLinks((LinkCollection)wiki);
        }
    }

    public void testSearch() throws Exception {
        GetMethod getMethod = this.executeGet(String.format("%s?q=easy-to-edit", this.getUriBuilder(WikiSearchResource.class).build(new Object[]{this.getWiki()})));
        WikisResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        SearchResults searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        int resultSize = searchResults.getSearchResults().size();
        WikisResourceTest.assertTrue((String)String.format("Found %s results", resultSize), (resultSize >= 1 ? 1 : 0) != 0);
        for (SearchResult searchResult : searchResults.getSearchResults()) {
            this.checkLinks((LinkCollection)searchResult);
        }
        getMethod = this.executeGet(String.format("%s?q=WebHome&scope=name", this.getUriBuilder(WikiSearchResource.class).build(new Object[]{this.getWiki()})));
        WikisResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        resultSize = searchResults.getSearchResults().size();
        WikisResourceTest.assertTrue((String)String.format("Found %s results", resultSize), (resultSize >= 3 ? 1 : 0) != 0);
        for (SearchResult searchResult : searchResults.getSearchResults()) {
            this.checkLinks((LinkCollection)searchResult);
        }
        getMethod = this.executeGet(String.format("%s?q=msg&scope=title", this.getUriBuilder(WikiSearchResource.class).build(new Object[]{this.getWiki()})));
        WikisResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        resultSize = searchResults.getSearchResults().size();
        WikisResourceTest.assertTrue((String)String.format("Found %s results", resultSize), (searchResults.getSearchResults().size() >= 1 ? 1 : 0) != 0);
        for (SearchResult searchResult : searchResults.getSearchResults()) {
            this.checkLinks((LinkCollection)searchResult);
        }
        getMethod = this.executeGet(String.format("%s?q=db&scope=spaces", this.getUriBuilder(WikiSearchResource.class).build(new Object[]{this.getWiki()})));
        WikisResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        resultSize = searchResults.getSearchResults().size();
        WikisResourceTest.assertTrue((String)String.format("Found %s results", resultSize), (resultSize >= 1 ? 1 : 0) != 0);
        for (SearchResult searchResult : searchResults.getSearchResults()) {
            this.checkLinks((LinkCollection)searchResult);
        }
    }

    public void testPages() throws Exception {
        GetMethod getMethod = this.executeGet(String.format("%s", this.getUriBuilder(WikiPagesResource.class).build(new Object[]{this.getWiki()})));
        WikisResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Pages pages = (Pages)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        WikisResourceTest.assertTrue((pages.getPageSummaries().size() > 0 ? 1 : 0) != 0);
        for (PageSummary pageSummary : pages.getPageSummaries()) {
            this.checkLinks((LinkCollection)pageSummary);
        }
        getMethod = this.executeGet(String.format("%s?name=WebHome", this.getUriBuilder(WikiPagesResource.class).build(new Object[]{this.getWiki()})));
        WikisResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        pages = (Pages)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        List pageSummaries = pages.getPageSummaries();
        WikisResourceTest.assertTrue((pageSummaries.size() > 0 ? 1 : 0) != 0);
        int foundCounter = 0;
        List<String> expectedWebHomes = Arrays.asList("Main.WebHome", "Sandbox.WebHome", "XWiki.WebHome");
        for (PageSummary pageSummary : pages.getPageSummaries()) {
            if (expectedWebHomes.contains(pageSummary.getFullName())) {
                ++foundCounter;
            }
            WikisResourceTest.assertTrue((boolean)pageSummary.getFullName().endsWith(".WebHome"));
            this.checkLinks((LinkCollection)pageSummary);
        }
        WikisResourceTest.assertTrue((String)"Some WebHome pages were not found!", (foundCounter >= expectedWebHomes.size() ? 1 : 0) != 0);
        getMethod = this.executeGet(String.format("%s?name=WebHome&space=s", this.getUriBuilder(WikiPagesResource.class).build(new Object[]{this.getWiki()})));
        WikisResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        pages = (Pages)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        pageSummaries = pages.getPageSummaries();
        WikisResourceTest.assertTrue((pageSummaries.size() > 0 ? 1 : 0) != 0);
        foundCounter = 0;
        expectedWebHomes = Arrays.asList("ColorThemes.WebHome", "Stats.WebHome", "Sandbox.WebHome", "Panels.WebHome", "Scheduler.WebHome", "Sandbox.WebHome");
        for (PageSummary pageSummary : pages.getPageSummaries()) {
            if (expectedWebHomes.contains(pageSummary.getFullName())) {
                ++foundCounter;
            }
            WikisResourceTest.assertTrue((boolean)pageSummary.getFullName().endsWith(".WebHome"));
            this.checkLinks((LinkCollection)pageSummary);
        }
        WikisResourceTest.assertTrue((String)"Some WebHome pages were not found!", (foundCounter >= expectedWebHomes.size() ? 1 : 0) != 0);
    }

    public void testAttachments() throws Exception {
        GetMethod getMethod = this.executeGet(String.format("%s", this.getUriBuilder(WikiAttachmentsResource.class).build(new Object[]{this.getWiki()})));
        WikisResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Attachments attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        WikisResourceTest.assertTrue((attachments.getAttachments().size() > 0 ? 1 : 0) != 0);
        for (Attachment attachment : attachments.getAttachments()) {
            this.checkLinks((LinkCollection)attachment);
        }
        getMethod = this.executeGet(String.format("%s?name=Logo", this.getUriBuilder(WikiAttachmentsResource.class).build(new Object[]{this.getWiki()})));
        WikisResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        WikisResourceTest.assertEquals((String)this.getAttachmentsInfo(attachments), (int)1, (int)attachments.getAttachments().size());
        for (Attachment attachment : attachments.getAttachments()) {
            this.checkLinks((LinkCollection)attachment);
        }
        getMethod = this.executeGet(String.format("%s?space=sandbox", this.getUriBuilder(WikiAttachmentsResource.class).build(new Object[]{this.getWiki()})));
        WikisResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        WikisResourceTest.assertEquals((String)this.getAttachmentsInfo(attachments), (int)1, (int)attachments.getAttachments().size());
        for (Attachment attachment : attachments.getAttachments()) {
            this.checkLinks((LinkCollection)attachment);
        }
        getMethod = this.executeGet(String.format("%s?name=Logo&space=Sandbox", this.getUriBuilder(WikiAttachmentsResource.class).build(new Object[]{this.getWiki()})));
        WikisResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        WikisResourceTest.assertEquals((String)this.getAttachmentsInfo(attachments), (int)1, (int)attachments.getAttachments().size());
        for (Attachment attachment : attachments.getAttachments()) {
            this.checkLinks((LinkCollection)attachment);
        }
    }
}

