/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.rest.framework;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.restlet.data.MediaType;
import org.xwiki.rest.model.jaxb.Attachment;
import org.xwiki.rest.model.jaxb.Attachments;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.LinkCollection;
import org.xwiki.rest.model.jaxb.ObjectFactory;
import org.xwiki.rest.model.jaxb.Page;
import org.xwiki.rest.model.jaxb.PageSummary;
import org.xwiki.rest.model.jaxb.Pages;
import org.xwiki.rest.model.jaxb.Wiki;
import org.xwiki.rest.model.jaxb.Wikis;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.wikis.WikisResource;
import org.xwiki.test.AbstractXWikiComponentTestCase;
import org.xwiki.test.XWikiExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpTest
extends AbstractXWikiComponentTestCase {
    protected Random random;
    protected Marshaller marshaller;
    protected Unmarshaller unmarshaller;
    protected ObjectFactory objectFactory;
    protected int port = Integer.valueOf(XWikiExecutor.DEFAULT_PORT);

    protected void setUp() throws Exception {
        super.setUp();
        this.random = new Random();
        JAXBContext context = JAXBContext.newInstance((String)"org.xwiki.rest.model.jaxb");
        this.marshaller = context.createMarshaller();
        this.unmarshaller = context.createUnmarshaller();
        this.objectFactory = new ObjectFactory();
    }

    public void setPort(int port) {
        this.port = port;
    }

    protected Link getFirstLinkByRelation(LinkCollection linkCollection, String relation) {
        if (linkCollection.getLinks() == null) {
            return null;
        }
        for (Link link : linkCollection.getLinks()) {
            if (!link.getRel().equals(relation)) continue;
            return link;
        }
        return null;
    }

    protected List<Link> getLinksByRelation(LinkCollection linkCollection, String relation) {
        ArrayList<Link> result = new ArrayList<Link>();
        if (linkCollection.getLinks() == null) {
            return result;
        }
        for (Link link : linkCollection.getLinks()) {
            if (!link.getRel().equals(relation)) continue;
            result.add(link);
        }
        return result;
    }

    protected String getBaseURL() {
        return "http://localhost:" + this.port + "/xwiki/rest";
    }

    protected String getFullUri(Class<?> resourceClass) {
        return String.format("%s%s", this.getBaseURL(), UriBuilder.fromResource(resourceClass).build(new Object[0]));
    }

    public abstract void testRepresentation() throws Exception;

    protected GetMethod executeGet(String uri) throws Exception {
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = new GetMethod(uri);
        getMethod.addRequestHeader("Accept", MediaType.APPLICATION_XML.toString());
        httpClient.executeMethod((HttpMethod)getMethod);
        return getMethod;
    }

    protected GetMethod executeGet(String uri, String userName, String password) throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
        httpClient.getParams().setAuthenticationPreemptive(true);
        GetMethod getMethod = new GetMethod(uri);
        getMethod.addRequestHeader("Accept", MediaType.APPLICATION_XML.toString());
        httpClient.executeMethod((HttpMethod)getMethod);
        return getMethod;
    }

    protected PostMethod executePostXml(String uri, Object object) throws Exception {
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(uri);
        postMethod.addRequestHeader("Accept", MediaType.APPLICATION_XML.toString());
        StringWriter writer = new StringWriter();
        this.marshaller.marshal(object, (Writer)writer);
        StringRequestEntity entity = new StringRequestEntity(writer.toString(), MediaType.APPLICATION_XML.toString(), "UTF-8");
        postMethod.setRequestEntity((RequestEntity)entity);
        httpClient.executeMethod((HttpMethod)postMethod);
        return postMethod;
    }

    protected PostMethod executePostXml(String uri, Object object, String userName, String password) throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
        httpClient.getParams().setAuthenticationPreemptive(true);
        PostMethod postMethod = new PostMethod(uri);
        postMethod.addRequestHeader("Accept", MediaType.APPLICATION_XML.toString());
        StringWriter writer = new StringWriter();
        this.marshaller.marshal(object, (Writer)writer);
        StringRequestEntity entity = new StringRequestEntity(writer.toString(), MediaType.APPLICATION_XML.toString(), "UTF-8");
        postMethod.setRequestEntity((RequestEntity)entity);
        httpClient.executeMethod((HttpMethod)postMethod);
        return postMethod;
    }

    protected PostMethod executePost(String uri, String string, String mediaType, String userName, String password) throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
        httpClient.getParams().setAuthenticationPreemptive(true);
        PostMethod postMethod = new PostMethod(uri);
        postMethod.addRequestHeader("Accept", MediaType.APPLICATION_XML.toString());
        StringRequestEntity entity = new StringRequestEntity(string, mediaType, "UTF-8");
        postMethod.setRequestEntity((RequestEntity)entity);
        httpClient.executeMethod((HttpMethod)postMethod);
        return postMethod;
    }

    protected PostMethod executePostForm(String uri, NameValuePair[] nameValuePairs, String userName, String password) throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
        httpClient.getParams().setAuthenticationPreemptive(true);
        PostMethod postMethod = new PostMethod(uri);
        postMethod.addRequestHeader("Accept", MediaType.APPLICATION_XML.toString());
        postMethod.addRequestHeader("Content-type", MediaType.APPLICATION_WWW_FORM.toString());
        postMethod.setRequestBody(nameValuePairs);
        httpClient.executeMethod((HttpMethod)postMethod);
        return postMethod;
    }

    protected PutMethod executePutXml(String uri, Object object) throws Exception {
        HttpClient httpClient = new HttpClient();
        PutMethod putMethod = new PutMethod(uri);
        putMethod.addRequestHeader("Accept", MediaType.APPLICATION_XML.toString());
        StringWriter writer = new StringWriter();
        this.marshaller.marshal(object, (Writer)writer);
        StringRequestEntity entity = new StringRequestEntity(writer.toString(), MediaType.APPLICATION_XML.toString(), "UTF-8");
        putMethod.setRequestEntity((RequestEntity)entity);
        httpClient.executeMethod((HttpMethod)putMethod);
        return putMethod;
    }

    protected PutMethod executePutXml(String uri, Object object, String userName, String password) throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
        httpClient.getParams().setAuthenticationPreemptive(true);
        PutMethod putMethod = new PutMethod(uri);
        putMethod.addRequestHeader("Accept", MediaType.APPLICATION_XML.toString());
        StringWriter writer = new StringWriter();
        this.marshaller.marshal(object, (Writer)writer);
        StringRequestEntity entity = new StringRequestEntity(writer.toString(), MediaType.APPLICATION_XML.toString(), "UTF-8");
        putMethod.setRequestEntity((RequestEntity)entity);
        httpClient.executeMethod((HttpMethod)putMethod);
        return putMethod;
    }

    protected PutMethod executePut(String uri, String string, String mediaType) throws Exception {
        HttpClient httpClient = new HttpClient();
        PutMethod putMethod = new PutMethod(uri);
        StringRequestEntity entity = new StringRequestEntity(string, mediaType, "UTF-8");
        putMethod.setRequestEntity((RequestEntity)entity);
        httpClient.executeMethod((HttpMethod)putMethod);
        return putMethod;
    }

    protected PutMethod executePut(String uri, String string, String mediaType, String userName, String password) throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
        httpClient.getParams().setAuthenticationPreemptive(true);
        PutMethod putMethod = new PutMethod(uri);
        StringRequestEntity entity = new StringRequestEntity(string, mediaType, "UTF-8");
        putMethod.setRequestEntity((RequestEntity)entity);
        httpClient.executeMethod((HttpMethod)putMethod);
        return putMethod;
    }

    protected DeleteMethod executeDelete(String uri) throws Exception {
        HttpClient httpClient = new HttpClient();
        DeleteMethod deleteMethod = new DeleteMethod(uri);
        httpClient.executeMethod((HttpMethod)deleteMethod);
        return deleteMethod;
    }

    protected DeleteMethod executeDelete(String uri, String userName, String password) throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
        httpClient.getParams().setAuthenticationPreemptive(true);
        DeleteMethod deleteMethod = new DeleteMethod(uri);
        httpClient.executeMethod((HttpMethod)deleteMethod);
        return deleteMethod;
    }

    protected String getWiki() throws Exception {
        GetMethod getMethod = this.executeGet(this.getFullUri(WikisResource.class));
        AbstractHttpTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Wikis wikis = (Wikis)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        AbstractHttpTest.assertTrue((wikis.getWikis().size() > 0 ? 1 : 0) != 0);
        return ((Wiki)wikis.getWikis().get(0)).getName();
    }

    protected void checkLinks(LinkCollection linkCollection) throws Exception {
        if (linkCollection.getLinks() != null) {
            for (Link link : linkCollection.getLinks()) {
                GetMethod getMethod = this.executeGet(link.getHref());
                if (getMethod.getStatusCode() == 401) continue;
                AbstractHttpTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
            }
        }
    }

    protected UriBuilder getUriBuilder(Class<?> resource) {
        return UriBuilder.fromUri((String)this.getBaseURL()).path(resource);
    }

    private Page getPage(String wikiName, String spaceName, String pageName) throws Exception {
        String uri = this.getUriBuilder(PageResource.class).build(new Object[]{wikiName, spaceName, pageName}).toString();
        GetMethod getMethod = this.executeGet(uri);
        return (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
    }

    protected String getPageContent(String wikiName, String spaceName, String pageName) throws Exception {
        Page page = this.getPage(wikiName, spaceName, pageName);
        return page.getContent();
    }

    protected int setPageContent(String wikiName, String spaceName, String pageName, String content) throws Exception {
        String uri = this.getUriBuilder(PageResource.class).build(new Object[]{wikiName, spaceName, pageName}).toString();
        PutMethod putMethod = this.executePut(uri, content, "text/plain", "Admin", "admin");
        int code = putMethod.getStatusCode();
        AbstractHttpTest.assertTrue((String)String.format("Failed to set page content, %s", this.getHttpMethodInfo((HttpMethod)putMethod)), (code == 202 || code == 201 ? 1 : 0) != 0);
        return code;
    }

    protected String getHttpMethodInfo(HttpMethod method) throws Exception {
        return String.format("\nName: %s\nURI: %s\nStatus code: %d\nStatus text: %s\nResponse:\n%s", method.getName(), method.getURI(), method.getStatusCode(), method.getStatusText(), method.getResponseBodyAsString());
    }

    protected String getAttachmentsInfo(Attachments attachments) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.format("Attachments: %d\n", attachments.getAttachments().size()));
        for (Attachment attachment : attachments.getAttachments()) {
            sb.append(String.format("* %s\n", attachment.getName()));
        }
        return sb.toString();
    }

    protected String getPagesInfo(Pages pages) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.format("Pages: %d\n", pages.getPageSummaries().size()));
        for (PageSummary pageSummary : pages.getPageSummaries()) {
            sb.append(String.format("* %s\n", pageSummary.getFullName()));
        }
        return sb.toString();
    }
}

