/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.rest;

import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.junit.Assert;
import org.junit.Test;
import org.xwiki.rest.model.jaxb.Comment;
import org.xwiki.rest.model.jaxb.Comments;
import org.xwiki.rest.model.jaxb.History;
import org.xwiki.rest.model.jaxb.HistorySummary;
import org.xwiki.rest.model.jaxb.LinkCollection;
import org.xwiki.rest.model.jaxb.Page;
import org.xwiki.rest.resources.comments.CommentsResource;
import org.xwiki.rest.resources.pages.PageHistoryResource;
import org.xwiki.test.rest.framework.AbstractHttpTest;
import org.xwiki.test.ui.TestUtils;

public class CommentsResourceTest
extends AbstractHttpTest {
    private final String SPACE_NAME = "Main";
    private final String PAGE_NAME = "WebHome";

    @Override
    @Test
    public void testRepresentation() throws Exception {
    }

    @Test
    public void testPOSTComment() throws Exception {
        String commentsUri = this.getUriBuilder(CommentsResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString();
        GetMethod getMethod = this.executeGet(commentsUri);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Comments comments = (Comments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        int numberOfComments = comments.getComments().size();
        Comment comment = this.objectFactory.createComment();
        comment.setText("Comment");
        PostMethod postMethod = this.executePostXml(commentsUri, comment, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (long)201L, (long)postMethod.getStatusCode());
        getMethod = this.executeGet(commentsUri);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        comments = (Comments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertEquals((long)(numberOfComments + 1), (long)comments.getComments().size());
    }

    @Test
    public void testPOSTCommentWithTextPlain() throws Exception {
        String commentsUri = this.getUriBuilder(CommentsResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString();
        GetMethod getMethod = this.executeGet(commentsUri);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Comments comments = (Comments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        int numberOfComments = comments.getComments().size();
        PostMethod postMethod = this.executePost(commentsUri, "Comment", "text/plain", TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (long)201L, (long)postMethod.getStatusCode());
        getMethod = this.executeGet(commentsUri);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        comments = (Comments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertEquals((long)(numberOfComments + 1), (long)comments.getComments().size());
    }

    @Test
    public void testGETComment() throws Exception {
        String commentsUri = this.getUriBuilder(CommentsResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString();
        GetMethod getMethod = this.executeGet(commentsUri);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Comments comments = (Comments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        for (Comment comment : comments.getComments()) {
            this.checkLinks((LinkCollection)comment);
        }
    }

    @Test
    public void testGETCommentsAtPreviousVersions() throws Exception {
        String pageHistoryUri = this.getUriBuilder(PageHistoryResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString();
        GetMethod getMethod = this.executeGet(pageHistoryUri);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        History history = (History)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        for (HistorySummary historySummary : history.getHistorySummaries()) {
            getMethod = this.executeGet(this.getFirstLinkByRelation((LinkCollection)historySummary, "http://www.xwiki.org/rel/page").getHref());
            Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
            Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            if (this.getFirstLinkByRelation((LinkCollection)page, "http://www.xwiki.org/rel/comments") == null) continue;
            getMethod = this.executeGet(this.getFirstLinkByRelation((LinkCollection)page, "http://www.xwiki.org/rel/comments").getHref());
            Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        }
    }

    @Test
    public void testPOSTCommentFormUrlEncoded() throws Exception {
        String commentsUri = this.getUriBuilder(CommentsResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString();
        GetMethod getMethod = this.executeGet(commentsUri);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Comments comments = (Comments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        int numberOfComments = comments.getComments().size();
        NameValuePair[] nameValuePairs = new NameValuePair[]{new NameValuePair("text", "Comment")};
        PostMethod postMethod = this.executePostForm(commentsUri, nameValuePairs, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (long)201L, (long)postMethod.getStatusCode());
        getMethod = this.executeGet(commentsUri);
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        comments = (Comments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertEquals((long)(numberOfComments + 1), (long)comments.getComments().size());
    }
}

