/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.rest;

import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.junit.Assert;
import org.junit.Test;
import org.xwiki.rest.model.jaxb.Attachment;
import org.xwiki.rest.model.jaxb.Attachments;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.LinkCollection;
import org.xwiki.rest.model.jaxb.SearchResult;
import org.xwiki.rest.model.jaxb.SearchResults;
import org.xwiki.rest.model.jaxb.Space;
import org.xwiki.rest.model.jaxb.Spaces;
import org.xwiki.rest.model.jaxb.Wiki;
import org.xwiki.rest.model.jaxb.Wikis;
import org.xwiki.rest.resources.spaces.SpaceAttachmentsResource;
import org.xwiki.rest.resources.spaces.SpaceSearchResource;
import org.xwiki.rest.resources.wikis.WikiSearchResource;
import org.xwiki.rest.resources.wikis.WikisResource;
import org.xwiki.test.rest.framework.AbstractHttpTest;

public class SpacesResourceTest
extends AbstractHttpTest {
    @Override
    @Test
    public void testRepresentation() throws Exception {
        GetMethod getMethod = this.executeGet(this.getFullUri(WikisResource.class));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Wikis wikis = (Wikis)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertTrue((wikis.getWikis().size() > 0 ? 1 : 0) != 0);
        Wiki wiki = (Wiki)wikis.getWikis().get(0);
        Link link = this.getFirstLinkByRelation((LinkCollection)wiki, "http://www.xwiki.org/rel/spaces");
        Assert.assertNotNull((Object)link);
        getMethod = this.executeGet(link.getHref());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Spaces spaces = (Spaces)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertTrue((spaces.getSpaces().size() > 0 ? 1 : 0) != 0);
        for (Space space : spaces.getSpaces()) {
            link = this.getFirstLinkByRelation((LinkCollection)space, "http://www.xwiki.org/rel/search");
            Assert.assertNotNull((Object)link);
            this.checkLinks((LinkCollection)space);
            Assert.assertFalse((boolean)space.getName().equals("Scheduler"));
        }
    }

    @Test
    public void testSearch() throws Exception {
        GetMethod getMethod = this.executeGet(String.format("%s?q=somethingthatcannotpossiblyexist", this.getUriBuilder(SpaceSearchResource.class).build(new Object[]{this.getWiki(), "Main"})));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        SearchResults searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertEquals((long)0L, (long)searchResults.getSearchResults().size());
        getMethod = this.executeGet(String.format("%s?q=sandbox", this.getUriBuilder(WikiSearchResource.class).build(new Object[]{this.getWiki(), "Sandbox"})));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        int resultSize = searchResults.getSearchResults().size();
        Assert.assertTrue((String)("Found " + resultSize + " result"), (resultSize >= 2 ? 1 : 0) != 0);
        for (SearchResult searchResult : searchResults.getSearchResults()) {
            this.checkLinks((LinkCollection)searchResult);
        }
    }

    @Test
    public void testAttachments() throws Exception {
        GetMethod getMethod = this.executeGet(String.format("%s", this.getUriBuilder(SpaceAttachmentsResource.class).build(new Object[]{this.getWiki(), "Sandbox"})));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Attachments attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertEquals((String)this.getAttachmentsInfo(attachments), (long)1L, (long)attachments.getAttachments().size());
        for (Attachment attachment : attachments.getAttachments()) {
            this.checkLinks((LinkCollection)attachment);
        }
    }
}

