/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.rest;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.junit.Assert;
import org.junit.Test;
import org.xwiki.rest.model.jaxb.Attachment;
import org.xwiki.rest.model.jaxb.Attachments;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.LinkCollection;
import org.xwiki.rest.model.jaxb.Page;
import org.xwiki.rest.model.jaxb.PageSummary;
import org.xwiki.rest.model.jaxb.Pages;
import org.xwiki.rest.model.jaxb.SearchResult;
import org.xwiki.rest.model.jaxb.SearchResults;
import org.xwiki.rest.model.jaxb.Wiki;
import org.xwiki.rest.model.jaxb.Wikis;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.wikis.WikiAttachmentsResource;
import org.xwiki.rest.resources.wikis.WikiPagesResource;
import org.xwiki.rest.resources.wikis.WikiResource;
import org.xwiki.rest.resources.wikis.WikiSearchQueryResource;
import org.xwiki.rest.resources.wikis.WikiSearchResource;
import org.xwiki.rest.resources.wikis.WikisResource;
import org.xwiki.rest.resources.wikis.WikisSearchQueryResource;
import org.xwiki.test.rest.framework.AbstractHttpTest;
import org.xwiki.test.ui.TestUtils;

public class WikisResourceTest
extends AbstractHttpTest {
    @Override
    @Test
    public void testRepresentation() throws Exception {
        GetMethod getMethod = this.executeGet(this.getFullUri(WikisResource.class));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Wikis wikis = (Wikis)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertTrue((String)this.getHttpMethodInfo((HttpMethod)getMethod), (wikis.getWikis().size() > 0 ? 1 : 0) != 0);
        for (Wiki wiki : wikis.getWikis()) {
            Link link = this.getFirstLinkByRelation((LinkCollection)wiki, "http://www.xwiki.org/rel/spaces");
            Assert.assertNotNull((Object)link);
            link = this.getFirstLinkByRelation((LinkCollection)wiki, "http://www.xwiki.org/rel/classes");
            Assert.assertNotNull((Object)link);
            link = this.getFirstLinkByRelation((LinkCollection)wiki, "http://www.xwiki.org/rel/modifications");
            Assert.assertNotNull((Object)link);
            link = this.getFirstLinkByRelation((LinkCollection)wiki, "http://www.xwiki.org/rel/search");
            Assert.assertNotNull((Object)link);
            link = this.getFirstLinkByRelation((LinkCollection)wiki, "http://www.xwiki.org/rel/query");
            Assert.assertNotNull((Object)link);
            this.checkLinks((LinkCollection)wiki);
        }
    }

    @Test
    public void testSearch() throws Exception {
        GetMethod getMethod = this.executeGet(String.format("%s?q=easy-to-edit", this.getUriBuilder(WikiSearchResource.class).build(new Object[]{this.getWiki()})));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        SearchResults searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        int resultSize = searchResults.getSearchResults().size();
        Assert.assertTrue((String)String.format("Found %s results", resultSize), (resultSize >= 1 ? 1 : 0) != 0);
        for (SearchResult searchResult : searchResults.getSearchResults()) {
            this.checkLinks((LinkCollection)searchResult);
        }
        getMethod = this.executeGet(String.format("%s?q=WebHome&scope=name", this.getUriBuilder(WikiSearchResource.class).build(new Object[]{this.getWiki()})));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        resultSize = searchResults.getSearchResults().size();
        Assert.assertTrue((String)String.format("Found %s results", resultSize), (resultSize >= 3 ? 1 : 0) != 0);
        for (SearchResult searchResult : searchResults.getSearchResults()) {
            this.checkLinks((LinkCollection)searchResult);
        }
        getMethod = this.executeGet(String.format("%s?q=services&scope=title", this.getUriBuilder(WikiSearchResource.class).build(new Object[]{this.getWiki()})));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        resultSize = searchResults.getSearchResults().size();
        Assert.assertTrue((String)String.format("Found %s results", resultSize), (searchResults.getSearchResults().size() >= 1 ? 1 : 0) != 0);
        for (SearchResult searchResult : searchResults.getSearchResults()) {
            this.checkLinks((LinkCollection)searchResult);
        }
        getMethod = this.executeGet(String.format("%s?q=db&scope=spaces", this.getUriBuilder(WikiSearchResource.class).build(new Object[]{this.getWiki()})));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        resultSize = searchResults.getSearchResults().size();
        Assert.assertTrue((String)String.format("Found %s results", resultSize), (resultSize >= 1 ? 1 : 0) != 0);
        for (SearchResult searchResult : searchResults.getSearchResults()) {
            this.checkLinks((LinkCollection)searchResult);
        }
    }

    @Test
    public void testObjectSearchNotAuthenticated() throws Exception {
        GetMethod getMethod = this.executeGet(String.format("%s?q=XWiki.Admin&scope=objects", this.getUriBuilder(WikiSearchResource.class).build(new Object[]{this.getWiki()})));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        SearchResults searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        int resultSize = searchResults.getSearchResults().size();
        Assert.assertTrue((String)String.format("Found %s results", resultSize), (resultSize == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testObjectSearchAuthenticated() throws Exception {
        GetMethod getMethod = this.executeGet(String.format("%s?q=XWiki.Admin&scope=objects", this.getUriBuilder(WikiSearchResource.class).build(new Object[]{this.getWiki()})), TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        SearchResults searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        int resultSize = searchResults.getSearchResults().size();
        Assert.assertTrue((String)String.format("Found %s results", resultSize), (resultSize >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testPages() throws Exception {
        GetMethod getMethod = this.executeGet(String.format("%s", this.getUriBuilder(WikiPagesResource.class).build(new Object[]{this.getWiki()})));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Pages pages = (Pages)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertTrue((pages.getPageSummaries().size() > 0 ? 1 : 0) != 0);
        for (PageSummary pageSummary : pages.getPageSummaries()) {
            this.checkLinks((LinkCollection)pageSummary);
        }
        getMethod = this.executeGet(String.format("%s?name=WebHome", this.getUriBuilder(WikiPagesResource.class).build(new Object[]{this.getWiki()})));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        pages = (Pages)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        List pageSummaries = pages.getPageSummaries();
        Assert.assertTrue((pageSummaries.size() > 0 ? 1 : 0) != 0);
        int foundCounter = 0;
        List<String> expectedWebHomes = Arrays.asList("Main.WebHome", "Sandbox.WebHome", "XWiki.WebHome");
        for (PageSummary pageSummary : pages.getPageSummaries()) {
            if (expectedWebHomes.contains(pageSummary.getFullName())) {
                ++foundCounter;
            }
            Assert.assertTrue((boolean)pageSummary.getFullName().endsWith(".WebHome"));
            this.checkLinks((LinkCollection)pageSummary);
        }
        Assert.assertTrue((String)"Some WebHome pages were not found!", (foundCounter >= expectedWebHomes.size() ? 1 : 0) != 0);
        getMethod = this.executeGet(String.format("%s?name=WebHome&space=s", this.getUriBuilder(WikiPagesResource.class).build(new Object[]{this.getWiki()})));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        pages = (Pages)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        pageSummaries = pages.getPageSummaries();
        Assert.assertTrue((pageSummaries.size() > 0 ? 1 : 0) != 0);
        foundCounter = 0;
        expectedWebHomes = Arrays.asList("ColorThemes.WebHome", "Stats.WebHome", "Sandbox.WebHome", "Panels.WebHome", "Scheduler.WebHome", "Sandbox.WebHome");
        for (PageSummary pageSummary : pages.getPageSummaries()) {
            if (expectedWebHomes.contains(pageSummary.getFullName())) {
                ++foundCounter;
            }
            Assert.assertTrue((boolean)pageSummary.getFullName().endsWith(".WebHome"));
            this.checkLinks((LinkCollection)pageSummary);
        }
        Assert.assertTrue((String)"Some WebHome pages were not found!", (foundCounter >= expectedWebHomes.size() ? 1 : 0) != 0);
    }

    @Test
    public void testAttachments() throws Exception {
        GetMethod getMethod = this.executeGet(String.format("%s", this.getUriBuilder(WikiAttachmentsResource.class).build(new Object[]{this.getWiki()})));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Attachments attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertTrue((attachments.getAttachments().size() > 0 ? 1 : 0) != 0);
        for (Attachment attachment : attachments.getAttachments()) {
            this.checkLinks((LinkCollection)attachment);
        }
        getMethod = this.executeGet(String.format("%s?name=iLogo", this.getUriBuilder(WikiAttachmentsResource.class).build(new Object[]{this.getWiki()})));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertEquals((String)this.getAttachmentsInfo(attachments), (long)1L, (long)attachments.getAttachments().size());
        for (Attachment attachment : attachments.getAttachments()) {
            this.checkLinks((LinkCollection)attachment);
        }
        getMethod = this.executeGet(String.format("%s?space=sandbox", this.getUriBuilder(WikiAttachmentsResource.class).build(new Object[]{this.getWiki()})));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertEquals((String)this.getAttachmentsInfo(attachments), (long)1L, (long)attachments.getAttachments().size());
        for (Attachment attachment : attachments.getAttachments()) {
            this.checkLinks((LinkCollection)attachment);
        }
        getMethod = this.executeGet(String.format("%s?name=Logo&space=Sandbox", this.getUriBuilder(WikiAttachmentsResource.class).build(new Object[]{this.getWiki()})));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertEquals((String)this.getAttachmentsInfo(attachments), (long)1L, (long)attachments.getAttachments().size());
        for (Attachment attachment : attachments.getAttachments()) {
            this.checkLinks((LinkCollection)attachment);
        }
    }

    @Test
    public void testHQLQuerySearch() throws Exception {
        GetMethod getMethod = this.executeGet(URIUtil.encodeQuery((String)String.format("%s?q=where doc.name='WebHome' order by doc.space desc&type=hql", this.getUriBuilder(WikiSearchQueryResource.class).build(new Object[]{this.getWiki()}))));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        SearchResults searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        int resultSize = searchResults.getSearchResults().size();
        Assert.assertTrue((String)String.format("Found %s results", resultSize), (resultSize >= 1 ? 1 : 0) != 0);
        int foundCounter = 0;
        List<String> expectedWebHomes = Arrays.asList("ColorThemes.WebHome", "Stats.WebHome", "Sandbox.WebHome", "Panels.WebHome", "Scheduler.WebHome", "Sandbox.WebHome", "XWiki.WebHome");
        for (SearchResult searchResult : searchResults.getSearchResults()) {
            this.checkLinks((LinkCollection)searchResult);
            if (expectedWebHomes.contains(searchResult.getPageFullName())) {
                ++foundCounter;
            }
            Assert.assertTrue((boolean)searchResult.getPageFullName().endsWith(".WebHome"));
        }
        Assert.assertTrue((String)"Some WebHome pages were not found!", (foundCounter >= expectedWebHomes.size() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"XWiki.WebHome", (Object)((SearchResult)searchResults.getSearchResults().get(0)).getPageFullName());
    }

    @Test
    public void testHQLQuerySearchWithClassnameAuthenticated() throws Exception {
        GetMethod getMethod = this.executeGet(URIUtil.encodeQuery((String)String.format("%s?q=where doc.space='XWiki' and doc.name='Admin'&type=hql&className=XWiki.XWikiUsers", this.getUriBuilder(WikiSearchQueryResource.class).build(new Object[]{this.getWiki()}))), TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        SearchResults searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        int resultSize = searchResults.getSearchResults().size();
        Assert.assertTrue((String)String.format("Found %s results", resultSize), (resultSize == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)((SearchResult)searchResults.getSearchResults().get(0)).getObject());
    }

    @Test
    public void testHQLQuerySearchWithClassnameNotAuthenticated() throws Exception {
        GetMethod getMethod = this.executeGet(URIUtil.encodeQuery((String)String.format("%s?q=where doc.space='XWiki' and doc.name='Admin'&type=hql&classname=XWiki.XWikiUsers", this.getUriBuilder(WikiSearchQueryResource.class).build(new Object[]{this.getWiki()}))));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        SearchResults searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        int resultSize = searchResults.getSearchResults().size();
        Assert.assertTrue((String)String.format("Found %s results", resultSize), (resultSize == 1 ? 1 : 0) != 0);
        Assert.assertNull((Object)((SearchResult)searchResults.getSearchResults().get(0)).getObject());
    }

    @Test
    public void testLuceneSearch() throws Exception {
        GetMethod getMethod = this.executeGet(URIUtil.encodeQuery((String)String.format("%s?q=\"easy-to-edit\"&type=lucene", this.getUriBuilder(WikiSearchQueryResource.class).build(new Object[]{this.getWiki()}))));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        SearchResults searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        int resultSize = searchResults.getSearchResults().size();
        Assert.assertTrue((String)String.format("Found %s results", resultSize), (resultSize == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Main.Welcome", (Object)((SearchResult)searchResults.getSearchResults().get(0)).getPageFullName());
    }

    @Test
    public void testGlobalLuceneSearch() throws Exception {
        GetMethod getMethod = this.executeGet(URIUtil.encodeQuery((String)String.format("%s?q=\"easy-to-edit\"&type=lucene&wikis=xwiki", this.getUriBuilder(WikisSearchQueryResource.class).build(new Object[]{this.getWiki()}))));
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        SearchResults searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        int resultSize = searchResults.getSearchResults().size();
        Assert.assertTrue((String)String.format("Found %s results", resultSize), (resultSize == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Main.Welcome", (Object)((SearchResult)searchResults.getSearchResults().get(0)).getPageFullName());
    }

    @Test
    public void testImportXAR() throws Exception {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/Main.Foo.xar");
        String wiki = this.getWiki();
        PostMethod postMethod = this.executePost(this.getUriBuilder(WikiResource.class).build(new Object[]{wiki}).toString(), is, TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (long)200L, (long)postMethod.getStatusCode());
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{wiki, "Main", "Foo"}).toString(), TestUtils.ADMIN_CREDENTIALS.getUserName(), TestUtils.ADMIN_CREDENTIALS.getPassword());
        Assert.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (long)200L, (long)getMethod.getStatusCode());
        Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        Assert.assertEquals((Object)wiki, (Object)page.getWiki());
        Assert.assertEquals((Object)"Main", (Object)page.getSpace());
        Assert.assertEquals((Object)"Foo", (Object)page.getName());
        Assert.assertEquals((Object)"Foo", (Object)page.getContent());
    }
}

