/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.storage.framework;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpMethod;
import org.xwiki.test.integration.XWikiExecutor;
import org.xwiki.test.storage.framework.TestUtils;

public class AbstractTest {
    private static XWikiExecutor executor;
    private String secretToken = null;

    public static void setExecutor(XWikiExecutor executor) {
        AbstractTest.executor = executor;
    }

    protected short getPort() {
        return (short)executor.getPort();
    }

    protected String getAddressPrefix() {
        return "http://127.0.0.1:" + this.getPort() + "/xwiki/bin/";
    }

    protected HttpMethod doPostAsAdmin(String space, String page, String filename, String action, String query, Map<String, String> postParameters) throws IOException {
        String url = this.getURL(space, page, filename, action, this.addBasicauth(query));
        return TestUtils.doPost(url, TestUtils.ADMIN_CREDENTIALS, postParameters);
    }

    public HttpMethod doUploadAsAdmin(String space, String page, Map<String, byte[]> uploads) throws IOException {
        String url = this.getURL(space, page, null, "upload", this.addBasicauth(null));
        return TestUtils.doUpload(url, TestUtils.ADMIN_CREDENTIALS, uploads);
    }

    private String addBasicauth(String query) {
        String basicauth = "basicauth=1";
        if (query == null || query.isEmpty()) {
            return basicauth;
        }
        return query + "&" + basicauth;
    }

    protected String getURL(String space, String page, String filename, String action, String queryString) {
        boolean needToAddQuery;
        StringBuilder builder = new StringBuilder(this.getAddressPrefix());
        builder.append(action);
        builder.append('/');
        builder.append(TestUtils.escapeURL(space));
        builder.append('/');
        builder.append(TestUtils.escapeURL(page));
        if (filename != null && !filename.isEmpty()) {
            builder.append('/');
            builder.append(TestUtils.escapeURL(filename));
        }
        boolean needToAddSecretToken = !"view".equals(action) && !"edit".equals(action);
        boolean bl = needToAddQuery = queryString != null && !queryString.isEmpty();
        if (needToAddSecretToken || needToAddQuery) {
            builder.append('?');
        }
        if (needToAddSecretToken) {
            builder.append("form_token=");
            builder.append(this.getSecretToken());
            builder.append('&');
        }
        if (needToAddQuery) {
            builder.append(queryString);
        }
        return builder.toString();
    }

    protected String getSecretToken() {
        if (this.secretToken == null) {
            String body = null;
            try {
                body = new String(this.doPostAsAdmin("Main", "WebHome", null, "edit", "editor=wiki", null).getResponseBody(), "UTF-8");
                Matcher matcher = Pattern.compile("<input[^>]+form_token[^>]+value=('|\")([^'\"]+)").matcher(body);
                if (matcher.find() && matcher.groupCount() == 2) {
                    this.secretToken = matcher.group(2);
                    return this.secretToken;
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            System.out.println("Warning: Failed to cache anti-CSRF secret token, some tests might fail!");
            return "";
        }
        return this.secretToken;
    }
}

