/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.storage.framework;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;

public final class StoreTestUtils {
    public static String getPageAsString(String address) throws IOException {
        HttpMethod ret = StoreTestUtils.doPost(address, null, null);
        return new String(ret.getResponseBody(), "UTF-8");
    }

    public static HttpMethod doPost(String address, UsernamePasswordCredentials userNameAndPassword, Map<String, String> parameters) throws IOException {
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(address);
        if (userNameAndPassword != null) {
            client.getState().setCredentials(AuthScope.ANY, (Credentials)userNameAndPassword);
            client.getParams().setAuthenticationPreemptive(true);
        }
        if (parameters != null) {
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                method.addParameter(e.getKey(), e.getValue());
            }
        }
        client.executeMethod((HttpMethod)method);
        return method;
    }

    public static HttpMethod doUpload(String address, UsernamePasswordCredentials userNameAndPassword, Map<String, byte[]> uploads) throws IOException {
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(address);
        if (userNameAndPassword != null) {
            client.getState().setCredentials(AuthScope.ANY, (Credentials)userNameAndPassword);
            client.getParams().setAuthenticationPreemptive(true);
        }
        Part[] parts = new Part[uploads.size()];
        int i = 0;
        for (Map.Entry<String, byte[]> e : uploads.entrySet()) {
            parts[i++] = new FilePart("filepath", (PartSource)new ByteArrayPartSource(e.getKey(), e.getValue()));
        }
        MultipartRequestEntity entity = new MultipartRequestEntity(parts, method.getParams());
        method.setRequestEntity((RequestEntity)entity);
        client.executeMethod((HttpMethod)method);
        return method;
    }

    public static String escapeURL(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

