/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.webdav;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.webdav.lib.methods.MkcolMethod;
import org.apache.webdav.lib.methods.MoveMethod;
import org.apache.webdav.lib.methods.PropFindMethod;

public class AbstractWebDAVTest
extends TestCase {
    public static final String ROOT = "http://localhost:8080/xwiki/webdav";
    public static final String HOME = "http://localhost:8080/xwiki/webdav/home";
    public static final String SPACES = "http://localhost:8080/xwiki/webdav/spaces";
    public static final String ATTACHMENTS = "http://localhost:8080/xwiki/webdav/attachments";
    public static final String ORPHANS = "http://localhost:8080/xwiki/webdav/orphans";
    public static final String WHATSNEW = "http://localhost:8080/xwiki/webdav/whatsnew";
    public static String[] BASE_VIEWS = new String[]{"http://localhost:8080/xwiki/webdav/spaces", "http://localhost:8080/xwiki/webdav/attachments", "http://localhost:8080/xwiki/webdav/home", "http://localhost:8080/xwiki/webdav/orphans", "http://localhost:8080/xwiki/webdav/whatsnew"};
    private HttpClient client;

    protected void setUp() throws Exception {
        super.setUp();
        this.client = new HttpClient();
        this.client.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials("Admin", "admin"));
        this.client.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
        this.client.getParams().setAuthenticationPreemptive(true);
    }

    protected HttpClient getHttpClient() {
        return this.client;
    }

    protected void testMethod(HttpMethod method, int expect) {
        try {
            int status = this.getHttpClient().executeMethod(method);
            AbstractWebDAVTest.assertEquals((int)expect, (int)status);
        }
        catch (HttpException ex) {
            AbstractWebDAVTest.fail((String)ex.getMessage());
        }
        catch (IOException ex) {
            AbstractWebDAVTest.fail((String)ex.getMessage());
        }
    }

    protected HttpMethod propFind(String url, int depth, int expect) {
        PropFindMethod propFindMethod = new PropFindMethod(url);
        propFindMethod.setDoAuthentication(true);
        propFindMethod.setDepth(depth);
        this.testMethod((HttpMethod)propFindMethod, expect);
        return propFindMethod;
    }

    protected HttpMethod mkCol(String url, int expect) {
        MkcolMethod mkColMethod = new MkcolMethod();
        mkColMethod.setDoAuthentication(true);
        mkColMethod.setPath(url);
        this.testMethod((HttpMethod)mkColMethod, expect);
        return mkColMethod;
    }

    protected HttpMethod put(String url, String content, int expect) {
        PutMethod putMethod = new PutMethod();
        putMethod.setDoAuthentication(true);
        putMethod.setPath(url);
        putMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(content.getBytes())));
        this.testMethod((HttpMethod)putMethod, expect);
        return putMethod;
    }

    protected HttpMethod delete(String url, int expect) {
        DeleteMethod deleteMethod = new DeleteMethod();
        deleteMethod.setDoAuthentication(true);
        deleteMethod.setPath(url);
        this.testMethod((HttpMethod)deleteMethod, expect);
        return deleteMethod;
    }

    protected HttpMethod move(String url, String destination, int expect) {
        MoveMethod moveMethod = new MoveMethod();
        moveMethod.setDoAuthentication(true);
        moveMethod.setPath(url);
        moveMethod.setDestination(destination);
        this.testMethod((HttpMethod)moveMethod, expect);
        return moveMethod;
    }

    protected HttpMethod get(String url, int expect) {
        GetMethod getMethod = new GetMethod();
        getMethod.setDoAuthentication(true);
        getMethod.setPath(url);
        this.testMethod((HttpMethod)getMethod, expect);
        return getMethod;
    }
}

