/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.xmlrpc;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.xmlrpc.XmlRpcException;
import org.codehaus.swizzle.confluence.Page;
import org.codehaus.swizzle.confluence.SpaceSummary;
import org.xwiki.test.xmlrpc.AbstractXWikiXmlRpcTest;
import org.xwiki.test.xmlrpc.TestUtils;
import org.xwiki.xmlrpc.model.Utils;
import org.xwiki.xmlrpc.model.XWikiPage;
import org.xwiki.xmlrpc.model.XWikiPageHistorySummary;
import org.xwiki.xmlrpc.model.XWikiPageSummary;

public class PagesTest
extends AbstractXWikiXmlRpcTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createPage("Test.Test", "Test page", String.format("Modified by org.xwiki.xmlrpc @ %s (This is the first version)\n", new Date()));
        this.createPage("Test.Translations", "Test page", String.format("Modified by org.xwiki.xmlrpc @ %s (This is the first version)\n", new Date()));
        this.addTranslation("ro", "Titlul paginii", "Continutul paginii");
    }

    private void createPage(String id, String title, String content) throws Exception {
        try {
            this.rpc.removePage(id);
        }
        catch (XmlRpcException e) {
            // empty catch block
        }
        XWikiPage page = new XWikiPage();
        page.setId(id);
        page.setTitle(title);
        page.setContent(content);
        this.rpc.storePage((Page)page);
    }

    private XWikiPage addTranslation(String language, String title, String content) throws Exception {
        XWikiPage translatedPage = new XWikiPage();
        translatedPage.setId("Test.Translations");
        translatedPage.setSpace("Test");
        translatedPage.setTitle(title);
        translatedPage.setContent(content);
        translatedPage.setLanguage(language);
        return this.rpc.storePage((Page)translatedPage);
    }

    public void testGetPages() throws Exception {
        List spaces = this.rpc.getSpaces();
        List pages = this.rpc.getPages(((SpaceSummary)spaces.get(0)).getKey());
        TestUtils.banner("TEST: getPages()");
        for (XWikiPageSummary pageSummary : pages) {
            System.out.format("%s\n", pageSummary);
        }
        PagesTest.assertFalse((boolean)pages.isEmpty());
    }

    public void testGetPagesWithNoRightsOnSpace() throws Exception {
        if ("Admin".equals("Admin")) {
            return;
        }
        List pages = this.rpc.getPages("Scheduler");
        PagesTest.assertTrue((boolean)pages.isEmpty());
    }

    public void testGetPage() throws Exception {
        List spaces = this.rpc.getSpaces();
        List pages = this.rpc.getPages(((SpaceSummary)spaces.get(0)).getKey());
        XWikiPage page = this.rpc.getPage(((XWikiPageSummary)pages.get(0)).getId());
        TestUtils.banner("TEST: getPage()");
        System.out.format("%s\n", page);
        PagesTest.assertEquals((String)page.getId(), (String)((XWikiPageSummary)pages.get(0)).getId());
    }

    public void testStorePage() throws Exception {
        XWikiPage page = this.rpc.getPage("Test.Test");
        String content = String.format("Modified by org.xwiki.xmlrpc @ %s (This will be version: %d)\n", new Date(), page.getVersion() + 1);
        page.setContent(content);
        XWikiPage storedPage = this.rpc.storePage((Page)page);
        TestUtils.banner("TEST: storePage()");
        System.out.format("Content sent: '%s'\n", Utils.truncateToFirstLine((String)content));
        System.out.format("%s\n", storedPage);
        PagesTest.assertEquals((String)content, (String)storedPage.getContent());
        PagesTest.assertTrue((storedPage.getVersion() == page.getVersion() + 1 ? 1 : 0) != 0);
        PagesTest.assertEquals((String)page.getLanguage(), (String)storedPage.getLanguage());
    }

    public void testChangeParentId() throws Exception {
        List pages = this.rpc.getPages("Test");
        XWikiPageSummary pageSummary1 = (XWikiPageSummary)pages.get(0);
        XWikiPageSummary pageSummary2 = null;
        for (XWikiPageSummary ps : pages) {
            if (pageSummary1.getParentId().equals(ps.getId())) continue;
            pageSummary2 = ps;
        }
        TestUtils.banner("TEST: changeParentId()");
        System.out.format("Setting page '%s' parent id to '%s'. Now: '%s'\n", pageSummary1.getId(), pageSummary2.getId(), pageSummary1.getParentId());
        XWikiPage page = this.rpc.getPage(pageSummary1.getId());
        PagesTest.assertNotSame((Object)pageSummary2.getId(), (Object)page.getParentId());
        page.setParentId(pageSummary2.getId());
        page = this.rpc.storePage((Page)page);
        System.out.format("New page: %s\n", page);
        PagesTest.assertEquals((String)pageSummary2.getId(), (String)page.getParentId());
    }

    public void testStoreNewPageTranslation() throws Exception {
        XWikiPage page = this.rpc.getPage("Test.Translations");
        HashMap<String, XWikiPage> before = new HashMap<String, XWikiPage>();
        before.put(page.getLanguage(), page);
        for (String l : page.getTranslations()) {
            XWikiPage p = this.rpc.getPage("Test.Translations", l);
            before.put(l, p);
        }
        String[] languages = Locale.getISOLanguages();
        HashMap<String, String> deprecatedCodes = new HashMap<String, String>();
        deprecatedCodes.put("he", "iw");
        deprecatedCodes.put("id", "in");
        deprecatedCodes.put("yi", "ji");
        String fakeLanguage = languages[this.random.nextInt(languages.length)];
        if (deprecatedCodes.containsKey(fakeLanguage)) {
            fakeLanguage = (String)deprecatedCodes.get(fakeLanguage);
        }
        String translatedContent = String.format("This is the content in the '%s' language. (This will be version: %d)", fakeLanguage, page.getVersion() + 1);
        this.addTranslation(fakeLanguage, "Translated page", translatedContent);
        page = this.rpc.getPage("Test.Translations");
        HashMap<String, XWikiPage> after = new HashMap<String, XWikiPage>();
        after.put(page.getLanguage(), page);
        for (String l : page.getTranslations()) {
            XWikiPage p = this.rpc.getPage("Test.Translations", l);
            after.put(l, p);
        }
        TestUtils.banner("TEST: storeNewPageTranslation()");
        System.out.format("Adding the '%s' translation...\n", fakeLanguage);
        System.out.format("*********************************\n", new Object[0]);
        System.out.format("Before: %s\n", before);
        System.out.format("*********************************\n", new Object[0]);
        System.out.format("After: %s\n", after);
        PagesTest.assertFalse((boolean)before.containsKey(fakeLanguage));
        PagesTest.assertTrue((boolean)after.containsKey(fakeLanguage));
        PagesTest.assertEquals((String)translatedContent, (String)((XWikiPage)after.get(fakeLanguage)).getContent());
        for (String l : before.keySet()) {
            PagesTest.assertTrue((boolean)after.containsKey(l));
            XWikiPage b = (XWikiPage)before.get(l);
            XWikiPage a = (XWikiPage)after.get(l);
            PagesTest.assertEquals((int)b.getVersion(), (int)a.getVersion());
            PagesTest.assertEquals((String)b.getContent(), (String)a.getContent());
        }
    }

    public void testStorePageTranslation() throws Exception {
        XWikiPage page = this.rpc.getPage("Test.Translations");
        HashMap<String, String> translatedContents = new HashMap<String, String>();
        translatedContents.put("", page.getContent());
        for (String l : page.getTranslations()) {
            XWikiPage p = this.rpc.getPage("Test.Translations", l);
            translatedContents.put(l, p.getContent());
        }
        TestUtils.banner("TEST: storeTranslatedPage()");
        System.out.format("%s\n", page);
        String targetLanguage = (String)page.getTranslations().get(0);
        String content = String.format("This is a new translation for language '%s' @ %s (this will be version %d)", targetLanguage, new Date(), page.getVersion() + 1);
        this.addTranslation(targetLanguage, "Translated page", content);
        System.out.format("New content: %s\n", content);
        System.out.format("%s\n", page);
        HashMap<String, String> newTranslatedContents = new HashMap<String, String>();
        newTranslatedContents.put("", page.getContent());
        for (String l : page.getTranslations()) {
            XWikiPage p = this.rpc.getPage("Test.Translations", l);
            newTranslatedContents.put(l, p.getContent());
        }
        System.out.format("Old translations: %s\n", translatedContents);
        System.out.format("New translations: %s\n", newTranslatedContents);
        PagesTest.assertEquals(translatedContents.keySet(), newTranslatedContents.keySet());
        for (String l : newTranslatedContents.keySet()) {
            if (!l.equals(targetLanguage)) {
                PagesTest.assertEquals((String)((String)translatedContents.get(l)), (String)((String)newTranslatedContents.get(l)));
                continue;
            }
            PagesTest.assertEquals((String)content, (String)((String)newTranslatedContents.get(l)));
        }
    }

    public void testGetPageWithTranslations() throws Exception {
        XWikiPage page = this.rpc.getPage("Test.Translations");
        TestUtils.banner("TEST: getPageWithTranslations()");
        System.out.format("%s\n", page);
        PagesTest.assertFalse((boolean)page.getTranslations().isEmpty());
    }

    public void testGetPageTranslations() throws Exception {
        XWikiPage page = this.rpc.getPage("Test.Translations");
        TestUtils.banner("TEST: getPageTranslations()");
        for (String language : page.getTranslations()) {
            XWikiPage translatedPage = this.rpc.getPage("Test.Translations", language);
            System.out.format("XWikiPage for language '%s': %s\n", language, translatedPage);
            PagesTest.assertEquals((String)language, (String)translatedPage.getLanguage());
        }
    }

    public void testCreatePage() throws Exception {
        String pageId = String.format("%s.%s-%d", "Test", "TEST", Math.abs(this.random.nextInt()));
        String content = String.format("Modified by org.xwiki.xmlrpc @ %s (inital version)\n", new Date());
        XWikiPage page = null;
        TestUtils.banner("TEST: createPage()");
        try {
            page = this.rpc.getPage(pageId);
            throw new RuntimeException(String.format("XWikiPage %s exists!", pageId));
        }
        catch (Exception e) {
            System.out.format("XWikiPage %s does not exist... Good!\n", pageId);
            page = new XWikiPage();
            page.setId(pageId);
            page.setSpace("Test");
            page.setTitle("Test page");
            page.setContent(content);
            XWikiPage storedPage = this.rpc.storePage((Page)page);
            System.out.format("Content sent: '%s'\n", Utils.truncateToFirstLine((String)content));
            System.out.format("%s\n", storedPage);
            PagesTest.assertEquals((String)storedPage.getContent(), (String)content);
            PagesTest.assertTrue((storedPage.getVersion() == 1 ? 1 : 0) != 0);
            PagesTest.assertEquals((String)"", (String)storedPage.getLanguage());
            return;
        }
    }

    public void testCreatePageWithNullSpace() throws Exception {
        String pageId = String.format("%s.%s-%d", "Test", "TEST", Math.abs(this.random.nextInt()));
        String content = String.format("Modified by org.xwiki.xmlrpc @ %s (inital version)\n", new Date());
        XWikiPage page = null;
        TestUtils.banner("TEST: createPageWithNullSpace()");
        try {
            page = this.rpc.getPage(pageId);
            throw new RuntimeException(String.format("XWikiPage %s exists!", pageId));
        }
        catch (Exception e) {
            System.out.format("XWikiPage %s does not exist... Good!\n", pageId);
            page = new XWikiPage();
            page.setId(pageId);
            page.setTitle("Test page");
            page.setContent(content);
            XWikiPage storedPage = this.rpc.storePage((Page)page);
            System.out.format("Content sent: '%s'\n", Utils.truncateToFirstLine((String)content));
            System.out.format("%s\n", storedPage);
            PagesTest.assertEquals((String)storedPage.getContent(), (String)content);
            PagesTest.assertTrue((storedPage.getVersion() == 1 ? 1 : 0) != 0);
            PagesTest.assertEquals((String)"", (String)storedPage.getLanguage());
            return;
        }
    }

    public void testCreatePageInSpaceWithNoAccessRights() throws Exception {
        if ("Admin".equals("Admin")) {
            System.out.format("User admin can always access everything", new Object[0]);
            return;
        }
        String pageId = String.format("%s.%s-%d", "Scheduler", "TEST", Math.abs(this.random.nextInt()));
        String content = String.format("Modified by org.xwiki.xmlrpc @ %s\n", new Date());
        XWikiPage page = null;
        TestUtils.banner("TEST: createPageInSpaceWithNoAccessRights()");
        try {
            page = this.rpc.getPage(pageId);
            throw new RuntimeException(String.format("XWikiPage %s exists!", pageId));
        }
        catch (Exception e) {
            System.out.format("XWikiPage %s does not exist... Good!\n", pageId);
            page = new XWikiPage();
            page.setId(pageId);
            page.setSpace("Test");
            page.setTitle("Test page");
            page.setContent(content);
            try {
                this.rpc.storePage((Page)page);
                PagesTest.fail();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return;
        }
    }

    public void testRemovePage() throws Exception {
        List pages = this.rpc.getPages("Test");
        XWikiPageSummary pageToBeDeleted = null;
        for (XWikiPageSummary pageSummary : pages) {
            if (!pageSummary.getId().contains("TEST")) continue;
            pageToBeDeleted = pageSummary;
            break;
        }
        Boolean result = this.rpc.removePage(pageToBeDeleted.getId());
        TestUtils.banner("TEST: removePage()");
        System.out.format("XWikiPage %s removed: %b\n", pageToBeDeleted.getId(), result);
        pages = this.rpc.getPages("Test");
        boolean removed = true;
        for (XWikiPageSummary pageSummary : pages) {
            if (!pageSummary.getId().equals(pageToBeDeleted.getId())) continue;
            removed = false;
            break;
        }
        PagesTest.assertTrue((boolean)removed);
    }

    public void testGetPageHistory() throws Exception {
        List pageHistorySummaries = this.rpc.getPageHistory("Test.Test");
        TestUtils.banner("TEST: getPageHistory()");
        for (XWikiPageHistorySummary pageHistorySummary : pageHistorySummaries) {
            System.out.format("%s\n", pageHistorySummary);
        }
        PagesTest.assertFalse((boolean)pageHistorySummaries.isEmpty());
    }

    public void testGetPageAtVersion() throws Exception {
        List pageHistorySummaries = this.rpc.getPageHistory("Test.Test");
        XWikiPageHistorySummary pageHistorySummary = (XWikiPageHistorySummary)pageHistorySummaries.get(this.random.nextInt(pageHistorySummaries.size()));
        XWikiPage page = this.rpc.getPage("Test.Test", Integer.valueOf(pageHistorySummary.getVersion()));
        TestUtils.banner("TEST: getPageAtVersion()");
        System.out.format("%s\n", pageHistorySummary);
        System.out.format("%s\n", page);
        PagesTest.assertEquals((int)pageHistorySummary.getVersion(), (int)page.getVersion());
        PagesTest.assertEquals((String)pageHistorySummary.getModifier(), (String)page.getModifier());
    }

    public void testGetPageAtVersionUsingExtendedId() throws Exception {
        List pageHistorySummaries = this.rpc.getPageHistory("Test.Test");
        XWikiPageHistorySummary pageHistorySummary = (XWikiPageHistorySummary)pageHistorySummaries.get(this.random.nextInt(pageHistorySummaries.size()));
        XWikiPage page = this.rpc.getPage(pageHistorySummary.getId());
        TestUtils.banner("TEST: getPageAtVersionUsingExtendedId()");
        System.out.format("%s\n", pageHistorySummary);
        System.out.format("%s\n", page);
        PagesTest.assertEquals((int)pageHistorySummary.getVersion(), (int)page.getVersion());
        PagesTest.assertEquals((String)pageHistorySummary.getModifier(), (String)page.getModifier());
    }

    public void testRenderContent() throws Exception {
        TestUtils.banner("TEST: renderContent()");
        String html = this.rpc.renderContent("Test", "Test.Test", "");
        System.out.format("Rendered content: '%s'\n", html);
        PagesTest.assertTrue((html.length() != 0 ? 1 : 0) != 0);
        html = this.rpc.renderContent("Test", "Test.Test", "{{groovy}}print 'programming'{{/groovy}}");
        System.out.format("Rendered content: '%s'\n", html);
        PagesTest.assertEquals((String)"<p>programming</p>", (String)html);
    }

    public void testRenamePage() throws Exception {
        String pageName = String.format("%s-%d", "TEST", Math.abs(this.random.nextInt()));
        String pageId = String.format("%s.%s", "Test", pageName);
        String content = String.format("Modified by org.xwiki.xmlrpc @ %s (inital version)\n", new Date());
        XWikiPage page = null;
        TestUtils.banner("TEST: renamePage()");
        page = new XWikiPage();
        page.setId(pageId);
        page.setContent(content);
        page = this.rpc.storePage((Page)page);
        page.setSpace("Foo");
        page.setTitle("Bar");
        XWikiPage renamedPage = this.rpc.storePage((Page)page);
        try {
            this.rpc.getPage(pageId);
            PagesTest.fail((String)"This page should no longer exist");
        }
        catch (Exception e) {
            // empty catch block
        }
        PagesTest.assertTrue((boolean)renamedPage.getId().equals("Foo.Bar"));
        PagesTest.assertTrue((boolean)renamedPage.getContent().equals(content));
        page = new XWikiPage();
        page.setId(pageId);
        page.setContent(content);
        page = this.rpc.storePage((Page)page);
        page.setSpace("TargetSpace");
        renamedPage = this.rpc.storePage((Page)page);
        try {
            this.rpc.getPage(pageId);
            PagesTest.fail((String)"This page should no longer exist");
        }
        catch (Exception e) {
            // empty catch block
        }
        PagesTest.assertTrue((boolean)renamedPage.getId().equals(String.format("TargetSpace.%s", pageName)));
        PagesTest.assertTrue((boolean)renamedPage.getContent().equals(content));
        page = new XWikiPage();
        page.setId(pageId);
        page.setContent(content);
        page = this.rpc.storePage((Page)page);
        page.setTitle("Foo");
        renamedPage = this.rpc.storePage((Page)page);
        try {
            this.rpc.getPage(pageId);
            PagesTest.fail((String)"This page should no longer exist");
        }
        catch (Exception e) {
            // empty catch block
        }
        PagesTest.assertTrue((boolean)renamedPage.getId().equals(String.format("%s.Foo", "Test")));
        PagesTest.assertTrue((boolean)renamedPage.getContent().equals(content));
    }

    public void testGetModifiedPagesHistoryDescending() throws Exception {
        List pageHistorySummaries = this.rpc.getModifiedPagesHistory(Integer.valueOf(50), Integer.valueOf(0), Boolean.valueOf(true));
        TestUtils.banner("TEST: getModifiedPageHistoryDescending()");
        for (XWikiPageHistorySummary pageHistorySummary : pageHistorySummaries) {
            System.out.format("%d %s\n", pageHistorySummary.getModified().getTime(), pageHistorySummary);
        }
        long t = Long.MAX_VALUE;
        for (XWikiPageHistorySummary pageHistorySummary : pageHistorySummaries) {
            PagesTest.assertTrue((pageHistorySummary.getModified().getTime() <= t ? 1 : 0) != 0);
            t = pageHistorySummary.getModified().getTime();
        }
        PagesTest.assertFalse((boolean)pageHistorySummaries.isEmpty());
    }

    public void testGetModifiedPagesHistoryAscending() throws Exception {
        List pageHistorySummaries = this.rpc.getModifiedPagesHistory(Integer.valueOf(50), Integer.valueOf(0), Boolean.valueOf(false));
        TestUtils.banner("TEST: getModifiedPageHistoryAscending()");
        for (XWikiPageHistorySummary pageHistorySummary : pageHistorySummaries) {
            System.out.format("%d %s\n", pageHistorySummary.getModified().getTime(), pageHistorySummary);
        }
        long t = Long.MIN_VALUE;
        for (XWikiPageHistorySummary pageHistorySummary : pageHistorySummaries) {
            PagesTest.assertTrue((pageHistorySummary.getModified().getTime() >= t ? 1 : 0) != 0);
            t = pageHistorySummary.getModified().getTime();
        }
        PagesTest.assertFalse((boolean)pageHistorySummaries.isEmpty());
    }

    public void testGetModifiedPagesHistoryMultipleRequests() throws Exception {
        ArrayList result = new ArrayList();
        List pageHistorySummaries1 = this.rpc.getModifiedPagesHistory(Integer.valueOf(10), Integer.valueOf(0), Boolean.valueOf(true));
        result.addAll(pageHistorySummaries1);
        List pageHistorySummaries2 = this.rpc.getModifiedPagesHistory(Integer.valueOf(10), Integer.valueOf(10), Boolean.valueOf(true));
        result.addAll(pageHistorySummaries2);
        List pageHistorySummaries3 = this.rpc.getModifiedPagesHistory(Integer.valueOf(10), Integer.valueOf(20), Boolean.valueOf(true));
        result.addAll(pageHistorySummaries3);
        List pageHistorySummaries = this.rpc.getModifiedPagesHistory(Integer.valueOf(30), Integer.valueOf(0), Boolean.valueOf(true));
        TestUtils.banner("TEST: getModifiedPageHistoryMultipleRequests()");
        for (int i = 0; i < pageHistorySummaries.size(); ++i) {
            XWikiPageHistorySummary h1 = (XWikiPageHistorySummary)pageHistorySummaries.get(i);
            XWikiPageHistorySummary h2 = (XWikiPageHistorySummary)result.get(i);
            PagesTest.assertTrue((boolean)h1.getId().equals(h2.getId()));
            PagesTest.assertTrue((boolean)h1.getModifier().equals(h2.getModifier()));
            PagesTest.assertTrue((boolean)h1.getModified().equals(h2.getModified()));
            PagesTest.assertTrue((h1.getVersion() == h2.getVersion() ? 1 : 0) != 0);
            PagesTest.assertTrue((h1.getMinorVersion() == h2.getMinorVersion() ? 1 : 0) != 0);
        }
        long t = Long.MAX_VALUE;
        for (XWikiPageHistorySummary pageHistorySummary : result) {
            PagesTest.assertTrue((pageHistorySummary.getModified().getTime() <= t ? 1 : 0) != 0);
            t = pageHistorySummary.getModified().getTime();
        }
    }

    public void testGetAllModifiedPagesHistory() throws Exception {
        ArrayList result = new ArrayList();
        TestUtils.banner("TEST: getAllModifiedPageHistory()");
        int start = 0;
        int number = 50;
        while (true) {
            List pageHistorySummaries = this.rpc.getModifiedPagesHistory(Integer.valueOf(number), Integer.valueOf(start), Boolean.valueOf(true));
            System.out.format("Got %d entries...\n", pageHistorySummaries.size());
            result.addAll(pageHistorySummaries);
            if (pageHistorySummaries.size() < number) break;
            start += number;
        }
        System.out.format("Total entries received: %d\n", result.size());
        long t = Long.MAX_VALUE;
        for (XWikiPageHistorySummary pageHistorySummary : result) {
            PagesTest.assertTrue((pageHistorySummary.getModified().getTime() <= t ? 1 : 0) != 0);
            t = pageHistorySummary.getModified().getTime();
        }
        PagesTest.assertFalse((boolean)result.isEmpty());
    }

    public void testGetModifiedPageHistoryCorrectness() throws Exception {
        List spaces = this.rpc.getSpaces();
        List pages = this.rpc.getPages(((SpaceSummary)spaces.get(0)).getKey());
        TestUtils.banner("TEST: getAllModifiedPageHistoryCorrectness()");
        XWikiPage page = this.rpc.getPage(((XWikiPageSummary)pages.get(0)).getId());
        System.out.format("Modifying: %s\n", page);
        page.setContent(String.format("Modified %d", System.currentTimeMillis()));
        page = this.rpc.storePage((Page)page);
        System.out.format("Modified: %s\n", page);
        List modifications = this.rpc.getModifiedPagesHistory(Integer.valueOf(25), Integer.valueOf(0));
        boolean found = false;
        System.out.format("Modifications:\n", new Object[0]);
        for (XWikiPageHistorySummary modification : modifications) {
            System.out.format("%s\n", modification);
            if (!page.getId().equals(modification.getBasePageId()) || !page.getModified().equals(modification.getModified())) continue;
            found = true;
        }
        PagesTest.assertTrue((boolean)found);
    }

    public void testStorePageWithCheckVersion() throws Exception {
        XWikiPage page = this.rpc.getPage("Test.Test");
        String content = String.format("Modified by org.xwiki.xmlrpc @ %s (This will be version: %d)\n", new Date(), page.getVersion() + 1);
        page.setContent(content);
        XWikiPage storedPage = this.rpc.storePage((Page)page);
        TestUtils.banner("TEST: storePageWithCheckVersion()");
        System.out.format("Content sent: '%s'\n", Utils.truncateToFirstLine((String)content));
        System.out.format("%s\n", storedPage);
        PagesTest.assertEquals((String)content, (String)storedPage.getContent());
        PagesTest.assertTrue((storedPage.getVersion() == page.getVersion() + 1 ? 1 : 0) != 0);
        PagesTest.assertEquals((String)page.getLanguage(), (String)storedPage.getLanguage());
        storedPage = this.rpc.storePage((Page)page, Boolean.valueOf(true));
        PagesTest.assertTrue((boolean)storedPage.getId().equals(""));
    }

    public void testStoreExistingPageUsingNullTitle() throws Exception {
        XWikiPage page = new XWikiPage();
        page.setId("Test.Test");
        String content = String.format("Modified by org.xwiki.xmlrpc @ %s\n", new Date());
        page.setContent(content);
        page = this.rpc.storePage((Page)page);
        PagesTest.assertEquals((String)"Test.Test", (String)page.getId());
        PagesTest.assertEquals((String)content, (String)page.getContent());
    }
}

