/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.xmlrpc.confluence;

import org.codehaus.swizzle.confluence.Comment;
import org.codehaus.swizzle.confluence.Page;
import org.codehaus.swizzle.confluence.Space;
import org.xwiki.test.xmlrpc.confluence.framework.AbstractXmlRpcTestCase;

public class CommentsTest
extends AbstractXmlRpcTestCase {
    private String spaceKey;
    private String pageTitle;
    private String pageId;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.spaceKey = "SomeContainerSpace";
        Space space = new Space();
        space.setKey(this.spaceKey);
        space.setName("Some Name");
        try {
            this.rpc.addSpace(space);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.pageTitle = "SomeContainerPage";
        Page p = new Page();
        p.setSpace(this.spaceKey);
        p.setTitle(this.pageTitle);
        p.setContent("");
        Page resultPage = this.rpc.storePage(p);
        this.pageId = resultPage.getId();
        Comment comment = new Comment();
        comment.setPageId(this.pageId);
        comment.setContent("Dummy Comment");
        Comment commentResult = this.rpc.addComment(comment);
        this.rpc.removeComment(commentResult.getId());
    }

    @Override
    public void tearDown() throws Exception {
        this.rpc.removePage(this.pageId);
        this.rpc.removeSpace(this.spaceKey);
        super.tearDown();
    }

    public void testAddGetComments() throws Exception {
        CommentsTest.assertEquals((int)0, (int)this.rpc.getComments(this.pageId).size());
        Comment comment = new Comment();
        comment.setPageId(this.pageId);
        comment.setContent("Comment1");
        Comment c1 = this.rpc.addComment(comment);
        CommentsTest.assertNotNull((Object)c1.getId());
        CommentsTest.assertEquals((String)this.pageId, (String)c1.getPageId());
        CommentsTest.assertEquals((String)"Comment1", (String)c1.getContent());
        CommentsTest.assertNotNull((Object)c1.getUrl());
        comment.setContent("Comment2");
        Comment c2 = this.rpc.addComment(comment);
        CommentsTest.assertNotNull((Object)c2.getId());
        CommentsTest.assertEquals((String)this.pageId, (String)c2.getPageId());
        CommentsTest.assertEquals((String)"Comment2", (String)c2.getContent());
        CommentsTest.assertNotNull((Object)c2.getUrl());
        CommentsTest.assertEquals((int)2, (int)this.rpc.getComments(this.pageId).size());
        Comment c11 = this.rpc.getComment(c1.getId());
        CommentsTest.assertEquals((String)c1.getId(), (String)c11.getId());
        CommentsTest.assertEquals((String)c1.getTitle(), (String)c11.getTitle());
        CommentsTest.assertEquals((String)c1.getPageId(), (String)c11.getPageId());
        CommentsTest.assertEquals((String)c1.getContent(), (String)c11.getContent());
        CommentsTest.assertEquals((Object)c1.getCreated(), (Object)c11.getCreated());
        CommentsTest.assertEquals((String)c1.getCreator(), (String)c11.getCreator());
        CommentsTest.assertEquals((String)c1.getUrl(), (String)c11.getUrl());
        Comment c22 = this.rpc.getComment(c2.getId());
        CommentsTest.assertEquals((String)c2.getId(), (String)c22.getId());
        CommentsTest.assertEquals((String)c2.getTitle(), (String)c22.getTitle());
        CommentsTest.assertEquals((String)c2.getPageId(), (String)c22.getPageId());
        CommentsTest.assertEquals((String)c2.getContent(), (String)c22.getContent());
        CommentsTest.assertEquals((Object)c2.getCreated(), (Object)c22.getCreated());
        CommentsTest.assertEquals((String)c2.getCreator(), (String)c22.getCreator());
        CommentsTest.assertEquals((String)c2.getUrl(), (String)c22.getUrl());
        CommentsTest.assertTrue((boolean)this.rpc.removeComment(c1.getId()));
        CommentsTest.assertEquals((int)1, (int)this.rpc.getComments(this.pageId).size());
        CommentsTest.assertNotNull((Object)c2.getId());
        CommentsTest.assertEquals((String)this.pageId, (String)c2.getPageId());
        CommentsTest.assertEquals((String)"Comment2", (String)c2.getContent());
        CommentsTest.assertNotNull((Object)c2.getUrl());
        CommentsTest.assertTrue((boolean)this.rpc.removeComment(c2.getId()));
        CommentsTest.assertEquals((int)0, (int)this.rpc.getComments(this.pageId).size());
    }
}

