/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class ClasspathUtils {
    private static final String LOADER_ID_PREFIX = "ant.loader.";
    public static final String REUSE_LOADER_REF = "ant.reuse.loader";

    public static ClassLoader getClassLoaderForPath(Project p, Reference ref) {
        return ClasspathUtils.getClassLoaderForPath(p, ref, false);
    }

    public static ClassLoader getClassLoaderForPath(Project p, Reference ref, boolean reverseLoader) {
        String pathId = ref.getRefId();
        Object path = p.getReference(pathId);
        if (!(path instanceof Path)) {
            throw new BuildException("The specified classpathref " + pathId + " does not reference a Path.");
        }
        String loaderId = LOADER_ID_PREFIX + pathId;
        return ClasspathUtils.getClassLoaderForPath(p, (Path)path, loaderId, reverseLoader);
    }

    public static ClassLoader getClassLoaderForPath(Project p, Path path, String loaderId) {
        return ClasspathUtils.getClassLoaderForPath(p, path, loaderId, false);
    }

    public static ClassLoader getClassLoaderForPath(Project p, Path path, String loaderId, boolean reverseLoader) {
        return ClasspathUtils.getClassLoaderForPath(p, path, loaderId, reverseLoader, ClasspathUtils.isMagicPropertySet(p));
    }

    public static ClassLoader getClassLoaderForPath(Project p, Path path, String loaderId, boolean reverseLoader, boolean reuseLoader) {
        ClassLoader cl = null;
        if (loaderId != null && reuseLoader) {
            Object reusedLoader = p.getReference(loaderId);
            if (reusedLoader != null && !(reusedLoader instanceof ClassLoader)) {
                throw new BuildException("The specified loader id " + loaderId + " does not reference a class loader");
            }
            cl = (ClassLoader)reusedLoader;
        }
        if (cl == null) {
            cl = ClasspathUtils.getUniqueClassLoaderForPath(p, path, reverseLoader);
            if (loaderId != null && reuseLoader) {
                p.addReference(loaderId, cl);
            }
        }
        return cl;
    }

    public static ClassLoader getUniqueClassLoaderForPath(Project p, Path path, boolean reverseLoader) {
        AntClassLoader acl = p.createClassLoader(path);
        if (reverseLoader) {
            acl.setParentFirst(false);
            acl.addJavaLibraries();
        }
        return acl;
    }

    public static Object newInstance(String className, ClassLoader userDefinedLoader) {
        try {
            Class<?> clazz = userDefinedLoader.loadClass(className);
            Object o = clazz.newInstance();
            return o;
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Class " + className + " not found by the specific classLoader.", e);
        }
        catch (InstantiationException e) {
            throw new BuildException("Could not instantiate " + className + ". Specified class should have a no " + "argument constructor.", e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException("Could not instantiate " + className + ". Specified class should have a " + "public constructor.", e);
        }
    }

    public static Delegate getDelegate(ProjectComponent component) {
        return new Delegate(component);
    }

    private static boolean isMagicPropertySet(Project p) {
        return p.getProperty(REUSE_LOADER_REF) != null;
    }

    public static class Delegate {
        private final ProjectComponent component;
        private Path classpath;
        private String classpathId;
        private String className;
        private String loaderId;
        private boolean reverseLoader = false;

        Delegate(ProjectComponent component) {
            this.component = component;
        }

        public void setClasspath(Path classpath) {
            if (this.classpath == null) {
                this.classpath = classpath;
            } else {
                this.classpath.append(classpath);
            }
        }

        public Path createClasspath() {
            if (this.classpath == null) {
                this.classpath = new Path(this.component.getProject());
            }
            return this.classpath.createPath();
        }

        public void setClassname(String fcqn) {
            this.className = fcqn;
        }

        public void setClasspathref(Reference r) {
            this.classpathId = r.getRefId();
            this.createClasspath().setRefid(r);
        }

        public void setReverseLoader(boolean reverseLoader) {
            this.reverseLoader = reverseLoader;
        }

        public void setLoaderRef(Reference r) {
            this.loaderId = r.getRefId();
        }

        public ClassLoader getClassLoader() {
            ClassLoader cl = ClasspathUtils.getClassLoaderForPath(this.getContextProject(), this.classpath, this.getClassLoadId(), this.reverseLoader, this.loaderId != null || ClasspathUtils.isMagicPropertySet(this.getContextProject()));
            return cl;
        }

        private Project getContextProject() {
            return this.component.getProject();
        }

        public String getClassLoadId() {
            if (this.loaderId == null && this.classpathId != null) {
                return ClasspathUtils.LOADER_ID_PREFIX + this.classpathId;
            }
            return this.loaderId;
        }

        public Object newInstance() {
            ClassLoader cl = this.getClassLoader();
            return ClasspathUtils.newInstance(this.className, cl);
        }

        public Path getClasspath() {
            return this.classpath;
        }

        public boolean isReverseLoader() {
            return this.reverseLoader;
        }
    }
}

