/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.tool.backup;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.packaging.Package;
import com.xpn.xwiki.plugin.packaging.PackageException;
import com.xpn.xwiki.store.XWikiCacheStore;
import com.xpn.xwiki.store.XWikiHibernateStore;
import com.xpn.xwiki.store.XWikiStoreInterface;
import com.xpn.xwiki.tool.backup.AbstractPackager;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.hibernate.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HSQLDialect;

public class Importer
extends AbstractPackager {
    public void importDocuments(File sourceDirectory, String databaseName, File hibernateConfig) throws Exception {
        XWikiContext context = this.createXWikiContext(databaseName, hibernateConfig);
        Package pack = new Package();
        pack.setWithVersions(false);
        try {
            pack.readFromDir(sourceDirectory, context);
        }
        catch (IOException e) {
            throw new PackageException(1, "Failed to import documents from [" + sourceDirectory + "]", (Throwable)e);
        }
        pack.install(context);
        this.shutdownHSQLDB(context);
    }

    private void shutdownHSQLDB(XWikiContext context) throws XWikiException {
        XWikiStoreInterface store = context.getWiki().getStore();
        if (XWikiCacheStore.class.isAssignableFrom(store.getClass())) {
            store = ((XWikiCacheStore)store).getStore();
        }
        if (XWikiHibernateStore.class.isAssignableFrom(store.getClass())) {
            XWikiHibernateStore hibernateStore = (XWikiHibernateStore)store;
            Dialect dialect = Dialect.getDialect((Properties)hibernateStore.getConfiguration().getProperties());
            if (!(dialect instanceof HSQLDialect)) {
                return;
            }
            boolean bTransaction = true;
            try {
                hibernateStore.checkHibernate(context);
                bTransaction = hibernateStore.beginTransaction(false, context);
                Session session = hibernateStore.getSession(context);
                session.connection().createStatement().execute("SHUTDOWN");
                if (bTransaction) {
                    hibernateStore.endTransaction(context, false, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PackageException(1, "Failed to shutdown database", (Throwable)e);
            }
            finally {
                try {
                    if (bTransaction) {
                        hibernateStore.endTransaction(context, false, false);
                    }
                }
                catch (Exception e) {}
            }
        }
    }
}

