/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.validator;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.validator.ValidationError;
import org.xwiki.validator.framework.AbstractDOMValidator;
import org.xwiki.validator.framework.NodeListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DutchWebGuidelinesValidator
extends AbstractDOMValidator {
    private static final String CONTENT_TYPE_META_SELECTOR = "//meta[@http-equiv='Content-Type']";
    private static final String CONTENT_CHARSET_FRAGMENT = "charset=";
    private ResourceBundle messages = ResourceBundle.getBundle("DutchWebGuidelines");

    @Override
    protected void addError(ValidationError.Type errorType, int line, int column, String key) {
        super.addError(errorType, line, column, this.messages.getString(key));
    }

    @Override
    public List<ValidationError> validate() {
        this.validateRpd1s1();
        this.validateRpd1s2();
        this.validateRpd1s3();
        this.validateRpd2s1();
        this.validateRpd2s2();
        this.validateRpd2s3();
        this.validateRpd2s4();
        this.validateRpd2s5();
        this.validateRpd2s6();
        this.validateRpd2s7();
        this.validateRpd2s8();
        this.validateRpd2s9();
        this.validateRpd3s1();
        this.validateRpd3s2();
        this.validateRpd3s3();
        this.validateRpd3s4();
        this.validateRpd3s5();
        this.validateRpd3s6();
        this.validateRpd3s7();
        this.validateRpd3s8();
        this.validateRpd3s9();
        this.validateRpd3s10();
        this.validateRpd3s11();
        this.validateRpd3s12();
        this.validateRpd3s13();
        this.validateRpd3s14();
        this.validateRpd3s15();
        this.validateRpd4s1();
        this.validateRpd4s2();
        this.validateRpd4s3();
        this.validateRpd4s4();
        this.validateRpd4s5();
        this.validateRpd4s6();
        this.validateRpd4s7();
        this.validateRpd5s1();
        this.validateRpd6s1();
        this.validateRpd6s2();
        this.validateRpd7s1();
        this.validateRpd7s2();
        this.validateRpd7s3();
        this.validateRpd7s4();
        this.validateRpd7s5();
        this.validateRpd7s6();
        this.validateRpd7s7();
        this.validateRpd8s1();
        this.validateRpd8s2();
        this.validateRpd8s3();
        this.validateRpd8s4();
        this.validateRpd8s5();
        this.validateRpd8s6();
        this.validateRpd8s7();
        this.validateRpd8s8();
        this.validateRpd8s9();
        this.validateRpd8s10();
        this.validateRpd8s11();
        this.validateRpd8s12();
        this.validateRpd8s13();
        this.validateRpd8s14();
        this.validateRpd8s15();
        this.validateRpd8s16();
        this.validateRpd8s17();
        this.validateRpd8s18();
        this.validateRpd8s19();
        this.validateRpd8s20();
        this.validateRpd8s21();
        this.validateRpd8s22();
        this.validateRpd8s23();
        this.validateRpd9s1();
        this.validateRpd9s2();
        this.validateRpd10s1();
        this.validateRpd10s2();
        this.validateRpd10s3();
        this.validateRpd11s1();
        this.validateRpd11s2();
        this.validateRpd11s3();
        this.validateRpd11s4();
        this.validateRpd11s5();
        this.validateRpd11s6();
        this.validateRpd11s7();
        this.validateRpd11s8();
        this.validateRpd11s9();
        this.validateRpd11s10();
        this.validateRpd12s1();
        this.validateRpd13s1();
        this.validateRpd13s2();
        this.validateRpd13s3();
        this.validateRpd13s4();
        this.validateRpd13s5();
        this.validateRpd13s6();
        this.validateRpd13s7();
        this.validateRpd13s8();
        this.validateRpd13s9();
        this.validateRpd13s10();
        this.validateRpd13s11();
        this.validateRpd13s12();
        this.validateRpd13s13();
        this.validateRpd13s14();
        this.validateRpd13s15();
        this.validateRpd13s16();
        this.validateRpd13s17();
        this.validateRpd13s18();
        this.validateRpd14s1();
        this.validateRpd15s1();
        this.validateRpd15s2();
        this.validateRpd15s3();
        this.validateRpd15s4();
        this.validateRpd15s5();
        this.validateRpd15s6();
        this.validateRpd15s7();
        this.validateRpd16s1();
        this.validateRpd16s2();
        this.validateRpd16s3();
        this.validateRpd16s4();
        this.validateRpd18s1();
        this.validateRpd18s2();
        this.validateRpd22s1();
        this.validateRpd22s2();
        this.validateRpd22s3();
        this.validateRpd22s4();
        this.validateRpd22s5();
        this.validateRpd22s6();
        this.validateRpd22s7();
        this.validateRpd22s8();
        this.validateRpd22s9();
        this.validateRpd22s10();
        return this.getErrors();
    }

    public void validateRpd1s1() {
    }

    public void validateRpd1s2() {
    }

    public void validateRpd1s3() {
        NodeListIterable linkElements = this.getElements("a");
        for (String hrefValue : DutchWebGuidelinesValidator.getAttributeValues(linkElements, "href")) {
            this.assertFalse(ValidationError.Type.ERROR, "rpd1s3.javascript", hrefValue.startsWith("javascript:"));
        }
        List<String> forbiddenAttributes = Arrays.asList("onblur", "onchange", "onclick", "onfocus", "onload", "onmouseover", "onselect", "onselect", "unload");
        for (Node linkElement : linkElements) {
            if (ListUtils.intersection(DutchWebGuidelinesValidator.getAttributeNames(linkElement), forbiddenAttributes).isEmpty()) continue;
            this.assertFalse(ValidationError.Type.ERROR, "rpd1s3.inlineEventHandlers", DutchWebGuidelinesValidator.getAttributeValue(linkElement, "href").equals("") || DutchWebGuidelinesValidator.getAttributeValue(linkElement, "href").equals("#"));
        }
        NodeListIterable formElements = this.getElements("form");
        for (Node formElement : formElements) {
            boolean validForm = false;
            if (this.hasChildElement(formElement, "submit")) {
                validForm = true;
            }
            for (Node input : this.getChildren(formElement, "input")) {
                if (!DutchWebGuidelinesValidator.hasAttribute(input, "type")) continue;
                if (DutchWebGuidelinesValidator.getAttributeValue(input, "type").equals("submit")) {
                    validForm = true;
                    continue;
                }
                if (!DutchWebGuidelinesValidator.getAttributeValue(input, "type").equals("image") || !DutchWebGuidelinesValidator.hasAttribute(input, "alt") || StringUtils.isEmpty((String)DutchWebGuidelinesValidator.getAttributeValue(input, "alt"))) continue;
                validForm = true;
            }
            this.assertTrue(ValidationError.Type.ERROR, "rpd1s3.formSubmit", validForm);
        }
    }

    public void validateRpd2s1() {
    }

    public void validateRpd2s2() {
    }

    public void validateRpd2s3() {
        this.assertFalse(ValidationError.Type.ERROR, "rpd2s3.noDoctype", this.document.getDoctype() == null);
    }

    public void validateRpd2s4() {
        this.assertFalse(ValidationError.Type.ERROR, "rpd2s4.noDoctype", this.document.getDoctype() == null);
    }

    public void validateRpd2s5() {
        if (this.document.getDoctype() != null) {
            this.assertFalse(ValidationError.Type.ERROR, "rpd2s5.framesetDoctype", StringUtils.containsIgnoreCase((String)this.document.getDoctype().getPublicId(), (String)"frameset"));
        }
        this.assertFalse(ValidationError.Type.ERROR, "rpd2s5.frameset", this.containsElement("frameset"));
        this.assertFalse(ValidationError.Type.ERROR, "rpd2s5.frame", this.containsElement("frame"));
    }

    public void validateRpd2s6() {
    }

    public void validateRpd2s7() {
    }

    public void validateRpd2s8() {
    }

    public void validateRpd2s9() {
    }

    public void validateRpd3s1() {
        this.assertFalse(ValidationError.Type.ERROR, "rpd3s1.boldMarkup", this.containsElement("b"));
        this.assertFalse(ValidationError.Type.ERROR, "rpd3s1.italicMarkup", this.containsElement("i"));
    }

    public void validateRpd3s2() {
        NodeListIterable h1s = this.getElements("h1");
        this.assertTrue(ValidationError.Type.ERROR, "rpd3s2.noheading", h1s.getNodeList().getLength() > 0);
        if (h1s.getNodeList().getLength() > 1) {
            this.addError(ValidationError.Type.WARNING, -1, -1, "rpd3s2.multipleh1");
        }
    }

    public void validateRpd3s3() {
        List<String> headings = Arrays.asList("h1", "h2", "h3", "h4", "h5", "h6");
        int previousLevel = 1;
        for (Node element : this.getElements(headings)) {
            int currentLevel = Integer.parseInt(element.getNodeName().substring(1));
            this.assertTrue(ValidationError.Type.ERROR, "rpd3s3.headings", currentLevel <= previousLevel + 1);
            previousLevel = currentLevel;
        }
    }

    public void validateRpd3s4() {
        for (Node br : this.getElements("br")) {
            Node currentNode;
            for (currentNode = br.getNextSibling(); currentNode != null && currentNode.getNodeType() == 3 && StringUtils.isBlank((String)currentNode.getTextContent()); currentNode = currentNode.getNextSibling()) {
            }
            if (currentNode == null) continue;
            this.assertFalse(ValidationError.Type.ERROR, "rpd3s4.linebreaks", currentNode.getNodeName().equals("br"));
        }
    }

    public void validateRpd3s5() {
        String key = "rpd3s5.invalidMarkup";
        this.assertFalse(ValidationError.Type.ERROR, key, this.containsElement("b"));
        this.assertFalse(ValidationError.Type.ERROR, key, this.containsElement("i"));
    }

    public void validateRpd3s6() {
    }

    public void validateRpd3s7() {
    }

    public void validateRpd3s8() {
    }

    public void validateRpd3s9() {
        this.assertFalse(ValidationError.Type.ERROR, "rpd3s9.sub", this.containsElement("sub"));
        this.assertFalse(ValidationError.Type.ERROR, "rpd3s9.sup", this.containsElement("sup"));
    }

    public void validateRpd3s10() {
    }

    public void validateRpd3s11() {
        this.assertFalse(ValidationError.Type.ERROR, "rpd3s11.quotation", this.containsElement("q"));
    }

    public void validateRpd3s12() {
    }

    public void validateRpd3s13() {
        for (Node br : this.getElements("br")) {
            Node previousNode = null;
            String regex = "^\\s*(\\*|-|[0-9]\\.).*";
            for (Node currentNode : new NodeListIterable(br.getParentNode().getChildNodes())) {
                Node nextNode = currentNode.getNextSibling();
                if (previousNode != null && nextNode != null) {
                    boolean currentNodeMatches = currentNode.getNodeName().equals("br");
                    boolean previousNodeMatches = previousNode.getNodeType() == 3 && previousNode.getTextContent().matches(regex);
                    boolean nextNodeMatches = nextNode.getNodeType() == 3 && nextNode.getTextContent().matches(regex);
                    this.assertFalse(ValidationError.Type.ERROR, "rpd3s13.lists", previousNodeMatches && currentNodeMatches && nextNodeMatches);
                }
                previousNode = currentNode;
            }
        }
    }

    public void validateRpd3s14() {
    }

    public void validateRpd3s15() {
    }

    public void validateRpd4s1() {
    }

    public void validateRpd4s2() {
    }

    public void validateRpd4s3() {
    }

    public void validateRpd4s4() {
    }

    public void validateRpd4s5() {
    }

    public void validateRpd4s6() {
    }

    public void validateRpd4s7() {
    }

    public void validateRpd5s1() {
    }

    public void validateRpd6s1() {
        this.assertTrue(ValidationError.Type.ERROR, "rpd6s1.doctype", StringUtils.containsIgnoreCase((String)this.document.getDoctype().getPublicId(), (String)"html"));
    }

    public void validateRpd6s2() {
    }

    public void validateRpd7s1() {
        for (Node img : this.getElements("img")) {
            this.assertTrue(ValidationError.Type.ERROR, "rpd7s1.img", DutchWebGuidelinesValidator.hasAttribute(img, "alt"));
        }
        for (Node area : this.getElements("area")) {
            this.assertTrue(ValidationError.Type.ERROR, "rpd7s1.area", DutchWebGuidelinesValidator.hasAttribute(area, "alt"));
        }
        for (Node input : this.getElements("input")) {
            if (!DutchWebGuidelinesValidator.getAttributeValue(input, "type").equals("image")) continue;
            this.assertTrue(ValidationError.Type.ERROR, "rpd7s1.input", DutchWebGuidelinesValidator.hasAttribute(input, "alt"));
        }
    }

    public void validateRpd7s2() {
    }

    public void validateRpd7s3() {
    }

    public void validateRpd7s4() {
        for (Node link : this.getElements("a")) {
            boolean hasNonEmptyAlt = false;
            for (Node child : this.getChildren(link, "img")) {
                if (StringUtils.isEmpty((String)DutchWebGuidelinesValidator.getAttributeValue(child, "alt"))) continue;
                hasNonEmptyAlt = true;
            }
            boolean hasText = false;
            for (Node linkChild : new NodeListIterable(link.getChildNodes())) {
                if (linkChild.getNodeType() != 3) continue;
                hasText = true;
            }
            this.assertTrue(ValidationError.Type.ERROR, "rpd7s4.links", hasNonEmptyAlt || hasText);
        }
    }

    public void validateRpd7s5() {
        for (Node img : this.getElements("img")) {
            if (!DutchWebGuidelinesValidator.hasAttribute(img, "usemap")) continue;
            this.assertFalse(ValidationError.Type.ERROR, "rpd7s5.img", StringUtils.isEmpty((String)DutchWebGuidelinesValidator.getAttributeValue(img, "alt")));
        }
        for (Node area : this.getElements("area")) {
            this.assertFalse(ValidationError.Type.ERROR, "rpd7s5.area", StringUtils.isEmpty((String)DutchWebGuidelinesValidator.getAttributeValue(area, "alt")));
        }
    }

    public void validateRpd7s6() {
    }

    public void validateRpd7s7() {
    }

    public void validateRpd8s1() {
        List<String> forbiddenLinkTexts = Arrays.asList(this.messages.getString("rpd8s1.forbiddenLinkTexts").split(","));
        for (Node link : this.getElements("a")) {
            for (Node linkChild : new NodeListIterable(link.getChildNodes())) {
                if (linkChild.getNodeType() != 3) continue;
                for (String forbiddenLinkText : forbiddenLinkTexts) {
                    this.assertFalse(ValidationError.Type.ERROR, "rpd8s1.link", StringUtils.containsIgnoreCase((String)linkChild.getTextContent(), (String)forbiddenLinkText));
                }
            }
        }
    }

    public void validateRpd8s2() {
    }

    public void validateRpd8s3() {
    }

    public void validateRpd8s4() {
    }

    public void validateRpd8s5() {
    }

    public void validateRpd8s6() {
    }

    public void validateRpd8s7() {
    }

    public void validateRpd8s8() {
    }

    public void validateRpd8s9() {
    }

    public void validateRpd8s10() {
    }

    public void validateRpd8s11() {
        for (Node link : this.getElements("a")) {
            if (!DutchWebGuidelinesValidator.hasAttribute(link, "accesskey")) continue;
            this.assertTrue(ValidationError.Type.ERROR, "rpd8s11.accesskey", StringUtils.isNumeric((String)DutchWebGuidelinesValidator.getAttributeValue(link, "accesskey")));
        }
    }

    public void validateRpd8s12() {
    }

    public void validateRpd8s13() {
    }

    public void validateRpd8s14() {
        for (Node link : this.getElements("a")) {
            this.assertFalse(ValidationError.Type.ERROR, "rpd8s14.target", DutchWebGuidelinesValidator.hasAttribute(link, "target"));
            if (!DutchWebGuidelinesValidator.hasAttribute(link, "onclick")) continue;
            this.assertFalse(ValidationError.Type.ERROR, "rpd8s14.window", DutchWebGuidelinesValidator.getAttributeValue(link, "onclick").contains("window.open"));
        }
    }

    public void validateRpd8s15() {
    }

    public void validateRpd8s16() {
        for (Node link : this.getElements("a")) {
            String href = DutchWebGuidelinesValidator.getAttributeValue(link, "href");
            if (href == null || !href.startsWith("mailto:")) continue;
            String email = StringUtils.substringAfter((String)href, (String)"mailto:");
            this.assertTrue(ValidationError.Type.ERROR, "rpd8s16.email", link.getTextContent().contains(email));
        }
    }

    public void validateRpd8s17() {
        for (Node link : this.getElements("a")) {
            String href = DutchWebGuidelinesValidator.getAttributeValue(link, "href");
            if (href == null || !href.startsWith("mailto:")) continue;
            String email = StringUtils.substringAfter((String)href, (String)"mailto:");
            this.assertTrue(ValidationError.Type.ERROR, "rpd8s17.email", email.matches("^[\\w\\-]([\\.\\w])+[\\w]+@([\\w\\-]+\\.)+[a-zA-Z]{2,4}$"));
        }
    }

    public void validateRpd8s18() {
    }

    public void validateRpd8s19() {
    }

    public void validateRpd8s20() {
    }

    public void validateRpd8s21() {
    }

    public void validateRpd8s22() {
    }

    public void validateRpd8s23() {
    }

    public void validateRpd9s1() {
        String exprString = "//@style";
        this.assertFalse(ValidationError.Type.ERROR, "rpd9s1.attr", (Boolean)this.evaluate(this.getElement("body"), exprString, XPathConstants.BOOLEAN));
        this.assertFalse(ValidationError.Type.ERROR, "rpd9s1.tag", this.getChildren(this.getElement("body"), "style").getNodeList().getLength() > 0);
    }

    public void validateRpd9s2() {
    }

    public void validateRpd10s1() {
    }

    public void validateRpd10s2() {
    }

    public void validateRpd10s3() {
    }

    public void validateRpd11s1() {
    }

    public void validateRpd11s2() {
        for (Node table : this.getElements("table")) {
            this.assertTrue(ValidationError.Type.ERROR, "rpd11s2.th", this.getChildrenTagNames(table).contains("th"));
        }
    }

    public void validateRpd11s3() {
    }

    private boolean hasTableHeadersAndIds(Node table) {
        boolean hasHeadersAndIds = false;
        String exprString = "//td[@headers]";
        hasHeadersAndIds = (Boolean)this.evaluate(table, exprString, XPathConstants.BOOLEAN);
        exprString = "//th[@id]";
        hasHeadersAndIds = hasHeadersAndIds && (Boolean)this.evaluate(table, exprString, XPathConstants.BOOLEAN) != false;
        return hasHeadersAndIds;
    }

    public void validateRpd11s4() {
        for (Node table : this.getElements("table")) {
            boolean hasHeadersAndIds = this.hasTableHeadersAndIds(table);
            if (hasHeadersAndIds) continue;
            for (Node th : this.getChildren(table, "th")) {
                this.assertTrue(ValidationError.Type.ERROR, "rpd11s4.scope", DutchWebGuidelinesValidator.hasAttribute(th, "scope"));
            }
        }
    }

    public void validateRpd11s5() {
        for (Node table : this.getElements("table")) {
            boolean hasScope = false;
            for (Node th : this.getChildren(table, "th")) {
                if (!DutchWebGuidelinesValidator.hasAttribute(th, "scope")) continue;
                hasScope = true;
            }
            if (hasScope) continue;
            this.assertTrue(ValidationError.Type.ERROR, "rpd11s5.headers", this.hasTableHeadersAndIds(table));
        }
    }

    public void validateRpd11s6() {
    }

    public void validateRpd11s7() {
    }

    public void validateRpd11s8() {
    }

    public void validateRpd11s9() {
    }

    public void validateRpd11s10() {
    }

    public void validateRpd12s1() {
        this.assertFalse(ValidationError.Type.ERROR, "rpd12s1.iframe", this.containsElement("iframe"));
    }

    public void validateRpd13s1() {
        String message = "rpd13s1.label";
        List<String> inputWithoutLabels = Arrays.asList("submit", "reset", "image", "button", "hidden");
        for (Node input : this.getElements("input")) {
            if (inputWithoutLabels.contains(DutchWebGuidelinesValidator.getAttributeValue(input, "type"))) continue;
            String id = DutchWebGuidelinesValidator.getAttributeValue(input, "id");
            this.assertFalse(ValidationError.Type.ERROR, message, id == null);
            if (id == null) continue;
            String exprString = "//label[@for='" + id + "']";
            this.assertTrue(ValidationError.Type.ERROR, message, (Boolean)this.evaluate(this.document, exprString, XPathConstants.BOOLEAN));
        }
    }

    public void validateRpd13s2() {
    }

    public void validateRpd13s3() {
        for (Node form : this.getElements("form")) {
            if (this.getChildrenTagNames(form).contains("fieldset")) continue;
            this.addError(ValidationError.Type.WARNING, -1, -1, "rpd13s3.fieldset");
        }
    }

    public void validateRpd13s4() {
        for (Node form : this.getElements("form")) {
            boolean hasSubmit = false;
            boolean hasDynamicSelect = false;
            String exprString = "//input[@type='submit']";
            hasSubmit = (Boolean)this.evaluate(form, exprString, XPathConstants.BOOLEAN);
            exprString = "//input[@type='image']";
            hasSubmit = hasSubmit || (Boolean)this.evaluate(this.document, exprString, XPathConstants.BOOLEAN) != false;
            this.assertTrue(ValidationError.Type.ERROR, "rpd13s4.submit", hasSubmit);
            exprString = "//select[@onchange]";
            hasDynamicSelect = (Boolean)this.evaluate(form, exprString, XPathConstants.BOOLEAN);
            if (!hasDynamicSelect) continue;
            this.addError(ValidationError.Type.WARNING, -1, -1, "rpd13s4.select");
        }
    }

    public void validateRpd13s5() {
        for (Node form : this.getElements("form")) {
            if (DutchWebGuidelinesValidator.hasAttribute(form, "onsubmit")) {
                this.addError(ValidationError.Type.WARNING, -1, -1, "rpd13s5.onsubmit");
            }
            if (!DutchWebGuidelinesValidator.hasAttribute(form, "onchange")) continue;
            this.addError(ValidationError.Type.WARNING, -1, -1, "rpd13s5.onchange");
        }
    }

    public void validateRpd13s6() {
    }

    public void validateRpd13s7() {
    }

    public void validateRpd13s8() {
    }

    public void validateRpd13s9() {
    }

    public void validateRpd13s10() {
    }

    public void validateRpd13s11() {
    }

    public void validateRpd13s12() {
    }

    public void validateRpd13s13() {
    }

    public void validateRpd13s14() {
    }

    public void validateRpd13s15() {
    }

    public void validateRpd13s16() {
    }

    public void validateRpd13s17() {
    }

    public void validateRpd13s18() {
        String exprString = "//input[@type='reset']";
        this.assertFalse(ValidationError.Type.ERROR, "rpd13s18.reset", (Boolean)this.evaluate(this.document, exprString, XPathConstants.BOOLEAN));
    }

    public void validateRpd14s1() {
    }

    public void validateRpd15s1() {
    }

    public void validateRpd15s2() {
    }

    public void validateRpd15s3() {
    }

    public void validateRpd15s4() {
    }

    public void validateRpd15s5() {
    }

    public void validateRpd15s6() {
        Node html = this.getElement("html");
        this.assertTrue(ValidationError.Type.ERROR, "rpd15s6.lang", html != null && DutchWebGuidelinesValidator.hasAttribute(html, "lang"));
    }

    public void validateRpd15s7() {
    }

    public void validateRpd16s1() {
        NodeListIterable metas = new NodeListIterable((NodeList)this.evaluate(this.document, CONTENT_TYPE_META_SELECTOR, XPathConstants.NODESET));
        this.assertTrue(ValidationError.Type.ERROR, "rpd16s1.nometa", metas.getNodeList().getLength() > 0);
        for (Node meta : metas) {
            this.assertTrue(ValidationError.Type.ERROR, "rpd16s1.charset", StringUtils.containsIgnoreCase((String)DutchWebGuidelinesValidator.getAttributeValue(meta, "content"), (String)CONTENT_CHARSET_FRAGMENT));
        }
    }

    public void validateRpd16s2() {
        NodeListIterable metas = new NodeListIterable((NodeList)this.evaluate(this.document, CONTENT_TYPE_META_SELECTOR, XPathConstants.NODESET));
        this.assertTrue(ValidationError.Type.ERROR, "rpd16s2.nometa", metas.getNodeList().getLength() > 0);
        for (Node meta : metas) {
            String content = DutchWebGuidelinesValidator.getAttributeValue(meta, "content");
            this.assertTrue(ValidationError.Type.ERROR, "rpd16s2.notutf8", StringUtils.containsIgnoreCase((String)content, (String)"charset=utf-8"));
            this.assertTrue(ValidationError.Type.ERROR, "rpd16s2.differs", StringUtils.containsIgnoreCase((String)content, (String)(CONTENT_CHARSET_FRAGMENT + this.document.getXmlEncoding())));
        }
    }

    public void validateRpd16s3() {
    }

    public void validateRpd16s4() {
        Node meta = this.getElement("meta");
        this.assertTrue(ValidationError.Type.ERROR, "rpd16s4.position", DutchWebGuidelinesValidator.hasAttribute(meta, "content") && StringUtils.containsIgnoreCase((String)DutchWebGuidelinesValidator.getAttributeValue(meta, "content"), (String)CONTENT_CHARSET_FRAGMENT));
    }

    public void validateRpd18s1() {
    }

    public void validateRpd18s2() {
    }

    public void validateRpd22s1() {
    }

    public void validateRpd22s2() {
    }

    public void validateRpd22s3() {
    }

    public void validateRpd22s4() {
    }

    public void validateRpd22s5() {
    }

    public void validateRpd22s6() {
    }

    public void validateRpd22s7() {
    }

    public void validateRpd22s8() {
    }

    public void validateRpd22s9() {
    }

    public void validateRpd22s10() {
    }
}

