/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls.internal.client.data;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.store.XWikiCacheStoreInterface;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiStoreInterface;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.activeinstalls.internal.client.PingDataProvider;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;

@Component
@Named(value="database")
@Singleton
public class DatabasePingDataProvider
implements PingDataProvider {
    private static final String PROPERTY_DB_NAME = "dbName";
    private static final String PROPERTY_DB_VERSION = "dbVersion";
    @Inject
    private Execution execution;
    @Inject
    private Logger logger;

    @Override
    public Map<String, Object> provideMapping() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "string");
        map.put("index", "not_analyzed");
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        propertiesMap.put(PROPERTY_DB_NAME, map);
        propertiesMap.put(PROPERTY_DB_VERSION, map);
        return propertiesMap;
    }

    @Override
    public Map<String, Object> provideData() {
        DatabaseMetaData metaData;
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        try {
            metaData = this.getDatabaseMetaData();
        }
        catch (Exception e) {
            this.logWarning("Failed to retrieve database metadata", e);
            metaData = null;
        }
        if (metaData != null) {
            try {
                jsonMap.put(PROPERTY_DB_NAME, metaData.getDatabaseProductName());
            }
            catch (SQLException e) {
                this.logWarning("Failed to compute the database product name", e);
            }
            try {
                jsonMap.put(PROPERTY_DB_VERSION, metaData.getDatabaseProductVersion());
            }
            catch (SQLException e) {
                this.logWarning("Failed to compute the database product version", e);
            }
        }
        return jsonMap;
    }

    private void logWarning(String explanation, Throwable e) {
        this.logger.warn("{}. This information has not been added to the Active Installs ping data. Reason [{}]", (Object)explanation, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
    }

    private DatabaseMetaData getDatabaseMetaData() {
        DatabaseMetaData metaData = null;
        XWikiContext xcontext = (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
        if (xcontext != null) {
            XWikiStoreInterface storeInterface = xcontext.getWiki().getStore();
            if (storeInterface instanceof XWikiCacheStoreInterface) {
                storeInterface = ((XWikiCacheStoreInterface)storeInterface).getStore();
            }
            if (XWikiHibernateBaseStore.class.isAssignableFrom(storeInterface.getClass())) {
                XWikiHibernateBaseStore baseStore = (XWikiHibernateBaseStore)storeInterface;
                metaData = baseStore.getDatabaseMetaData();
            }
        }
        return metaData;
    }
}

